/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.server.websocket;

import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import dev.forkhandles.time.executors.SimpleScheduler;
import dev.forkhandles.time.executors.SimpleSchedulerService;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.http4k.ai.mcp.protocol.SessionId;
import org.http4k.ai.mcp.server.protocol.ClientRequestContext;
import org.http4k.ai.mcp.server.protocol.Session;
import org.http4k.ai.mcp.server.protocol.SessionState;
import org.http4k.ai.mcp.server.protocol.Sessions;
import org.http4k.ai.mcp.server.sessions.SessionProvider;
import org.http4k.ai.mcp.util.McpJson;
import org.http4k.core.Request;
import org.http4k.format.MoshiNode;
import org.http4k.lens.Header;
import org.http4k.lens.McpExtensionsKt;
import org.http4k.sse.SseMessage;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJP\u0010\f\u001a.\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\b\u0012\u00060\u000ej\u0002`\u000f0\rj\u0016\u0012\b\u0012\u00060\u000ej\u0002`\u000f\u0012\b\u0012\u00060\u000ej\u0002`\u000f`\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000b2\n\u0010\u0013\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0013\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020\u0015H\u0002J\u0014\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\b\u0002\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/http4k/ai/mcp/server/websocket/WebsocketSessions;", "Lorg/http4k/ai/mcp/server/protocol/Sessions;", "Lorg/http4k/websocket/Websocket;", "sessionProvider", "Lorg/http4k/ai/mcp/server/sessions/SessionProvider;", "keepAliveDelay", "Ljava/time/Duration;", "<init>", "(Lorg/http4k/ai/mcp/server/sessions/SessionProvider;Ljava/time/Duration;)V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/http4k/ai/mcp/server/protocol/Session;", "respond", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/format/MoshiNode;", "Lorg/http4k/ai/mcp/util/McpNodeType;", "Ldev/forkhandles/result4k/Result4k;", "transport", "session", "message", "request", "", "context", "Lorg/http4k/ai/mcp/server/protocol/ClientRequestContext;", "onClose", "fn", "Lkotlin/Function0;", "retrieveSession", "Lorg/http4k/ai/mcp/server/protocol/SessionState;", "connectRequest", "Lorg/http4k/core/Request;", "transportFor", "assign", "end", "pruneDeadConnections", "start", "Ljava/util/concurrent/ScheduledFuture;", "executor", "Ldev/forkhandles/time/executors/SimpleScheduler;", "http4k-ai-mcp-sdk"})
@SourceDebugExtension(value={"SMAP\nWebsocketSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebsocketSessions.kt\norg/http4k/ai/mcp/server/websocket/WebsocketSessions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1#2:78\n1869#3,2:79\n*S KotlinDebug\n*F\n+ 1 WebsocketSessions.kt\norg/http4k/ai/mcp/server/websocket/WebsocketSessions\n*L\n65#1:79,2\n*E\n"})
public final class WebsocketSessions
implements Sessions<Websocket> {
    @NotNull
    private final SessionProvider sessionProvider;
    @NotNull
    private final Duration keepAliveDelay;
    @NotNull
    private final ConcurrentHashMap<Session, Websocket> sessions;

    public WebsocketSessions(@NotNull SessionProvider sessionProvider, @NotNull Duration keepAliveDelay) {
        Intrinsics.checkNotNullParameter((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkNotNullParameter((Object)keepAliveDelay, (String)"keepAliveDelay");
        this.sessionProvider = sessionProvider;
        this.keepAliveDelay = keepAliveDelay;
        this.sessions = new ConcurrentHashMap();
    }

    public /* synthetic */ WebsocketSessions(SessionProvider sessionProvider, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sessionProvider = SessionProvider.Companion.Random((Random)Random.Default);
        }
        if ((n & 2) != 0) {
            Duration duration2 = Duration.ofSeconds(2L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        this(sessionProvider, duration);
    }

    @Override
    @NotNull
    public Result<MoshiNode, MoshiNode> respond(@NotNull Websocket transport, @NotNull Session session, @NotNull MoshiNode message) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        transport.send(new WsMessage(new SseMessage.Event("message", McpJson.INSTANCE.compact((Object)message), null, 4, null).toMessage(), null, 2, null));
        return (Result)new Success((Object)message);
    }

    @Override
    public void request(@NotNull ClientRequestContext context, @NotNull MoshiNode message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Websocket ws = this.sessions.get(context.getSession());
        if (ws != null) {
            ws.send(new WsMessage(new SseMessage.Event("message", McpJson.INSTANCE.compact((Object)message), null, 4, null).toMessage(), null, 2, null));
        }
    }

    @Override
    public void onClose(@NotNull ClientRequestContext context, @NotNull Function0<Unit> fn) {
        block0: {
            Websocket websocket;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            Websocket websocket2 = this.sessions.get(context.getSession());
            if (websocket2 == null) break block0;
            Websocket it = websocket = websocket2;
            boolean bl = false;
            it.onClose(arg_0 -> WebsocketSessions.onClose$lambda$1$lambda$0(fn, arg_0));
        }
    }

    @Override
    @NotNull
    public SessionState retrieveSession(@NotNull Request connectRequest) {
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        return this.sessionProvider.validate(connectRequest, (SessionId)McpExtensionsKt.getMCP_SESSION_ID((Header)Header.INSTANCE).invoke((Object)connectRequest));
    }

    @Override
    @NotNull
    public Websocket transportFor(@NotNull ClientRequestContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Websocket websocket = this.sessions.get(context.getSession());
        if (websocket == null) {
            throw new IllegalStateException("Session not found".toString());
        }
        return websocket;
    }

    @Override
    public void assign(@NotNull ClientRequestContext context, @NotNull Websocket transport, @NotNull Request connectRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        if (context instanceof ClientRequestContext.Subscription) {
            ((Map)this.sessions).put(((ClientRequestContext.Subscription)context).getSession(), transport);
        }
    }

    @Override
    public void end(@NotNull ClientRequestContext context) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(context instanceof ClientRequestContext.Subscription)) break block1;
            Websocket websocket = this.sessions.remove(((ClientRequestContext.Subscription)context).getSession());
            if (websocket != null) {
                Websocket.close$default((Websocket)websocket, null, (int)1, null);
            }
        }
    }

    private final void pruneDeadConnections() {
        Iterable $this$forEach$iv = MapsKt.toList((Map)this.sessions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Session session = (Session)pair.component1();
            Websocket sink = (Websocket)pair.component2();
            try {
                sink.send(new WsMessage(new SseMessage.Event("ping", "", null, 4, null).toMessage(), null, 2, null));
            }
            catch (Exception e) {
                this.sessions.remove(session);
                Websocket.close$default((Websocket)sink, null, (int)1, null);
            }
        }
    }

    @NotNull
    public final ScheduledFuture<?> start(@NotNull SimpleScheduler executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return executor.scheduleWithFixedDelay(this::pruneDeadConnections, this.keepAliveDelay, this.keepAliveDelay);
    }

    public static /* synthetic */ ScheduledFuture start$default(WebsocketSessions websocketSessions, SimpleScheduler simpleScheduler, int n, Object object) {
        if ((n & 1) != 0) {
            simpleScheduler = (SimpleScheduler)new SimpleSchedulerService(1);
        }
        return websocketSessions.start(simpleScheduler);
    }

    private static final Unit onClose$lambda$1$lambda$0(Function0 $fn, WsStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $fn.invoke();
        return Unit.INSTANCE;
    }

    public WebsocketSessions() {
        this(null, null, 3, null);
    }
}

