package org.http4k.graphql

import graphql.ExceptionWhileDataFetching
import graphql.ExecutionResult
import org.http4k.core.Body
import org.http4k.format.Jackson.asA
import org.http4k.format.Jackson.asJsonObject
import org.http4k.format.Jackson.auto

typealias GraphQLHandler = (GraphQLRequest) -> GraphQLResponse

typealias GraphQLWithContextHandler<T> = (GraphQLRequest, T) -> GraphQLResponse

data class GraphQLRequest(
    val query: String = "",
    val operationName: String? = null,
    val variables: Map<String, Any>? = emptyMap()
) {
    companion object {
        val requestLens = Body.auto<GraphQLRequest>().toLens()
    }
}

data class GraphQLResponse(
    val data: Any?,
    val errors: List<Map<String, Any>>?,
    val extensions: Map<String, Any>? = null) {
    companion object {
        fun from(executionResult: ExecutionResult) = with(executionResult) {
            val errorList: List<Map<String, Any>>? = executionResult.errors
                .takeIf { it.isNotEmpty() }
                ?.run { distinctBy { if (it is ExceptionWhileDataFetching) it.exception else it } }
                ?.let { asJsonObject(it).asA() }

            GraphQLResponse(
                try {
                    getData<Any>()
                } catch (e: Exception) {
                    null
                },
                errorList,
                extensions
                    ?.takeIf {it.isNotEmpty() }
                    ?.let { asJsonObject(it).asA() }
            )
        }

        val responseLens = Body.auto<GraphQLResponse>().toLens()
    }
}
