/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.jsonrpc;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.ContentType;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.filter.ServerFilters;
import org.http4k.format.Json;
import org.http4k.format.JsonRpcExtensionsKt;
import org.http4k.jsonrpc.ErrorMessage;
import org.http4k.jsonrpc.JsonRpcMethodBinding;
import org.http4k.jsonrpc.RoutingJsonRpcHandler;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.ContentNegotiation;
import org.http4k.lens.Header;
import org.http4k.lens.LensFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0002j\u0002`\bB#\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\r\u0010\u000eBK\b\u0016\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0002j\u0002`\u0012\u0012\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u00150\u0014\u00a2\u0006\u0004\b\r\u0010\u0016J\u0011\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0003H\u0096\u0002J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u00c2\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u00c2\u0003J/\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0019\u001a!\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00070\u0002j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/http4k/jsonrpc/JsonRpcService;", "NODE", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "processor", "Lorg/http4k/jsonrpc/RoutingJsonRpcHandler;", "json", "Lorg/http4k/format/Json;", "<init>", "(Lorg/http4k/jsonrpc/RoutingJsonRpcHandler;Lorg/http4k/format/Json;)V", "errorHandler", "", "Lorg/http4k/jsonrpc/ErrorMessage;", "Lorg/http4k/jsonrpc/ErrorHandler;", "bindings", "", "Lorg/http4k/jsonrpc/JsonRpcMethodBinding;", "(Lorg/http4k/format/Json;Lkotlin/jvm/functions/Function1;Ljava/lang/Iterable;)V", "jsonLens", "Lorg/http4k/lens/BiDiBodyLens;", "handler", "invoke", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "http4k-api-jsonrpc"})
public final class JsonRpcService<NODE>
implements Function1<Request, Response> {
    @NotNull
    private final RoutingJsonRpcHandler<NODE> processor;
    @NotNull
    private final Json<NODE> json;
    @NotNull
    private final BiDiBodyLens<NODE> jsonLens;
    @NotNull
    private final Function1<Request, Response> handler;

    public JsonRpcService(@NotNull RoutingJsonRpcHandler<NODE> processor, @NotNull Json<NODE> json) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter(json, (String)"json");
        this.processor = processor;
        this.json = json;
        this.jsonLens = this.json.body("JSON-RPC request", ContentNegotiation.Companion.getStrictNoDirective()).toLens();
        this.handler = Http4kKt.then((Filter)Http4kKt.then((Filter)ServerFilters.INSTANCE.CatchLensFailure(arg_0 -> JsonRpcService.handler$lambda$0(this, arg_0)), JsonRpcService::handler$lambda$2), arg_0 -> JsonRpcService.handler$lambda$3(this, arg_0));
    }

    public JsonRpcService(@NotNull Json<NODE> json, @NotNull Function1<? super Throwable, ? extends ErrorMessage> errorHandler, @NotNull Iterable<JsonRpcMethodBinding<NODE, NODE>> bindings) {
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        this(new RoutingJsonRpcHandler<NODE>(json, errorHandler, bindings), json);
    }

    @NotNull
    public Response invoke(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (Response)this.handler.invoke((Object)request);
    }

    private final RoutingJsonRpcHandler<NODE> component1() {
        return this.processor;
    }

    private final Json<NODE> component2() {
        return this.json;
    }

    @NotNull
    public final JsonRpcService<NODE> copy(@NotNull RoutingJsonRpcHandler<NODE> processor, @NotNull Json<NODE> json) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter(json, (String)"json");
        return new JsonRpcService<NODE>(processor, json);
    }

    public static /* synthetic */ JsonRpcService copy$default(JsonRpcService jsonRpcService, RoutingJsonRpcHandler routingJsonRpcHandler, Json json, int n, Object object) {
        if ((n & 1) != 0) {
            routingJsonRpcHandler = jsonRpcService.processor;
        }
        if ((n & 2) != 0) {
            json = jsonRpcService.json;
        }
        return jsonRpcService.copy(routingJsonRpcHandler, json);
    }

    @NotNull
    public String toString() {
        return "JsonRpcService(processor=" + this.processor + ", json=" + this.json + ")";
    }

    public int hashCode() {
        int result = this.processor.hashCode();
        result = result * 31 + this.json.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonRpcService)) {
            return false;
        }
        JsonRpcService jsonRpcService = (JsonRpcService)other;
        if (!Intrinsics.areEqual(this.processor, jsonRpcService.processor)) {
            return false;
        }
        return Intrinsics.areEqual(this.json, jsonRpcService.json);
    }

    private static final Response handler$lambda$0(JsonRpcService this$0, LensFailure lensFailure) {
        Intrinsics.checkNotNullParameter((Object)lensFailure, (String)"<unused var>");
        Function1[] function1Array = new Function1[]{this$0.jsonLens.of(JsonRpcExtensionsKt.renderError$default(this$0.json, ErrorMessage.Companion.getParseError(), null, 2, null))};
        return (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null)), (Function1[])function1Array);
    }

    private static final Response handler$lambda$2$lambda$1(Function1 $next, Request it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMethod() == Method.POST ? (Response)$next.invoke((Object)it) : Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.METHOD_NOT_ALLOWED, null, (int)2, null);
    }

    private static final Function1 handler$lambda$2(Function1 next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return arg_0 -> JsonRpcService.handler$lambda$2$lambda$1(next, arg_0);
    }

    private static final Response handler$lambda$3(JsonRpcService this$0, Request it) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object responseJson = this$0.processor.invoke(this$0.jsonLens.invoke((HttpMessage)it));
        if (responseJson == null) {
            Function1[] function1Array = new Function1[]{Header.INSTANCE.getCONTENT_TYPE().of((Object)ContentType.Companion.getAPPLICATION_JSON())};
            response = (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NO_CONTENT, null, (int)2, null)), (Function1[])function1Array);
        } else {
            Function1[] function1Array = new Function1[]{this$0.jsonLens.of(responseJson)};
            response = (Response)HttpKt.with((HttpMessage)((HttpMessage)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null)), (Function1[])function1Array);
        }
        return response;
    }
}

