/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.jsonrpc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.http4k.format.Json;
import org.http4k.format.JsonRpcExtensionsKt;
import org.http4k.format.JsonType;
import org.http4k.jsonrpc.ErrorMessage;
import org.http4k.jsonrpc.JsonRpcMethodBinding;
import org.http4k.jsonrpc.JsonRpcRequest;
import org.http4k.lens.Failure;
import org.http4k.lens.LensFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\"\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002j\u0010\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u0001`\u0003BI\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0002j\u0002`\t\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00028\u00000\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017J5\u0010\u0018\u001a\u0004\u0018\u00018\u0000*\b\u0012\u0004\u0012\u00028\u00000\u00192\u001a\u0010\u001a\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0002H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u0004\u0018\u00018\u00002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u0004\u0018\u00018\u0000*\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0002j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0002j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000`\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/http4k/jsonrpc/RoutingJsonRpcHandler;", "NODE", "Lkotlin/Function1;", "Lorg/http4k/jsonrpc/JsonRpcHandler;", "json", "Lorg/http4k/format/Json;", "errorHandler", "", "Lorg/http4k/jsonrpc/ErrorMessage;", "Lorg/http4k/jsonrpc/ErrorHandler;", "bindings", "", "Lorg/http4k/jsonrpc/JsonRpcMethodBinding;", "<init>", "(Lorg/http4k/format/Json;Lkotlin/jvm/functions/Function1;Ljava/lang/Iterable;)V", "methods", "", "", "invoke", "requestJson", "(Ljava/lang/Object;)Ljava/lang/Object;", "processSingleRequest", "fields", "(Ljava/util/Map;)Ljava/lang/Object;", "mapIfValid", "Lorg/http4k/jsonrpc/JsonRpcRequest;", "block", "(Lorg/http4k/jsonrpc/JsonRpcRequest;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "processBatchRequest", "elements", "", "(Ljava/util/List;)Ljava/lang/Object;", "processEachAsSingleRequest", "http4k-api-jsonrpc"})
@SourceDebugExtension(value={"SMAP\nRoutingJsonRpcHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingJsonRpcHandler.kt\norg/http4k/jsonrpc/RoutingJsonRpcHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1193#2,2:66\n1267#2,4:68\n1617#2,9:73\n1869#2:82\n1870#2:84\n1626#2:85\n1#3:72\n1#3:83\n*S KotlinDebug\n*F\n+ 1 RoutingJsonRpcHandler.kt\norg/http4k/jsonrpc/RoutingJsonRpcHandler\n*L\n20#1:66,2\n20#1:68,4\n60#1:73,9\n60#1:82\n60#1:84\n60#1:85\n60#1:83\n*E\n"})
public final class RoutingJsonRpcHandler<NODE>
implements Function1<NODE, NODE> {
    @NotNull
    private final Json<NODE> json;
    @NotNull
    private final Function1<Throwable, ErrorMessage> errorHandler;
    @NotNull
    private final Map<String, Function1<NODE, NODE>> methods;

    /*
     * WARNING - void declaration
     */
    public RoutingJsonRpcHandler(@NotNull Json<NODE> json, @NotNull Function1<? super Throwable, ? extends ErrorMessage> errorHandler, @NotNull Iterable<JsonRpcMethodBinding<NODE, NODE>> bindings) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(json, (String)"json");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        this.json = json;
        this.errorHandler = errorHandler;
        Iterable<JsonRpcMethodBinding<NODE, NODE>> iterable = bindings;
        RoutingJsonRpcHandler routingJsonRpcHandler = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            JsonRpcMethodBinding it = (JsonRpcMethodBinding)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), it.getHandler());
            map.put(pair.getFirst(), pair.getSecond());
        }
        routingJsonRpcHandler.methods = destination$iv$iv;
    }

    @Nullable
    public NODE invoke(NODE requestJson) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.json.typeOf(requestJson).ordinal()]) {
            case 1 -> this.processSingleRequest(MapsKt.toMap((Iterable)this.json.fields(requestJson)));
            case 2 -> this.processBatchRequest(CollectionsKt.toList((Iterable)this.json.elements(requestJson)));
            default -> JsonRpcExtensionsKt.renderError$default(this.json, ErrorMessage.Companion.getInvalidRequest(), null, 2, null);
        };
    }

    private final NODE processSingleRequest(Map<String, ? extends NODE> fields) {
        return this.mapIfValid(new JsonRpcRequest<NODE>(this.json, fields), arg_0 -> RoutingJsonRpcHandler.processSingleRequest$lambda$0(this, arg_0));
    }

    private final NODE mapIfValid(JsonRpcRequest<NODE> $this$mapIfValid, Function1<? super JsonRpcRequest<NODE>, ? extends NODE> block) {
        return (NODE)($this$mapIfValid.valid() ? block.invoke($this$mapIfValid) : JsonRpcExtensionsKt.renderError(this.json, ErrorMessage.Companion.getInvalidRequest(), $this$mapIfValid.getId()));
    }

    private final NODE processBatchRequest(List<? extends NODE> elements) {
        List<? extends NODE> $this$processBatchRequest_u24lambda_u240 = elements;
        boolean bl = false;
        return (NODE)(!((Collection)$this$processBatchRequest_u24lambda_u240).isEmpty() ? this.processEachAsSingleRequest($this$processBatchRequest_u24lambda_u240) : JsonRpcExtensionsKt.renderError$default(this.json, ErrorMessage.Companion.getInvalidRequest(), null, 2, null));
    }

    private final NODE processEachAsSingleRequest(List<? extends NODE> $this$processEachAsSingleRequest) {
        return (NODE)this.json.invoke(arg_0 -> RoutingJsonRpcHandler.processEachAsSingleRequest$lambda$0($this$processEachAsSingleRequest, this, arg_0));
    }

    private static final Object processSingleRequest$lambda$0(RoutingJsonRpcHandler this$0, JsonRpcRequest request) {
        Object NODE;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            Object object;
            Function1 method = this$0.methods.get(request.getMethod());
            if (method == null) {
                object = JsonRpcExtensionsKt.renderError(this$0.json, ErrorMessage.Companion.getMethodNotFound(), request.getId());
            } else {
                Object object2 = request.getParams();
                if (object2 == null) {
                    object2 = this$0.json.nullNode();
                }
                Object $this$processSingleRequest_u24lambda_u240_u240 = method.invoke(object2);
                boolean bl = false;
                Object NODE2 = request.getId();
                if (NODE2 != null) {
                    Object it = NODE2;
                    boolean bl2 = false;
                    object = JsonRpcExtensionsKt.renderResult(this$0.json, $this$processSingleRequest_u24lambda_u240_u240, it);
                } else {
                    object = null;
                }
            }
            NODE = object;
        }
        catch (Exception e) {
            Object NODE3;
            if (e instanceof LensFailure) {
                ErrorMessage errorMessage;
                Function1<Throwable, ErrorMessage> function1 = this$0.errorHandler;
                Exception exception = ((LensFailure)e).getCause();
                if (exception == null) {
                    exception = e;
                }
                if ((errorMessage = (ErrorMessage)function1.invoke((Object)exception)) == null) {
                    errorMessage = ((LensFailure)e).overall() == Failure.Type.Invalid ? ErrorMessage.Companion.getInvalidParams() : ErrorMessage.Companion.getInternalError();
                }
                ErrorMessage errorMessage2 = errorMessage;
                NODE3 = JsonRpcExtensionsKt.renderError(this$0.json, errorMessage2, request.getId());
            } else {
                Json json = this$0.json;
                ErrorMessage errorMessage = (ErrorMessage)this$0.errorHandler.invoke((Object)e);
                if (errorMessage == null) {
                    errorMessage = ErrorMessage.Companion.getInternalError();
                }
                NODE3 = JsonRpcExtensionsKt.renderError(json, errorMessage, request.getId());
            }
            NODE = NODE3;
        }
        return NODE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object processEachAsSingleRequest$lambda$0(List $this_processEachAsSingleRequest, RoutingJsonRpcHandler this$0, Json $this$json) {
        Object object;
        List list;
        List list2;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$json, (String)"$this$json");
        Iterable $this$mapNotNull$iv = $this_processEachAsSingleRequest;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object it = element$iv$iv;
            boolean bl2 = false;
            if (this$0.processSingleRequest($this$json.typeOf(it) == JsonType.Object ? MapsKt.toMap((Iterable)$this$json.fields(it)) : MapsKt.emptyMap()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list2 = (List)destination$iv$iv;
        boolean bl = false;
        List list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list != null) {
            it = list;
            boolean bl4 = false;
            object = $this$json.array((Iterable)it);
        } else {
            object = null;
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonType.values().length];
            try {
                nArray[JsonType.Object.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonType.Array.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

