/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.contract;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.contract.ContractRoute;
import org.http4k.contract.ContractRouteKt;
import org.http4k.contract.ContractRouteSpec;
import org.http4k.contract.ContractRouter;
import org.http4k.contract.ContractRouterMatch;
import org.http4k.contract.ExtractedParts;
import org.http4k.contract.PathSegments;
import org.http4k.contract.PathSegmentsKt;
import org.http4k.contract.PreFlightExtraction;
import org.http4k.contract.PreFlightExtractionFilterKt;
import org.http4k.contract.Root;
import org.http4k.contract.RouteMeta;
import org.http4k.contract.Tag;
import org.http4k.contract.openapi.ExtKt;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.http4k.core.Uri;
import org.http4k.filter.ServerFilters;
import org.http4k.lens.LensFailure;
import org.http4k.lens.Meta;
import org.http4k.routing.RouterDescription;
import org.http4k.security.Security;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u0007BT\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00121\u0010\u000e\u001a-\u0012\u0004\u0012\u00020\u000f\u0012#\u0012!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00070\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010'\u001a\u00020(J\u0011\u0010+\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0096\u0002J\u0015\u0010,\u001a\u00020*2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020*H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R?\u0010\u000e\u001a-\u0012\u0004\u0012\u00020\u000f\u0012#\u0012!\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00070\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001e\u00a8\u0006/"}, d2={"Lorg/http4k/contract/ContractRoute;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lkotlin/ParameterName;", "name", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "method", "Lorg/http4k/core/Method;", "spec", "Lorg/http4k/contract/ContractRouteSpec;", "meta", "Lorg/http4k/contract/RouteMeta;", "toHandler", "Lorg/http4k/contract/ExtractedParts;", "<init>", "(Lorg/http4k/core/Method;Lorg/http4k/contract/ContractRouteSpec;Lorg/http4k/contract/RouteMeta;Lkotlin/jvm/functions/Function1;)V", "getMethod", "()Lorg/http4k/core/Method;", "getSpec", "()Lorg/http4k/contract/ContractRouteSpec;", "getMeta", "()Lorg/http4k/contract/RouteMeta;", "getToHandler$http4k_api_openapi", "()Lkotlin/jvm/functions/Function1;", "nonBodyParams", "", "Lorg/http4k/lens/Meta;", "getNonBodyParams", "()Ljava/util/List;", "tags", "Lorg/http4k/contract/Tag;", "getTags", "newRequest", "baseUri", "Lorg/http4k/core/Uri;", "toRouter", "Lorg/http4k/contract/ContractRouter;", "contractRoot", "Lorg/http4k/contract/PathSegments;", "describeFor", "", "invoke", "operationId", "operationId$http4k_api_openapi", "toString", "http4k-api-openapi"})
@SourceDebugExtension(value={"SMAP\nContractRoute.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractRoute.kt\norg/http4k/contract/ContractRoute\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1056#2:111\n*S KotlinDebug\n*F\n+ 1 ContractRoute.kt\norg/http4k/contract/ContractRoute\n*L\n36#1:111\n*E\n"})
public final class ContractRoute
implements Function1<Request, Response> {
    @NotNull
    private final Method method;
    @NotNull
    private final ContractRouteSpec spec;
    @NotNull
    private final RouteMeta meta;
    @NotNull
    private final Function1<ExtractedParts, Function1<Request, Response>> toHandler;
    @NotNull
    private final List<Meta> nonBodyParams;
    @NotNull
    private final List<Tag> tags;

    public ContractRoute(@NotNull Method method, @NotNull ContractRouteSpec spec, @NotNull RouteMeta meta, @NotNull Function1<? super ExtractedParts, ? extends Function1<? super Request, ? extends Response>> toHandler) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        Intrinsics.checkNotNullParameter(toHandler, (String)"toHandler");
        this.method = method;
        this.spec = spec;
        this.meta = meta;
        this.toHandler = toHandler;
        this.nonBodyParams = CollectionsKt.flatten((Iterable)CollectionsKt.plus((Collection)this.meta.getRequestParams(), (Object[])this.spec.getPathLenses()));
        Iterable $this$sortedBy$iv = CollectionsKt.toSet((Iterable)this.meta.getTags());
        boolean $i$f$sortedBy = false;
        this.tags = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Tag it = (Tag)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Tag)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final ContractRouteSpec getSpec() {
        return this.spec;
    }

    @NotNull
    public final RouteMeta getMeta() {
        return this.meta;
    }

    @NotNull
    public final Function1<ExtractedParts, Function1<Request, Response>> getToHandler$http4k_api_openapi() {
        return this.toHandler;
    }

    @NotNull
    public final List<Meta> getNonBodyParams() {
        return this.nonBodyParams;
    }

    @NotNull
    public final List<Tag> getTags() {
        return this.tags;
    }

    @NotNull
    public final Request newRequest(@NotNull Uri baseUri) {
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        return Request.Companion.create$default((Request.Companion)Request.Companion, (Method)this.method, (String)"", null, (int)4, null).uri(baseUri.path(this.spec.describe$http4k_api_openapi(Root.INSTANCE)));
    }

    @NotNull
    public final ContractRouter toRouter(@NotNull PathSegments contractRoot) {
        Intrinsics.checkNotNullParameter((Object)contractRoot, (String)"contractRoot");
        return new ContractRouter(this, contractRoot){
            private final String description;
            final /* synthetic */ ContractRoute this$0;
            final /* synthetic */ PathSegments $contractRoot;
            {
                this.this$0 = $receiver;
                this.$contractRoot = $contractRoot;
                this.description = $receiver.getSpec().describe$http4k_api_openapi($contractRoot);
            }

            public String toString() {
                return this.getDescription();
            }

            public String getDescription() {
                return this.description;
            }

            public ContractRouterMatch match(Request request) {
                ContractRouterMatch contractRouterMatch;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                if ((request.getMethod() == Method.OPTIONS || request.getMethod() == this.this$0.getMethod()) && PathSegmentsKt.pathSegments(request).startsWith((PathSegments)this.this$0.getSpec().getPathFn().invoke((Object)this.$contractRoot))) {
                    Object object;
                    try {
                        ContractRouterMatch contractRouterMatch2;
                        object = ContractRouteKt.access$extract(PathSegmentsKt.without(request, (PathSegments)this.this$0.getSpec().getPathFn().invoke((Object)this.$contractRoot)), ArraysKt.toList((Object[])this.this$0.getSpec().getPathLenses()));
                        if (object != null) {
                            Object object2 = object;
                            ContractRoute contractRoute = this.this$0;
                            Object it = object2;
                            boolean bl = false;
                            contractRouterMatch2 = new ContractRouterMatch.MatchingHandler(RouterDescription.Companion.getUnavailable(), (Function1<? super Request, ? extends Response>)(request.getMethod() == Method.OPTIONS ? toRouter.1::match$lambda$1$lambda$0 : (Function1)contractRoute.getToHandler$http4k_api_openapi().invoke(it)));
                        } else {
                            contractRouterMatch2 = ContractRouterMatch.Unmatched.INSTANCE;
                        }
                        object = contractRouterMatch2;
                    }
                    catch (LensFailure e) {
                        object = ContractRouterMatch.Unmatched.INSTANCE;
                    }
                    contractRouterMatch = object;
                } else {
                    contractRouterMatch = ContractRouterMatch.Unmatched.INSTANCE;
                }
                return contractRouterMatch;
            }

            private static final Response match$lambda$1$lambda$0(Request it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.OK, null, (int)2, null);
            }
        };
    }

    @NotNull
    public final String describeFor(@NotNull PathSegments contractRoot) {
        Intrinsics.checkNotNullParameter((Object)contractRoot, (String)"contractRoot");
        return this.spec.describe$http4k_api_openapi(contractRoot);
    }

    @NotNull
    public Response invoke(@NotNull Request request) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ContractRouterMatch matchResult = this.toRouter(Root.INSTANCE).match(request);
        if (matchResult instanceof ContractRouterMatch.MatchingHandler) {
            Security security = this.meta.getSecurity();
            if (security == null || (security = security.getFilter()) == null) {
                security = Http4kKt.getNoOp((Filter.Companion)Filter.Companion);
            }
            response = (Response)Http4kKt.then((Filter)Http4kKt.then((Filter)Http4kKt.then((Filter)security, (Filter)ServerFilters.INSTANCE.CatchLensFailure(ContractRoute::invoke$lambda$1)), (Filter)PreFlightExtractionFilterKt.PreFlightExtractionFilter(this.meta, PreFlightExtraction.Companion.getAll())), (Function1)((Function1)matchResult)).invoke((Object)request);
        } else if (matchResult instanceof ContractRouterMatch.MethodNotMatched) {
            response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.METHOD_NOT_ALLOWED, null, (int)2, null);
        } else if (matchResult instanceof ContractRouterMatch.Unmatched) {
            response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
        } else if (matchResult instanceof ContractRouterMatch.MatchedWithoutHandler) {
            response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.NOT_FOUND, null, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return response;
    }

    @NotNull
    public final String operationId$http4k_api_openapi(@NotNull PathSegments contractRoot) {
        Intrinsics.checkNotNullParameter((Object)contractRoot, (String)"contractRoot");
        return ExtKt.operationId(this.meta, this.method, this.describeFor(contractRoot));
    }

    @NotNull
    public String toString() {
        return this.method.name() + ": " + this.spec.describe$http4k_api_openapi(Root.INSTANCE);
    }

    private static final Response invoke$lambda$1(LensFailure lensFailure) {
        Intrinsics.checkNotNullParameter((Object)lensFailure, (String)"<unused var>");
        return Response.Companion.create$default((Response.Companion)Response.Companion, (Status)Status.BAD_REQUEST, null, (int)2, null);
    }
}

