/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.contract;

import com.natpryce.hamkrest.Core_matchersKt;
import com.natpryce.hamkrest.Matcher;
import com.natpryce.hamkrest.assertion.AssertKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.contract.JsonErrorResponseRenderer;
import org.http4k.core.Response;
import org.http4k.format.Json;
import org.http4k.lens.Failure;
import org.http4k.lens.Invalid;
import org.http4k.lens.LensFailure;
import org.http4k.lens.Meta;
import org.http4k.lens.Missing;
import org.http4k.lens.ParamMeta;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/http4k/contract/JsonErrorResponseRendererContract;", "NODE", "", "j", "Lorg/http4k/format/Json;", "<init>", "(Lorg/http4k/format/Json;)V", "getJ", "()Lorg/http4k/format/Json;", "can build 400", "", "can build 404", "http4k-api-openapi_testFixtures"})
public abstract class JsonErrorResponseRendererContract<NODE> {
    @NotNull
    private final Json<NODE> j;

    public JsonErrorResponseRendererContract(@NotNull Json<NODE> j) {
        Intrinsics.checkNotNullParameter(j, (String)"j");
        this.j = j;
    }

    @NotNull
    public final Json<NODE> getJ() {
        return this.j;
    }

    @Test
    public final void can build 400() {
        Object[] objectArray = new Failure[]{new Missing(new Meta(true, "location1", (ParamMeta)new ParamMeta.ArrayParam((ParamMeta)ParamMeta.StringParam.INSTANCE), "name1", null, MapsKt.emptyMap())), new Invalid(new Meta(false, "location2", (ParamMeta)ParamMeta.NumberParam.INSTANCE, "name2", null, MapsKt.emptyMap()))};
        Response response = new JsonErrorResponseRenderer(this.j).badRequest(new LensFailure(CollectionsKt.listOf((Object[])objectArray), null, null, null, 10, null));
        AssertKt.assertThat$default((Object)response.bodyString(), (Matcher)Core_matchersKt.equalTo((Object)"{\"message\":\"Missing/invalid parameters\",\"params\":[{\"name\":\"name1\",\"type\":\"location1\",\"datatype\":\"[string]\",\"required\":true,\"reason\":\"Missing\"},{\"name\":\"name2\",\"type\":\"location2\",\"datatype\":\"number\",\"required\":false,\"reason\":\"Invalid\"}]}"), null, (int)4, null);
    }

    @Test
    public final void can build 404() {
        Response response = new JsonErrorResponseRenderer(this.j).notFound();
        AssertKt.assertThat$default((Object)response.bodyString(), (Matcher)Core_matchersKt.equalTo((Object)"{\"message\":\"No route found on this path. Have you used the correct HTTP verb?\"}"), null, (int)4, null);
    }
}

