/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.http4k.KotlinExtensionsKt;
import org.http4k.aws.AwsHmacSha256;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/http4k/aws/AwsCanonicalRequest;", "", "value", "", "signedHeaders", "payloadHash", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPayloadHash", "()Ljava/lang/String;", "getSignedHeaders", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "http4k-aws_main"})
public final class AwsCanonicalRequest {
    @NotNull
    private final String value;
    @NotNull
    private final String signedHeaders;
    @NotNull
    private final String payloadHash;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String getSignedHeaders() {
        return this.signedHeaders;
    }

    @NotNull
    public final String getPayloadHash() {
        return this.payloadHash;
    }

    public AwsCanonicalRequest(@NotNull String value, @NotNull String signedHeaders, @NotNull String payloadHash) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)signedHeaders, (String)"signedHeaders");
        Intrinsics.checkParameterIsNotNull((Object)payloadHash, (String)"payloadHash");
        this.value = value;
        this.signedHeaders = signedHeaders;
        this.payloadHash = payloadHash;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final String component2() {
        return this.signedHeaders;
    }

    @NotNull
    public final String component3() {
        return this.payloadHash;
    }

    @NotNull
    public final AwsCanonicalRequest copy(@NotNull String value, @NotNull String signedHeaders, @NotNull String payloadHash) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)signedHeaders, (String)"signedHeaders");
        Intrinsics.checkParameterIsNotNull((Object)payloadHash, (String)"payloadHash");
        return new AwsCanonicalRequest(value, signedHeaders, payloadHash);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ AwsCanonicalRequest copy$default(AwsCanonicalRequest awsCanonicalRequest, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = awsCanonicalRequest.value;
        }
        if ((n & 2) != 0) {
            string2 = awsCanonicalRequest.signedHeaders;
        }
        if ((n & 4) != 0) {
            string3 = awsCanonicalRequest.payloadHash;
        }
        return awsCanonicalRequest.copy(string, string2, string3);
    }

    public String toString() {
        return "AwsCanonicalRequest(value=" + this.value + ", signedHeaders=" + this.signedHeaders + ", payloadHash=" + this.payloadHash + ")";
    }

    public int hashCode() {
        String string = this.value;
        String string2 = this.signedHeaders;
        String string3 = this.payloadHash;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AwsCanonicalRequest)) break block3;
                AwsCanonicalRequest awsCanonicalRequest = (AwsCanonicalRequest)object;
                if (!Intrinsics.areEqual((Object)this.value, (Object)awsCanonicalRequest.value) || !Intrinsics.areEqual((Object)this.signedHeaders, (Object)awsCanonicalRequest.signedHeaders) || !Intrinsics.areEqual((Object)this.payloadHash, (Object)awsCanonicalRequest.payloadHash)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\t\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\n\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\u000b\u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/http4k/aws/AwsCanonicalRequest$Companion;", "", "()V", "of", "Lorg/http4k/aws/AwsCanonicalRequest;", "request", "Lorg/http4k/core/Request;", "canonicalHeaders", "", "canonicalQueryString", "payloadHash", "signedHeaders", "http4k-aws_main"})
    public static final class Companion {
        @NotNull
        public final AwsCanonicalRequest of(@NotNull Request request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            String signedHeaders = this.signedHeaders(request);
            String payloadHash = this.payloadHash(request);
            String canonical = request.getMethod().name() + "\n" + request.getUri().getPath() + "\n" + this.canonicalQueryString(request) + "\n" + this.canonicalHeaders(request) + "\n\n" + signedHeaders + "\n" + payloadHash;
            return new AwsCanonicalRequest(canonical, signedHeaders, payloadHash);
        }

        /*
         * WARNING - void declaration
         */
        private final String signedHeaders(@NotNull Request $receiver) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)$receiver.getHeaders();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string;
                void it;
                String string2;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                String string3 = string2 = (String)it.getFirst();
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                collection.add(string);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        }

        private final String canonicalHeaders(@NotNull Request $receiver) {
            Object object;
            Pair it;
            Collection collection;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv = $receiver.getHeaders();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string;
                String string2;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                String string3 = string2 = (String)it.getFirst();
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                String string5 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                String string6 = (String)it.getSecond();
                if (string6 != null && (string6 = StringsKt.replace$default((String)string6, (String)"\\s+", (String)" ", (boolean)false, (int)4, null)) != null) {
                    string2 = string6;
                    String string7 = string5;
                    String string8 = string2;
                    if (string8 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string9 = ((Object)StringsKt.trim((CharSequence)string8)).toString();
                    string5 = string7;
                    string = string9;
                } else {
                    string = null;
                }
                object = TuplesKt.to((Object)string5, string);
                collection.add(object);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                object = (String)it.getFirst() + ":" + (String)it.getSecond();
                collection.add(object);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String canonicalQueryString(@NotNull Request $receiver) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = ParametersKt.toParameters((String)$receiver.getUri().getQuery());
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $first_second;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                String first = (String)$first_second.component1();
                String second = (String)$first_second.component2();
                String string = second;
                String string2 = KotlinExtensionsKt.urlEncoded((String)first) + "=" + (string != null ? KotlinExtensionsKt.urlEncoded((String)string) : null);
                collection.add(string2);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }

        private final String payloadHash(@NotNull Request $receiver) {
            byte[] byArray = $receiver.getBody().getPayload().array();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"body.payload.array()");
            return AwsHmacSha256.INSTANCE.hash(byArray);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

