/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsRequestDate;
import org.http4k.aws.AwsSignatureV4Signer;
import org.http4k.core.Filter;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.filter.AwsExtensionsKt;
import org.http4k.filter.ClientFilters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a$\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"buildAuthHeader", "", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "credentials", "Lorg/http4k/aws/AwsCredentials;", "canonicalRequest", "Lorg/http4k/aws/AwsCanonicalRequest;", "date", "Lorg/http4k/aws/AwsRequestDate;", "AwsAuth", "Lorg/http4k/core/Filter;", "Lorg/http4k/filter/ClientFilters;", "clock", "Ljava/time/Clock;", "http4k-aws_main"})
public final class AwsExtensionsKt {
    @NotNull
    public static final Filter AwsAuth(@NotNull ClientFilters $receiver, @NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        return Filter.Companion.invoke((Function1)new Function1<Function1<? super Request, ? extends Response>, Function1<? super Request, ? extends Response>>(clock, scope, credentials){
            final /* synthetic */ Clock $clock;
            final /* synthetic */ AwsCredentialScope $scope;
            final /* synthetic */ AwsCredentials $credentials;

            @NotNull
            public final Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
                Intrinsics.checkParameterIsNotNull(next, (String)"next");
                return (Function1)new Function1<Request, Response>(this, next){
                    final /* synthetic */ AwsAuth.1 this$0;
                    final /* synthetic */ Function1 $next;

                    @NotNull
                    public final Response invoke(@NotNull Request it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Instant instant = this.this$0.$clock.instant();
                        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"clock.instant()");
                        AwsRequestDate date = AwsRequestDate.Companion.of(instant);
                        Request fullRequest = it.header("host", it.getUri().getHost()).header("x-amz-date", date.getFull());
                        AwsCanonicalRequest canonicalRequest = AwsCanonicalRequest.Companion.of(fullRequest);
                        Request signedRequest = fullRequest.header("Authorization", AwsExtensionsKt.access$buildAuthHeader(this.this$0.$scope, this.this$0.$credentials, canonicalRequest, date)).header("x-amz-content-sha256", canonicalRequest.getPayloadHash());
                        return (Response)this.$next.invoke((Object)signedRequest);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$next = function1;
                        super(1);
                    }
                };
            }
            {
                this.$clock = clock;
                this.$scope = awsCredentialScope;
                this.$credentials = awsCredentials;
                super(1);
            }
        });
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Filter AwsAuth$default(ClientFilters clientFilters, AwsCredentialScope awsCredentialScope, AwsCredentials awsCredentials, Clock clock, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemDefaultZone()");
            clock = clock2;
        }
        return AwsExtensionsKt.AwsAuth(clientFilters, awsCredentialScope, awsCredentials, clock);
    }

    private static final String buildAuthHeader(AwsCredentialScope scope, AwsCredentials credentials, AwsCanonicalRequest canonicalRequest, AwsRequestDate date) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s Credential=%s/%s, SignedHeaders=%s, Signature=%s";
        Object[] objectArray = new Object[]{"AWS4-HMAC-SHA256", credentials.getAccessKey(), scope.datedScope$http4k_aws_main(date), canonicalRequest.getSignedHeaders(), AwsSignatureV4Signer.INSTANCE.sign(canonicalRequest, scope, credentials, date)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @NotNull
    public static final /* synthetic */ String access$buildAuthHeader(@NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull AwsCanonicalRequest canonicalRequest, @NotNull AwsRequestDate date) {
        return AwsExtensionsKt.buildAuthHeader(scope, credentials, canonicalRequest, date);
    }
}

