/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lorg/http4k/aws/AwsHmacSha256;", "", "()V", "hash", "", "payload", "", "hex", "data", "hmacSHA256", "key", "http4k-aws_main"})
public final class AwsHmacSha256 {
    public static final AwsHmacSha256 INSTANCE;

    @NotNull
    public final String hash(@NotNull String payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = payload;
        AwsHmacSha256 awsHmacSha256 = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return awsHmacSha256.hash(byArray2);
    }

    @NotNull
    public final String hash(@NotNull byte[] payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] res = digest.digest(payload);
            Intrinsics.checkExpressionValueIsNotNull((Object)res, (String)"res");
            return this.hex(res);
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public final byte[] hmacSHA256(@NotNull byte[] key, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        try {
            Object object;
            String algorithm = "HmacSHA256";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            String string = data;
            Object object2 = "UTF8";
            Mac mac2 = mac;
            Charset charset = Charset.forName((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object2 = object = charset;
            byte[] byArray = string.getBytes((Charset)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray;
            byte[] byArray2 = mac2.doFinal((byte[])object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"mac.doFinal(data.toByteArray(charset(\"UTF8\")))");
            return byArray2;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException("Could not run HMAC SHA256", e);
        }
    }

    @NotNull
    public final String hex(@NotNull byte[] data) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            String string2;
            byte aByte = data[i];
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%02x";
            Object[] objectArray = new Object[]{aByte};
            StringBuilder stringBuilder = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            stringBuilder.append(string2);
        }
        String string4 = string = result.toString();
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        return string5;
    }

    private AwsHmacSha256() {
        INSTANCE = this;
    }

    static {
        new AwsHmacSha256();
    }
}

