/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsHmacSha256;
import org.http4k.aws.AwsRequestDate;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J&\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u00020\u0006*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/http4k/aws/AwsSignatureV4Signer;", "", "()V", "getSignatureKey", "", "key", "", "dateStamp", "regionName", "serviceName", "sign", "request", "Lorg/http4k/aws/AwsCanonicalRequest;", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "awsCredentials", "Lorg/http4k/aws/AwsCredentials;", "date", "Lorg/http4k/aws/AwsRequestDate;", "stringToSign", "requestScope", "http4k-aws"})
public final class AwsSignatureV4Signer {
    public static final AwsSignatureV4Signer INSTANCE;

    @NotNull
    public final String sign(@NotNull AwsCanonicalRequest request, @NotNull AwsCredentialScope scope, @NotNull AwsCredentials awsCredentials, @NotNull AwsRequestDate date) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)awsCredentials, (String)"awsCredentials");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        byte[] signatureKey = this.getSignatureKey(awsCredentials.getSecretKey(), date.getBasic(), scope.getRegion(), scope.getService());
        byte[] signature = AwsHmacSha256.INSTANCE.hmacSHA256(signatureKey, this.stringToSign(request, scope, date));
        return AwsHmacSha256.INSTANCE.hex(signature);
    }

    private final byte[] getSignatureKey(String key, String dateStamp, String regionName, String serviceName) {
        byte[] byArray;
        try {
            String string = "AWS4" + key;
            Object object = "UTF8";
            Charset charset = Charset.forName((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object = charset;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray2 = string2.getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] kSecret = byArray2;
            byte[] kDate = AwsHmacSha256.INSTANCE.hmacSHA256(kSecret, dateStamp);
            byte[] kRegion = AwsHmacSha256.INSTANCE.hmacSHA256(kDate, regionName);
            byte[] kService = AwsHmacSha256.INSTANCE.hmacSHA256(kRegion, serviceName);
            byArray = AwsHmacSha256.INSTANCE.hmacSHA256(kService, "aws4_request");
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new RuntimeException("Could not generate signature key", e);
        }
        return byArray;
    }

    private final String stringToSign(@NotNull AwsCanonicalRequest $receiver, AwsCredentialScope requestScope, AwsRequestDate date) {
        return "AWS4-HMAC-SHA256\n" + date.getFull() + "\n" + requestScope.datedScope$http4k_aws(date) + "\n" + AwsHmacSha256.INSTANCE.hash($receiver.getValue());
    }

    private AwsSignatureV4Signer() {
        INSTANCE = this;
    }

    static {
        new AwsSignatureV4Signer();
    }
}

