/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsRequestDate;
import org.http4k.aws.AwsSignatureV4Signer;
import org.http4k.core.Filter;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.filter.AwsExtensionsKt;
import org.http4k.filter.AwsExtensionsKt$WhenMappings;
import org.http4k.filter.CanonicalPayload;
import org.http4k.filter.ClientFilters;
import org.http4k.filter.Payload;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a.\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"allowsContent", "", "Lorg/http4k/core/Method;", "getAllowsContent", "(Lorg/http4k/core/Method;)Z", "buildAuthHeader", "", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "credentials", "Lorg/http4k/aws/AwsCredentials;", "canonicalRequest", "Lorg/http4k/aws/AwsCanonicalRequest;", "date", "Lorg/http4k/aws/AwsRequestDate;", "AwsAuth", "Lorg/http4k/core/Filter;", "Lorg/http4k/filter/ClientFilters;", "clock", "Ljava/time/Clock;", "payloadMode", "Lorg/http4k/filter/Payload$Mode;", "http4k-aws"})
public final class AwsExtensionsKt {
    @NotNull
    public static final Filter AwsAuth(@NotNull ClientFilters $receiver, @NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)payloadMode, (String)"payloadMode");
        return Filter.Companion.invoke((Function1)new Function1<Function1<? super Request, ? extends Response>, Function1<? super Request, ? extends Response>>(payloadMode, clock, scope, credentials){
            final /* synthetic */ Payload.Mode $payloadMode;
            final /* synthetic */ Clock $clock;
            final /* synthetic */ AwsCredentialScope $scope;
            final /* synthetic */ AwsCredentials $credentials;

            @NotNull
            public final Function1<Request, Response> invoke(@NotNull Function1<? super Request, ? extends Response> next) {
                Intrinsics.checkParameterIsNotNull(next, (String)"next");
                return (Function1)new Function1<Request, Response>(this, next){
                    final /* synthetic */ AwsAuth.1 this$0;
                    final /* synthetic */ Function1 $next;

                    @NotNull
                    public final Response invoke(@NotNull Request it) {
                        Request request;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        CanonicalPayload payload = (CanonicalPayload)this.this$0.$payloadMode.invoke(it);
                        Instant instant = this.this$0.$clock.instant();
                        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"clock.instant()");
                        AwsRequestDate date = AwsRequestDate.Companion.of(instant);
                        Request it2 = request = it.replaceHeader("host", it.getUri().getHost()).replaceHeader("x-amz-date", date.getFull());
                        Request fullRequest = AwsExtensionsKt.access$getAllowsContent$p(it2.getMethod()) ? it2.replaceHeader("content-length", String.valueOf(payload.getLength())) : it2;
                        AwsCanonicalRequest canonicalRequest = AwsCanonicalRequest.Companion.of(fullRequest, payload);
                        Request signedRequest = fullRequest.replaceHeader("Authorization", AwsExtensionsKt.access$buildAuthHeader(this.this$0.$scope, this.this$0.$credentials, canonicalRequest, date)).replaceHeader("x-amz-content-sha256", payload.getHash());
                        return (Response)this.$next.invoke((Object)signedRequest);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$next = function1;
                        super(1);
                    }
                };
            }
            {
                this.$payloadMode = mode;
                this.$clock = clock;
                this.$scope = awsCredentialScope;
                this.$credentials = awsCredentials;
                super(1);
            }
        });
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Filter AwsAuth$default(ClientFilters clientFilters, AwsCredentialScope awsCredentialScope, AwsCredentials awsCredentials, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemDefaultZone()");
            clock = clock2;
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Signed.INSTANCE;
        }
        return AwsExtensionsKt.AwsAuth(clientFilters, awsCredentialScope, awsCredentials, clock, mode);
    }

    private static final boolean getAllowsContent(@NotNull Method $receiver) {
        boolean bl;
        switch (AwsExtensionsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            case 5: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static final String buildAuthHeader(AwsCredentialScope scope, AwsCredentials credentials, AwsCanonicalRequest canonicalRequest, AwsRequestDate date) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s Credential=%s/%s, SignedHeaders=%s, Signature=%s";
        Object[] objectArray = new Object[]{"AWS4-HMAC-SHA256", credentials.getAccessKey(), scope.datedScope$http4k_aws(date), canonicalRequest.getSignedHeaders(), AwsSignatureV4Signer.INSTANCE.sign(canonicalRequest, scope, credentials, date)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public static final /* synthetic */ boolean access$getAllowsContent$p(@NotNull Method $receiver) {
        return AwsExtensionsKt.getAllowsContent($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$buildAuthHeader(@NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull AwsCanonicalRequest canonicalRequest, @NotNull AwsRequestDate date) {
        return AwsExtensionsKt.buildAuthHeader(scope, credentials, canonicalRequest, date);
    }
}

