/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsRequestDate;
import org.http4k.aws.AwsSignatureV4Signer;
import org.http4k.core.Body;
import org.http4k.core.Filter;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.filter.CanonicalPayload;
import org.http4k.filter.ClientFilters;
import org.http4k.filter.Payload;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a4\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a.\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u001a\u001a\u0010\u0018\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001b"}, d2={"allowsContent", "", "Lorg/http4k/core/Method;", "getAllowsContent", "(Lorg/http4k/core/Method;)Z", "buildAuthHeader", "", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "credentials", "Lorg/http4k/aws/AwsCredentials;", "canonicalRequest", "Lorg/http4k/aws/AwsCanonicalRequest;", "date", "Lorg/http4k/aws/AwsRequestDate;", "AwsAuth", "Lorg/http4k/core/Filter;", "Lorg/http4k/filter/ClientFilters;", "credentialsProvider", "Lkotlin/Function0;", "clock", "Ljava/time/Clock;", "payloadMode", "Lorg/http4k/filter/Payload$Mode;", "SetAwsServiceUrl", "serviceName", "region", "http4k-aws"})
public final class AwsExtensionsKt {
    @NotNull
    public static final Filter AwsAuth(@NotNull ClientFilters $this$AwsAuth, @NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkNotNullParameter((Object)$this$AwsAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)payloadMode, (String)"payloadMode");
        return AwsExtensionsKt.AwsAuth(ClientFilters.INSTANCE, scope, (Function0<AwsCredentials>)((Function0)new Function0<AwsCredentials>(credentials){
            final /* synthetic */ AwsCredentials $credentials;
            {
                this.$credentials = $credentials;
                super(0);
            }

            @NotNull
            public final AwsCredentials invoke() {
                return this.$credentials;
            }
        }), clock, payloadMode);
    }

    public static /* synthetic */ Filter AwsAuth$default(ClientFilters clientFilters, AwsCredentialScope awsCredentialScope, AwsCredentials awsCredentials, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone()");
            clock = clock2;
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Signed.INSTANCE;
        }
        return AwsExtensionsKt.AwsAuth(clientFilters, awsCredentialScope, awsCredentials, clock, mode);
    }

    @NotNull
    public static final Filter AwsAuth(@NotNull ClientFilters $this$AwsAuth, @NotNull AwsCredentialScope scope, @NotNull Function0<AwsCredentials> credentialsProvider, @NotNull Clock clock, @NotNull Payload.Mode payloadMode) {
        Intrinsics.checkNotNullParameter((Object)$this$AwsAuth, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)payloadMode, (String)"payloadMode");
        return arg_0 -> AwsExtensionsKt.AwsAuth$lambda-0(payloadMode, credentialsProvider, clock, scope, arg_0);
    }

    public static /* synthetic */ Filter AwsAuth$default(ClientFilters clientFilters, AwsCredentialScope awsCredentialScope, Function0 function0, Clock clock, Payload.Mode mode, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemDefaultZone();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemDefaultZone()");
            clock = clock2;
        }
        if ((n & 8) != 0) {
            mode = Payload.Mode.Signed.INSTANCE;
        }
        return AwsExtensionsKt.AwsAuth(clientFilters, awsCredentialScope, (Function0<AwsCredentials>)function0, clock, mode);
    }

    private static final boolean getAllowsContent(Method $this$allowsContent) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$allowsContent.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            case 5: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static final String buildAuthHeader(AwsCredentialScope scope, AwsCredentials credentials, AwsCanonicalRequest canonicalRequest, AwsRequestDate date) {
        return "AWS4-HMAC-SHA256 Credential=" + credentials.getAccessKey() + '/' + scope.datedScope$http4k_aws(date) + ", SignedHeaders=" + canonicalRequest.getSignedHeaders() + ", Signature=" + AwsSignatureV4Signer.INSTANCE.sign(canonicalRequest, scope, credentials, date);
    }

    @NotNull
    public static final Filter SetAwsServiceUrl(@NotNull ClientFilters $this$SetAwsServiceUrl, @NotNull String serviceName, @NotNull String region) {
        Intrinsics.checkNotNullParameter((Object)$this$SetAwsServiceUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return $this$SetAwsServiceUrl.SetHostFrom(Uri.Companion.of("https://" + serviceName + '.' + region + ".amazonaws.com"));
    }

    private static final Function1 AwsAuth$lambda-0(Payload.Mode $payloadMode, Function0 $credentialsProvider, Clock $clock, AwsCredentialScope $scope, Function1 next) {
        Intrinsics.checkNotNullParameter((Object)$payloadMode, (String)"$payloadMode");
        Intrinsics.checkNotNullParameter((Object)$credentialsProvider, (String)"$credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)$clock, (String)"$clock");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        return (Function1)new Function1<Request, Response>($payloadMode, (Function0<AwsCredentials>)$credentialsProvider, $clock, $scope, (Function1<? super Request, ? extends Response>)next){
            final /* synthetic */ Payload.Mode $payloadMode;
            final /* synthetic */ Function0<AwsCredentials> $credentialsProvider;
            final /* synthetic */ Clock $clock;
            final /* synthetic */ AwsCredentialScope $scope;
            final /* synthetic */ Function1<Request, Response> $next;
            {
                this.$payloadMode = $payloadMode;
                this.$credentialsProvider = $credentialsProvider;
                this.$clock = $clock;
                this.$scope = $scope;
                this.$next = $next;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request it) {
                String string;
                AwsRequestDate date;
                AwsCredentials credentials;
                CanonicalPayload payload;
                block4: {
                    Request $this$invoke_u24lambda_u2d2;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        payload = (CanonicalPayload)this.$payloadMode.invoke(it);
                        credentials = (AwsCredentials)this.$credentialsProvider.invoke();
                        Instant instant = this.$clock.instant();
                        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
                        date = AwsRequestDate.Companion.of(instant);
                        Request it2 = it.replaceHeader("host", it.getUri().getHost()).replaceHeader("x-amz-content-sha256", payload.getHash()).replaceHeader("x-amz-date", date.getFull());
                        boolean bl = false;
                        $this$invoke_u24lambda_u2d2 = AwsExtensionsKt.access$getAllowsContent(it2.getMethod()) ? it2.replaceHeader("content-length", String.valueOf(payload.getLength())) : it2;
                        boolean bl2 = false;
                        string = credentials.getSessionToken();
                        if (string == null) break block3;
                        String it3 = string;
                        boolean bl3 = false;
                        Request request = $this$invoke_u24lambda_u2d2.replaceHeader("x-amz-security-token", credentials.getSessionToken());
                        string = request;
                        if (request != null) break block4;
                    }
                    string = $this$invoke_u24lambda_u2d2;
                }
                String fullRequest = string;
                AwsCanonicalRequest canonicalRequest = AwsCanonicalRequest.Companion.of((Request)fullRequest, payload);
                Request signedRequest = fullRequest.replaceHeader("Authorization", AwsExtensionsKt.access$buildAuthHeader(this.$scope, credentials, canonicalRequest, date));
                return (Response)this.$next.invoke((Object)signedRequest.body(Body.Companion.create(it.getBody().getPayload())));
            }
        };
    }

    public static final /* synthetic */ String access$buildAuthHeader(AwsCredentialScope scope, AwsCredentials credentials, AwsCanonicalRequest canonicalRequest, AwsRequestDate date) {
        return AwsExtensionsKt.buildAuthHeader(scope, credentials, canonicalRequest, date);
    }

    public static final /* synthetic */ boolean access$getAllowsContent(Method $receiver) {
        return AwsExtensionsKt.getAllowsContent($receiver);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            nArray[Method.HEAD.ordinal()] = 1;
            nArray[Method.GET.ordinal()] = 2;
            nArray[Method.OPTIONS.ordinal()] = 3;
            nArray[Method.TRACE.ordinal()] = 4;
            nArray[Method.DELETE.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

