/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.http4k.KotlinExtensionsKt;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.filter.CanonicalPayload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/http4k/aws/AwsCanonicalRequest;", "", "value", "", "signedHeaders", "payloadHash", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPayloadHash", "()Ljava/lang/String;", "getSignedHeaders", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "http4k-aws"})
public final class AwsCanonicalRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final String signedHeaders;
    @NotNull
    private final String payloadHash;
    @NotNull
    private static final Regex multipleSpaces = new Regex("\\s+");

    public AwsCanonicalRequest(@NotNull String value, @NotNull String signedHeaders, @NotNull String payloadHash) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)signedHeaders, (String)"signedHeaders");
        Intrinsics.checkNotNullParameter((Object)payloadHash, (String)"payloadHash");
        this.value = value;
        this.signedHeaders = signedHeaders;
        this.payloadHash = payloadHash;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String getSignedHeaders() {
        return this.signedHeaders;
    }

    @NotNull
    public final String getPayloadHash() {
        return this.payloadHash;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final String component2() {
        return this.signedHeaders;
    }

    @NotNull
    public final String component3() {
        return this.payloadHash;
    }

    @NotNull
    public final AwsCanonicalRequest copy(@NotNull String value, @NotNull String signedHeaders, @NotNull String payloadHash) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)signedHeaders, (String)"signedHeaders");
        Intrinsics.checkNotNullParameter((Object)payloadHash, (String)"payloadHash");
        return new AwsCanonicalRequest(value, signedHeaders, payloadHash);
    }

    public static /* synthetic */ AwsCanonicalRequest copy$default(AwsCanonicalRequest awsCanonicalRequest, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = awsCanonicalRequest.value;
        }
        if ((n & 2) != 0) {
            string2 = awsCanonicalRequest.signedHeaders;
        }
        if ((n & 4) != 0) {
            string3 = awsCanonicalRequest.payloadHash;
        }
        return awsCanonicalRequest.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "AwsCanonicalRequest(value=" + this.value + ", signedHeaders=" + this.signedHeaders + ", payloadHash=" + this.payloadHash + ')';
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + this.signedHeaders.hashCode();
        result = result * 31 + this.payloadHash.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AwsCanonicalRequest)) {
            return false;
        }
        AwsCanonicalRequest awsCanonicalRequest = (AwsCanonicalRequest)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)awsCanonicalRequest.value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signedHeaders, (Object)awsCanonicalRequest.signedHeaders)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.payloadHash, (Object)awsCanonicalRequest.payloadHash);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\u00020\f*\u00020\bH\u0002J\f\u0010\r\u001a\u00020\f*\u00020\bH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/http4k/aws/AwsCanonicalRequest$Companion;", "", "()V", "multipleSpaces", "Lkotlin/text/Regex;", "of", "Lorg/http4k/aws/AwsCanonicalRequest;", "request", "Lorg/http4k/core/Request;", "payload", "Lorg/http4k/filter/CanonicalPayload;", "canonicalHeaders", "", "canonicalQueryString", "normalisedPath", "Lorg/http4k/core/Uri;", "signedHeaders", "http4k-aws"})
    @SourceDebugExtension(value={"SMAP\nAwsCanonicalRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsCanonicalRequest.kt\norg/http4k/aws/AwsCanonicalRequest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,52:1\n1549#2:53\n1620#2,3:54\n1549#2:57\n1620#2,3:58\n1490#2:61\n1520#2,3:62\n1523#2,3:72\n1238#2,4:77\n1045#2:81\n1549#2:82\n1620#2,3:83\n372#3,7:65\n453#3:75\n403#3:76\n*S KotlinDebug\n*F\n+ 1 AwsCanonicalRequest.kt\norg/http4k/aws/AwsCanonicalRequest$Companion\n*L\n29#1:53\n29#1:54,3\n33#1:57\n33#1:58,3\n34#1:61\n34#1:62,3\n34#1:72,3\n35#1:77,4\n37#1:81\n42#1:82\n42#1:83,3\n34#1:65,7\n35#1:75\n35#1:76\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AwsCanonicalRequest of(@NotNull Request request, @NotNull CanonicalPayload payload) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            String signedHeaders = this.signedHeaders(request);
            String canonical = request.getMethod().name() + '\n' + this.normalisedPath(request.getUri()) + '\n' + this.canonicalQueryString(request) + '\n' + this.canonicalHeaders(request) + "\n\n" + signedHeaders + '\n' + payload.getHash();
            return new AwsCanonicalRequest(canonical, signedHeaders, payload.getHash());
        }

        /*
         * WARNING - void declaration
         */
        private final String signedHeaders(Request $this$signedHeaders) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$signedHeaders.getHeaders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = (String)it.getFirst();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv))), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String canonicalHeaders(Request $this$canonicalHeaders) {
            void $this$mapValuesTo$iv$iv;
            Object value$iv$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Object object;
            Pair it;
            Object object2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$canonicalHeaders.getHeaders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String string2;
                block9: {
                    block8: {
                        String string3;
                        Pair pair = (Pair)item$iv$iv;
                        object2 = destination$iv$iv;
                        boolean bl = false;
                        String string4 = (String)it.getFirst();
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                        string2 = string4.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        string = (String)it.getSecond();
                        if (string == null) break block8;
                        object = string;
                        Regex regex = multipleSpaces;
                        string = regex.replace((CharSequence)object, string3 = " ");
                        if (string != null && (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) != null) break block9;
                    }
                    string = "";
                }
                object2.add(TuplesKt.to((Object)string2, (Object)string));
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it2;
                Object object3;
                Object element$iv$iv = iterator.next();
                it = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-AwsCanonicalRequest$Companion$canonicalHeaders$42 = false;
                key$iv$iv = (String)it.getFirst();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                Pair $i$a$-groupBy-AwsCanonicalRequest$Companion$canonicalHeaders$42 = (Pair)element$iv$iv;
                object2 = list$iv$iv;
                boolean bl = false;
                object2.add((String)it2.getSecond());
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it3;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object2 = object;
                boolean bl2 = false;
                String string = CollectionsKt.joinToString$default((Iterable)((Iterable)it3.getValue()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                object2.put(k, string);
            }
            Iterable $this$sortedBy$iv = MapsKt.toList((Map)destination$iv$iv);
            boolean $i$f$sortedBy = false;
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
                }
            }), (CharSequence)"\n", null, null, (int)0, null, (Function1)canonicalHeaders.6.INSTANCE, (int)30, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String canonicalQueryString(Request $this$canonicalQueryString) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ParametersKt.toParameters((String)$this$canonicalQueryString.getUri().getQuery());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String first = (String)pair.component1();
                String second = (String)pair.component2();
                StringBuilder stringBuilder = new StringBuilder().append(KotlinExtensionsKt.urlEncoded((String)first)).append('=');
                String string = second;
                String string2 = string != null ? KotlinExtensionsKt.urlEncoded((String)string) : null;
                if (string2 == null) {
                    string2 = "";
                }
                collection.add(stringBuilder.append(string2).toString());
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }

        private final String normalisedPath(Uri $this$normalisedPath) {
            String string;
            if (StringsKt.isBlank((CharSequence)$this$normalisedPath.getPath())) {
                string = "/";
            } else {
                String[] stringArray = new String[]{"/"};
                string = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$normalisedPath.getPath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)normalisedPath.1.INSTANCE, (int)30, null);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

