/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.filter.CanonicalPayload;
import org.http4k.security.HmacSha256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/http4k/filter/Payload;", "", "()V", "Mode", "http4k-aws"})
public final class Payload {
    @NotNull
    public static final Payload INSTANCE = new Payload();

    private Payload() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0004\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/http4k/filter/Payload$Mode;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/filter/CanonicalPayload;", "Signed", "Unsigned", "Lorg/http4k/filter/Payload$Mode$Signed;", "Lorg/http4k/filter/Payload$Mode$Unsigned;", "http4k-aws"})
    public static interface Mode
    extends Function1<Request, CanonicalPayload> {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lorg/http4k/filter/Payload$Mode$Signed;", "Lorg/http4k/filter/Payload$Mode;", "()V", "equals", "", "other", "", "hashCode", "", "invoke", "Lorg/http4k/filter/CanonicalPayload;", "request", "Lorg/http4k/core/Request;", "toString", "", "http4k-aws"})
        public static final class Signed
        implements Mode {
            @NotNull
            public static final Signed INSTANCE = new Signed();

            private Signed() {
            }

            @NotNull
            public CanonicalPayload invoke(@NotNull Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                byte[] it = request.getBody().getPayload().array();
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                return new CanonicalPayload(HmacSha256.INSTANCE.hash(it), it.length);
            }

            @NotNull
            public String toString() {
                return "Signed";
            }

            public int hashCode() {
                return -1647305898;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Signed)) {
                    return false;
                }
                Signed cfr_ignored_0 = (Signed)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lorg/http4k/filter/Payload$Mode$Unsigned;", "Lorg/http4k/filter/Payload$Mode;", "()V", "equals", "", "other", "", "hashCode", "", "invoke", "Lorg/http4k/filter/CanonicalPayload;", "request", "Lorg/http4k/core/Request;", "toString", "", "http4k-aws"})
        public static final class Unsigned
        implements Mode {
            @NotNull
            public static final Unsigned INSTANCE = new Unsigned();

            private Unsigned() {
            }

            @NotNull
            public CanonicalPayload invoke(@NotNull Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Long l = request.getBody().getLength();
                if (l == null) {
                    throw new IllegalStateException("request body size could not be determined");
                }
                return new CanonicalPayload("UNSIGNED-PAYLOAD", l);
            }

            @NotNull
            public String toString() {
                return "Unsigned";
            }

            public int hashCode() {
                return 1454173359;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unsigned)) {
                    return false;
                }
                Unsigned cfr_ignored_0 = (Unsigned)other;
                return true;
            }
        }
    }
}

