/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.aws.AwsCanonicalRequestKt;
import org.http4k.aws.AwsCredentialScope;
import org.http4k.aws.AwsCredentials;
import org.http4k.aws.AwsPreRequestSigner;
import org.http4k.aws.AwsPreSignedRequest;
import org.http4k.aws.AwsRequestDate;
import org.http4k.aws.AwsSignatureV4Signer;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.filter.Payload;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"AwsRequestPreSigner", "Lorg/http4k/aws/AwsPreRequestSigner;", "scope", "Lorg/http4k/aws/AwsCredentialScope;", "credentialsProvider", "Lkotlin/Function0;", "Lorg/http4k/aws/AwsCredentials;", "clock", "Ljava/time/Clock;", "credentials", "http4k-aws"})
@SourceDebugExtension(value={"SMAP\nAwsRequestPreSigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsRequestPreSigner.kt\norg/http4k/aws/AwsRequestPreSignerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class AwsRequestPreSignerKt {
    @NotNull
    public static final AwsPreRequestSigner AwsRequestPreSigner(@NotNull AwsCredentialScope scope, @NotNull AwsCredentials credentials, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return AwsRequestPreSignerKt.AwsRequestPreSigner(scope, (Function0<AwsCredentials>)((Function0)new Function0<AwsCredentials>(credentials){
            final /* synthetic */ AwsCredentials $credentials;
            {
                this.$credentials = $credentials;
                super(0);
            }

            @NotNull
            public final AwsCredentials invoke() {
                return this.$credentials;
            }
        }), clock);
    }

    public static /* synthetic */ AwsPreRequestSigner AwsRequestPreSigner$default(AwsCredentialScope awsCredentialScope, AwsCredentials awsCredentials, Clock clock, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        return AwsRequestPreSignerKt.AwsRequestPreSigner(awsCredentialScope, awsCredentials, clock);
    }

    @NotNull
    public static final AwsPreRequestSigner AwsRequestPreSigner(@NotNull AwsCredentialScope scope, @NotNull Function0<AwsCredentials> credentialsProvider, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return (arg_0, arg_1) -> AwsRequestPreSignerKt.AwsRequestPreSigner$lambda$2(clock, credentialsProvider, scope, arg_0, arg_1);
    }

    public static /* synthetic */ AwsPreRequestSigner AwsRequestPreSigner$default(AwsCredentialScope awsCredentialScope, Function0 function0, Clock clock, int n, Object object) {
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        return AwsRequestPreSignerKt.AwsRequestPreSigner(awsCredentialScope, (Function0<AwsCredentials>)function0, clock);
    }

    private static final AwsPreSignedRequest AwsRequestPreSigner$lambda$2(Clock $clock, Function0 $credentialsProvider, AwsCredentialScope $scope, Request request, Duration expires) {
        Intrinsics.checkNotNullParameter((Object)$clock, (String)"$clock");
        Intrinsics.checkNotNullParameter((Object)$credentialsProvider, (String)"$credentialsProvider");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)expires, (String)"expires");
        Instant instant = $clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        AwsRequestDate awsDate = AwsRequestDate.Companion.of(instant);
        AwsCredentials credentials = (AwsCredentials)$credentialsProvider.invoke();
        Request it = request.replaceHeader("Host", request.getUri().getHost());
        boolean bl = false;
        it = it.query("X-Amz-SignedHeaders", AwsCanonicalRequestKt.signedHeaders(it)).query("X-Amz-Algorithm", "AWS4-HMAC-SHA256").query("X-Amz-Date", awsDate.getFull()).query("X-Amz-Credential", credentials.getAccessKey() + '/' + $scope.datedScope$http4k_aws(awsDate)).query("X-Amz-Expires", String.valueOf(expires.getSeconds()));
        boolean bl2 = false;
        Request fullRequest = credentials.getSessionToken() != null ? it.query("X-Amz-Security-Token", credentials.getSessionToken()) : it;
        AwsCanonicalRequest canonicalRequest = AwsCanonicalRequest.Companion.of(fullRequest, Payload.Mode.Unsigned.INSTANCE.invoke(request));
        String signature = AwsSignatureV4Signer.INSTANCE.sign(canonicalRequest, $scope, credentials, awsDate);
        Method method = fullRequest.getMethod();
        Uri uri = fullRequest.query("X-Amz-Signature", signature).getUri();
        List list = fullRequest.getHeaders();
        Instant instant2 = $clock.instant().plus(expires);
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"plus(...)");
        return new AwsPreSignedRequest(method, uri, list, instant2);
    }
}

