/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.aws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.http4k.KotlinExtensionsKt;
import org.http4k.aws.AwsCanonicalRequest;
import org.http4k.core.ParametersKt;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.filter.CanonicalPayload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/http4k/aws/AwsCanonicalRequest;", "", "value", "", "signedHeaders", "payloadHash", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPayloadHash", "()Ljava/lang/String;", "getSignedHeaders", "getValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "http4k-aws"})
public final class AwsCanonicalRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final String signedHeaders;
    @NotNull
    private final String payloadHash;

    public AwsCanonicalRequest(@NotNull String value, @NotNull String signedHeaders, @NotNull String payloadHash) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)signedHeaders, (String)"signedHeaders");
        Intrinsics.checkNotNullParameter((Object)payloadHash, (String)"payloadHash");
        this.value = value;
        this.signedHeaders = signedHeaders;
        this.payloadHash = payloadHash;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public final String getSignedHeaders() {
        return this.signedHeaders;
    }

    @NotNull
    public final String getPayloadHash() {
        return this.payloadHash;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final String component2() {
        return this.signedHeaders;
    }

    @NotNull
    public final String component3() {
        return this.payloadHash;
    }

    @NotNull
    public final AwsCanonicalRequest copy(@NotNull String value, @NotNull String signedHeaders, @NotNull String payloadHash) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)signedHeaders, (String)"signedHeaders");
        Intrinsics.checkNotNullParameter((Object)payloadHash, (String)"payloadHash");
        return new AwsCanonicalRequest(value, signedHeaders, payloadHash);
    }

    public static /* synthetic */ AwsCanonicalRequest copy$default(AwsCanonicalRequest awsCanonicalRequest, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = awsCanonicalRequest.value;
        }
        if ((n & 2) != 0) {
            string2 = awsCanonicalRequest.signedHeaders;
        }
        if ((n & 4) != 0) {
            string3 = awsCanonicalRequest.payloadHash;
        }
        return awsCanonicalRequest.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "AwsCanonicalRequest(value=" + this.value + ", signedHeaders=" + this.signedHeaders + ", payloadHash=" + this.payloadHash + ')';
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + this.signedHeaders.hashCode();
        result = result * 31 + this.payloadHash.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AwsCanonicalRequest)) {
            return false;
        }
        AwsCanonicalRequest awsCanonicalRequest = (AwsCanonicalRequest)other;
        if (!Intrinsics.areEqual((Object)this.value, (Object)awsCanonicalRequest.value)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signedHeaders, (Object)awsCanonicalRequest.signedHeaders)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.payloadHash, (Object)awsCanonicalRequest.payloadHash);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\u0006H\u0002J\f\u0010\f\u001a\u00020\n*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/http4k/aws/AwsCanonicalRequest$Companion;", "", "()V", "of", "Lorg/http4k/aws/AwsCanonicalRequest;", "request", "Lorg/http4k/core/Request;", "payload", "Lorg/http4k/filter/CanonicalPayload;", "canonicalHeaders", "", "canonicalQueryString", "normalisedPath", "Lorg/http4k/core/Uri;", "signedHeaders", "http4k-aws"})
    @SourceDebugExtension(value={"SMAP\nAwsCanonicalRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsCanonicalRequest.kt\norg/http4k/aws/AwsCanonicalRequest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n1549#2:51\n1620#2,3:52\n1549#2:55\n1620#2,3:56\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 AwsCanonicalRequest.kt\norg/http4k/aws/AwsCanonicalRequest$Companion\n*L\n29#1:47\n29#1:48,3\n32#1:51\n32#1:52,3\n33#1:55\n33#1:56,3\n39#1:59\n39#1:60,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AwsCanonicalRequest of(@NotNull Request request, @NotNull CanonicalPayload payload) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            String signedHeaders = this.signedHeaders(request);
            String canonical = request.getMethod().name() + '\n' + this.normalisedPath(request.getUri()) + '\n' + this.canonicalQueryString(request) + '\n' + this.canonicalHeaders(request) + "\n\n" + signedHeaders + '\n' + payload.getHash();
            return new AwsCanonicalRequest(canonical, signedHeaders, payload.getHash());
        }

        /*
         * WARNING - void declaration
         */
        private final String signedHeaders(Request $this$signedHeaders) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$signedHeaders.getHeaders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = (String)it.getFirst();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                collection.add(string2);
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        }

        private final String canonicalHeaders(Request $this$canonicalHeaders) {
            Pair it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$canonicalHeaders.getHeaders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                String string = (String)it.getFirst();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                String string3 = (String)it.getSecond();
                collection.add(TuplesKt.to((Object)string2, string3 != null && (string3 = StringsKt.replace$default((String)string3, (String)"\\s+", (String)" ", (boolean)false, (int)4, null)) != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it.getFirst() + ':' + (String)it.getSecond());
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * WARNING - void declaration
         */
        private final String canonicalQueryString(Request $this$canonicalQueryString) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ParametersKt.toParameters((String)$this$canonicalQueryString.getUri().getQuery());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String first = (String)pair.component1();
                String second = (String)pair.component2();
                StringBuilder stringBuilder = new StringBuilder().append(KotlinExtensionsKt.urlEncoded((String)first)).append('=');
                String string = second;
                String string2 = string != null ? KotlinExtensionsKt.urlEncoded((String)string) : null;
                if (string2 == null) {
                    string2 = "";
                }
                collection.add(stringBuilder.append(string2).toString());
            }
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }

        private final String normalisedPath(Uri $this$normalisedPath) {
            String string;
            if (StringsKt.isBlank((CharSequence)$this$normalisedPath.getPath())) {
                string = "/";
            } else {
                String[] stringArray = new String[]{"/"};
                string = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$normalisedPath.getPath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)normalisedPath.1.INSTANCE, (int)30, null);
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

