/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.http4k.client.ApacheAsyncClient;
import org.http4k.client.AsyncHttpClient;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002J'\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/http4k/client/ApacheAsyncClient;", "", "()V", "defaultApacheAsyncHttpClient", "Lorg/apache/http/impl/nio/client/CloseableHttpAsyncClient;", "kotlin.jvm.PlatformType", "invoke", "Lorg/http4k/client/AsyncHttpClient;", "client", "responseBodyMode", "Lorg/http4k/core/BodyMode;", "requestBodyMode", "http4k-client-apache-async"})
public final class ApacheAsyncClient {
    public static final ApacheAsyncClient INSTANCE;

    @NotNull
    public final AsyncHttpClient invoke(@NotNull CloseableHttpAsyncClient client, @NotNull BodyMode responseBodyMode, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkParameterIsNotNull((Object)requestBodyMode, (String)"requestBodyMode");
        if (!client.isRunning()) {
            client.start();
        }
        return new AsyncHttpClient(client, responseBodyMode, requestBodyMode){
            final /* synthetic */ CloseableHttpAsyncClient $client;
            final /* synthetic */ BodyMode $responseBodyMode;
            final /* synthetic */ BodyMode $requestBodyMode;

            public void close() {
                this.$client.close();
            }

            public void invoke(@NotNull Request request, @NotNull Function1<? super Response, Unit> fn) {
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                this.$client.execute((HttpUriRequest)this.toApacheRequest(request), (FutureCallback)new FutureCallback<HttpResponse>(this, fn){
                    final /* synthetic */ invoke.1 this$0;
                    final /* synthetic */ Function1 $fn;

                    public void cancelled() {
                    }

                    public void completed(@NotNull HttpResponse result) {
                        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                        this.$fn.invoke((Object)invoke.1.access$toHttp4kResponse(this.this$0, result));
                    }

                    public void failed(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        Exception exception = e;
                        this.$fn.invoke((Object)Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)(exception instanceof ConnectTimeoutException ? Status.Companion.getCLIENT_TIMEOUT() : (exception instanceof SocketTimeoutException ? Status.Companion.getCLIENT_TIMEOUT() : Status.Companion.getSERVICE_UNAVAILABLE())).description("Client Error: caused by " + e.getLocalizedMessage()), null, (int)2, null));
                    }
                    {
                        this.this$0 = $outer;
                        this.$fn = $captured_local_variable$1;
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            private final Response toHttp4kResponse(@NotNull HttpResponse $receiver) {
                HttpEntity httpEntity;
                block3: {
                    void var3_3;
                    block2: {
                        HttpEntity httpEntity2;
                        Response response;
                        StatusLine statusLine = $receiver.getStatusLine();
                        Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"statusLine");
                        Response response2 = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)this.toTarget(statusLine), null, (int)2, null);
                        Header[] headerArray = $receiver.getAllHeaders();
                        Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"allHeaders");
                        Response $receiver2 = response = response2.headers(this.toTarget(headerArray));
                        httpEntity = $receiver.getEntity();
                        if (httpEntity == null) break block2;
                        HttpEntity it = httpEntity2 = httpEntity;
                        InputStream inputStream = it.getContent();
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.content");
                        httpEntity = $receiver2.body((Body)this.$responseBodyMode.invoke((Object)inputStream));
                        if (httpEntity != null) break block3;
                    }
                    httpEntity = var3_3;
                }
                return httpEntity;
            }

            private final HttpRequestBase toApacheRequest(@NotNull Request $receiver) {
                return (HttpRequestBase)new HttpEntityEnclosingRequestBase(this, $receiver){
                    final /* synthetic */ invoke.1 this$0;
                    final /* synthetic */ Request $this_toApacheRequest;

                    @NotNull
                    public String getMethod() {
                        return this.$this_toApacheRequest.getMethod().name();
                    }
                    {
                        Pair it;
                        Iterable $receiver$iv$iv;
                        HttpEntity httpEntity;
                        Object object;
                        Object object2;
                        this.this$0 = $outer;
                        this.$this_toApacheRequest = $receiver;
                        Request request = this.$this_toApacheRequest;
                        this.setURI(new URI(request.getUri().toString()));
                        invoke.toApacheRequest.1 v0 = this;
                        BodyMode bodyMode = this.this$0.$requestBodyMode;
                        if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                            long l;
                            InputStream inputStream = request.getBody().getStream();
                            String string = request.header("content-length");
                            if (string != null) {
                                object2 = string;
                                InputStream inputStream2 = inputStream;
                                object = v0;
                                long l2 = Long.parseLong((String)object2);
                                v0 = object;
                                inputStream = inputStream2;
                                l = l2;
                            } else {
                                l = -1L;
                            }
                            long l3 = l;
                            InputStream inputStream3 = inputStream;
                            httpEntity = (HttpEntity)new InputStreamEntity(inputStream3, l3);
                        } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                            httpEntity = (HttpEntity)new ByteArrayEntity(request.getBody().getPayload().array());
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        v0.setEntity(httpEntity);
                        Iterable $receiver$iv = request.getHeaders();
                        object2 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            it = (Pair)element$iv$iv;
                            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"content-length", (boolean)true))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            it = (Pair)item$iv$iv;
                            object = destination$iv$iv;
                            this.addHeader((String)it.getFirst(), (String)it.getSecond());
                            Unit unit = Unit.INSTANCE;
                            object.add(unit);
                        }
                        List cfr_ignored_0 = (List)destination$iv$iv;
                    }
                };
            }

            private final Status toTarget(@NotNull StatusLine $receiver) {
                int n = $receiver.getStatusCode();
                String string = $receiver.getReasonPhrase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reasonPhrase");
                return new Status(n, string);
            }

            /*
             * WARNING - void declaration
             */
            private final List<Pair<String, String>> toTarget(@NotNull Header[] $receiver) {
                void $receiver$iv$iv;
                Object $receiver$iv = $receiver;
                Header[] headerArray = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(((Header[])$receiver$iv).length);
                void var5_5 = $receiver$iv$iv;
                int n = ((void)var5_5).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var9_9 = item$iv$iv = var5_5[i];
                    Collection collection = destination$iv$iv;
                    Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
                    collection.add(pair);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object thisCollection$iv = $receiver$iv;
                Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                if (pairArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return CollectionsKt.listOf((Object[])Arrays.copyOf(pairArray, pairArray.length));
            }
            {
                this.$client = $captured_local_variable$0;
                this.$responseBodyMode = $captured_local_variable$1;
                this.$requestBodyMode = $captured_local_variable$2;
            }

            @NotNull
            public static final /* synthetic */ Response access$toHttp4kResponse(invoke.1 $this, @NotNull HttpResponse $receiver) {
                return $this.toHttp4kResponse($receiver);
            }
        };
    }

    @NotNull
    public static /* synthetic */ AsyncHttpClient invoke$default(ApacheAsyncClient apacheAsyncClient, CloseableHttpAsyncClient closeableHttpAsyncClient, BodyMode bodyMode, BodyMode bodyMode2, int n, Object object) {
        if ((n & 1) != 0) {
            CloseableHttpAsyncClient closeableHttpAsyncClient2 = apacheAsyncClient.defaultApacheAsyncHttpClient();
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpAsyncClient2, (String)"defaultApacheAsyncHttpClient()");
            closeableHttpAsyncClient = closeableHttpAsyncClient2;
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return apacheAsyncClient.invoke(closeableHttpAsyncClient, bodyMode, bodyMode2);
    }

    private final CloseableHttpAsyncClient defaultApacheAsyncHttpClient() {
        CloseableHttpAsyncClient closeableHttpAsyncClient;
        CloseableHttpAsyncClient $receiver = closeableHttpAsyncClient = HttpAsyncClients.custom().setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(false).setCookieSpec("ignoreCookies").build()).build();
        $receiver.start();
        return closeableHttpAsyncClient;
    }

    private ApacheAsyncClient() {
    }

    static {
        ApacheAsyncClient apacheAsyncClient;
        INSTANCE = apacheAsyncClient = new ApacheAsyncClient();
    }
}

