/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.http4k.client.ApacheClient;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004:\u0001\u001cB#\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0002J\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0010H\u0002J3\u0010\u0011\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013j\u0002`\u00150\u0012j\u0002`\u0016*\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019J\f\u0010\u0011\u001a\u00020\u001a*\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/http4k/client/ApacheClient;", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "responseBodyMode", "Lorg/http4k/core/BodyMode;", "requestBodyMode", "(Lorg/apache/http/impl/client/CloseableHttpClient;Lorg/http4k/core/BodyMode;Lorg/http4k/core/BodyMode;)V", "invoke", "request", "toApacheRequest", "Lorg/apache/http/client/methods/HttpRequestBase;", "toHttp4kResponse", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "toTarget", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "", "Lorg/apache/http/Header;", "([Lorg/apache/http/Header;)Ljava/util/List;", "Lorg/http4k/core/Status;", "Lorg/apache/http/StatusLine;", "Companion", "http4k-client-apache"})
public final class ApacheClient
implements Function1<Request, Response> {
    private final CloseableHttpClient client;
    private final BodyMode responseBodyMode;
    private final BodyMode requestBodyMode;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Response invoke(@NotNull Request request) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            response = this.toHttp4kResponse(this.client.execute((HttpUriRequest)this.toApacheRequest(request)));
        }
        catch (SocketTimeoutException e) {
            response = Response.Companion.invoke(Status.Companion.getCLIENT_TIMEOUT());
        }
        return response;
    }

    private final Response toHttp4kResponse(@NotNull CloseableHttpResponse $receiver) {
        HttpEntity httpEntity;
        block3: {
            Response baseResponse;
            block2: {
                HttpEntity httpEntity2;
                baseResponse = Response.Companion.invoke(this.toTarget($receiver.getStatusLine())).headers(this.toTarget($receiver.getAllHeaders()));
                httpEntity = $receiver.getEntity();
                if (httpEntity == null) break block2;
                HttpEntity it = httpEntity2 = httpEntity;
                InputStream inputStream = it.getContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.content");
                httpEntity = baseResponse.body((Body)this.responseBodyMode.invoke((Object)inputStream));
                if (httpEntity != null) break block3;
            }
            httpEntity = baseResponse;
        }
        return httpEntity;
    }

    private final HttpRequestBase toApacheRequest(@NotNull Request $receiver) {
        return (HttpRequestBase)new HttpEntityEnclosingRequestBase(this, $receiver){
            final /* synthetic */ ApacheClient this$0;
            final /* synthetic */ Request receiver$0;

            @NotNull
            public String getMethod() {
                return this.receiver$0.getMethod().name();
            }
            {
                Pair it;
                Iterable $receiver$iv$iv;
                HttpEntity httpEntity;
                Object object;
                InputStreamEntity inputStreamEntity;
                Object object2;
                this.this$0 = $outer;
                this.receiver$0 = $receiver;
                Request request = this.receiver$0;
                this.setURI(new URI(request.getUri().toString()));
                toApacheRequest.1 v0 = this;
                BodyMode bodyMode = ApacheClient.access$getRequestBodyMode$p($outer);
                if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                    long l;
                    InputStreamEntity inputStreamEntity2;
                    InputStreamEntity inputStreamEntity3 = inputStreamEntity2;
                    InputStreamEntity inputStreamEntity4 = inputStreamEntity2;
                    InputStream inputStream = request.getBody().getStream();
                    String string = request.header("content-length");
                    if (string != null) {
                        object2 = string;
                        InputStream inputStream2 = inputStream;
                        InputStreamEntity inputStreamEntity5 = inputStreamEntity3;
                        inputStreamEntity = inputStreamEntity4;
                        object = v0;
                        long l2 = Long.parseLong((String)object2);
                        v0 = object;
                        inputStreamEntity4 = inputStreamEntity;
                        inputStreamEntity3 = inputStreamEntity5;
                        inputStream = inputStream2;
                        l = l2;
                    } else {
                        l = -1L;
                    }
                    inputStreamEntity3(inputStream, l);
                    httpEntity = (HttpEntity)inputStreamEntity4;
                } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                    httpEntity = (HttpEntity)new ByteArrayEntity(request.getBody().getPayload().array());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                v0.setEntity(httpEntity);
                Iterable $receiver$iv = request.getHeaders();
                object2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = (Pair)element$iv$iv;
                    if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"content-length", (boolean)true))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (Pair)item$iv$iv;
                    object = destination$iv$iv;
                    this.addHeader((String)it.getFirst(), (String)it.getSecond());
                    inputStreamEntity = Unit.INSTANCE;
                    object.add(inputStreamEntity);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        };
    }

    private final Status toTarget(@NotNull StatusLine $receiver) {
        int n = $receiver.getStatusCode();
        String string = $receiver.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reasonPhrase");
        return new Status(n, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toTarget(@NotNull Header[] $receiver) {
        void $receiver$iv$iv;
        Object $receiver$iv = $receiver;
        Object[] objectArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            Header header = (Header)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[thisCollection$iv.size()]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return CollectionsKt.listOf((Object[])Arrays.copyOf(pairArray, pairArray.length));
    }

    public ApacheClient(@NotNull CloseableHttpClient client, @NotNull BodyMode responseBodyMode, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkParameterIsNotNull((Object)requestBodyMode, (String)"requestBodyMode");
        this.client = client;
        this.responseBodyMode = responseBodyMode;
        this.requestBodyMode = requestBodyMode;
    }

    public /* synthetic */ ApacheClient(CloseableHttpClient closeableHttpClient, BodyMode bodyMode, BodyMode bodyMode2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            CloseableHttpClient closeableHttpClient2 = ApacheClient.Companion.defaultApacheHttpClient();
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient2, (String)"defaultApacheHttpClient()");
            closeableHttpClient = closeableHttpClient2;
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        this(closeableHttpClient, bodyMode, bodyMode2);
    }

    public ApacheClient() {
        this(null, null, null, 7, null);
    }

    @NotNull
    public static final /* synthetic */ BodyMode access$getRequestBodyMode$p(ApacheClient $this) {
        return $this.requestBodyMode;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lorg/http4k/client/ApacheClient$Companion;", "", "()V", "defaultApacheHttpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "kotlin.jvm.PlatformType", "http4k-client-apache"})
    public static final class Companion {
        private final CloseableHttpClient defaultApacheHttpClient() {
            return HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(false).setCookieSpec("ignoreCookies").build()).build();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

