/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.http4k.client.ApacheClient$WhenMappings;
import org.http4k.client.ApacheRequest;
import org.http4k.client.ExtKt;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002J7\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rH\u0086\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0014\u0010\u0011\u001a\u00020\t*\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J3\u0010\u0013\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015j\u0002`\u00170\u0014j\u0002`\u0018*\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u0013\u001a\u00020\u001c*\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/http4k/client/ApacheClient;", "", "()V", "defaultApacheHttpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "kotlin.jvm.PlatformType", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "client", "responseBodyMode", "Lorg/http4k/core/BodyMode;", "requestBodyMode", "toApacheRequest", "Lorg/apache/http/client/methods/HttpRequestBase;", "toHttp4kResponse", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "toTarget", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "", "Lorg/apache/http/Header;", "([Lorg/apache/http/Header;)Ljava/util/List;", "Lorg/http4k/core/Status;", "Lorg/apache/http/StatusLine;", "http4k-client-apache"})
public final class ApacheClient {
    public static final ApacheClient INSTANCE;

    @NotNull
    public final Function1<Request, Response> invoke(@NotNull CloseableHttpClient client, @NotNull BodyMode responseBodyMode, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkParameterIsNotNull((Object)requestBodyMode, (String)"requestBodyMode");
        return (Function1)new Function1<Request, Response>(client, requestBodyMode, responseBodyMode){
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ BodyMode $requestBodyMode;
            final /* synthetic */ BodyMode $responseBodyMode;

            @NotNull
            public final Response invoke(@NotNull Request request) {
                Response response;
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                try {
                    CloseableHttpResponse closeableHttpResponse = this.$client.execute((HttpUriRequest)ApacheClient.access$toApacheRequest(ApacheClient.INSTANCE, request, this.$requestBodyMode));
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"client.execute(request.t\u2026Request(requestBodyMode))");
                    response = ApacheClient.access$toHttp4kResponse(ApacheClient.INSTANCE, closeableHttpResponse, this.$responseBodyMode);
                }
                catch (ConnectTimeoutException e) {
                    response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getCLIENT_TIMEOUT(), (Exception)((Exception)((Object)e))), null, (int)2, null);
                }
                catch (SocketTimeoutException e) {
                    response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getCLIENT_TIMEOUT(), (Exception)e), null, (int)2, null);
                }
                catch (HttpHostConnectException e) {
                    response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getCONNECTION_REFUSED(), (Exception)((Exception)((Object)e))), null, (int)2, null);
                }
                catch (UnknownHostException e) {
                    response = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.Companion.getUNKNOWN_HOST(), (Exception)e), null, (int)2, null);
                }
                return response;
            }
            {
                this.$client = closeableHttpClient;
                this.$requestBodyMode = bodyMode;
                this.$responseBodyMode = bodyMode2;
                super(1);
            }
        };
    }

    @NotNull
    public static /* synthetic */ Function1 invoke$default(ApacheClient apacheClient, CloseableHttpClient closeableHttpClient, BodyMode bodyMode, BodyMode bodyMode2, int n, Object object) {
        if ((n & 1) != 0) {
            CloseableHttpClient closeableHttpClient2 = apacheClient.defaultApacheHttpClient();
            Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpClient2, (String)"defaultApacheHttpClient()");
            closeableHttpClient = closeableHttpClient2;
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return apacheClient.invoke(closeableHttpClient, bodyMode, bodyMode2);
    }

    private final HttpRequestBase toApacheRequest(@NotNull Request $receiver, BodyMode requestBodyMode) {
        Pair it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        HttpRequestBase httpRequestBase;
        Request request = $receiver;
        URI uri = new URI(request.getUri().toString());
        switch (ApacheClient$WhenMappings.$EnumSwitchMapping$0[$receiver.getMethod().ordinal()]) {
            case 1: {
                httpRequestBase = (HttpRequestBase)new HttpHead(uri);
                break;
            }
            case 2: {
                httpRequestBase = (HttpRequestBase)new HttpGet(uri);
                break;
            }
            case 3: {
                httpRequestBase = (HttpRequestBase)new HttpOptions(uri);
                break;
            }
            case 4: {
                httpRequestBase = (HttpRequestBase)new HttpTrace(uri);
                break;
            }
            case 5: {
                httpRequestBase = (HttpRequestBase)new HttpDelete(uri);
                break;
            }
            default: {
                httpRequestBase = (HttpRequestBase)new ApacheRequest(requestBodyMode, request);
            }
        }
        HttpRequestBase apacheRequest = httpRequestBase;
        Iterable iterable = $receiver$iv = (Iterable)request.getHeaders();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"content-length", (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            apacheRequest.addHeader((String)it.getFirst(), (String)it.getSecond());
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return apacheRequest;
    }

    private final Status toTarget(@NotNull StatusLine $receiver) {
        int n = $receiver.getStatusCode();
        String string = $receiver.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reasonPhrase");
        return new Status(n, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toTarget(@NotNull Header[] $receiver) {
        void $receiver$iv$iv;
        Object $receiver$iv = $receiver;
        Header[] headerArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Header[])$receiver$iv).length);
        void var5_5 = $receiver$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
            collection.add(pair);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return CollectionsKt.listOf((Object[])Arrays.copyOf(pairArray, pairArray.length));
    }

    private final Response toHttp4kResponse(@NotNull CloseableHttpResponse $receiver, BodyMode responseBodyMode) {
        HttpEntity httpEntity;
        block3: {
            Response $receiver2;
            block2: {
                HttpEntity httpEntity2;
                Response response;
                StatusLine statusLine = $receiver.getStatusLine();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusLine, (String)"statusLine");
                Response response2 = Response.Companion.invoke$default((Response.Companion)Response.Companion, (Status)this.toTarget(statusLine), null, (int)2, null);
                Header[] headerArray = $receiver.getAllHeaders();
                Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"allHeaders");
                $receiver2 = response = response2.headers(this.toTarget(headerArray));
                httpEntity = $receiver.getEntity();
                if (httpEntity == null) break block2;
                HttpEntity it = httpEntity2 = httpEntity;
                InputStream inputStream = it.getContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.content");
                httpEntity = $receiver2.body((Body)responseBodyMode.invoke((Object)inputStream));
                if (httpEntity != null) break block3;
            }
            httpEntity = $receiver2;
        }
        return httpEntity;
    }

    private final CloseableHttpClient defaultApacheHttpClient() {
        return HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(false).setCookieSpec("ignoreCookies").build()).build();
    }

    private ApacheClient() {
    }

    static {
        ApacheClient apacheClient;
        INSTANCE = apacheClient = new ApacheClient();
    }

    @NotNull
    public static final /* synthetic */ Response access$toHttp4kResponse(ApacheClient $this, @NotNull CloseableHttpResponse $receiver, @NotNull BodyMode responseBodyMode) {
        return $this.toHttp4kResponse($receiver, responseBodyMode);
    }

    @NotNull
    public static final /* synthetic */ HttpRequestBase access$toApacheRequest(ApacheClient $this, @NotNull Request $receiver, @NotNull BodyMode requestBodyMode) {
        return $this.toApacheRequest($receiver, requestBodyMode);
    }
}

