/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.http4k.client.ApacheClient$WhenMappings;
import org.http4k.client.ApacheRequest;
import org.http4k.client.ExtKt;
import org.http4k.client.PreCannedApacheHttpClients;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0087\u0002\u00a2\u0006\u0002\b\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0014\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J3\u0010\u0012\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014j\u0002`\u00160\u0013j\u0002`\u0017*\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/http4k/client/ApacheClient;", "", "()V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "client", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "responseBodyMode", "Lorg/http4k/core/BodyMode;", "requestBodyMode", "create", "toApacheRequest", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;", "toHttp4kResponse", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpResponse;", "toTarget", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "", "Lorg/apache/hc/core5/http/Header;", "([Lorg/apache/hc/core5/http/Header;)Ljava/util/List;", "toTargetStatus", "Lorg/http4k/core/Status;", "Lorg/apache/hc/core5/http/HttpResponse;", "http4k-client-apache"})
public final class ApacheClient {
    public static final ApacheClient INSTANCE;

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull CloseableHttpClient client, @NotNull BodyMode responseBodyMode, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkParameterIsNotNull((Object)requestBodyMode, (String)"requestBodyMode");
        return (Function1)new Function1<Request, Response>(client, requestBodyMode, responseBodyMode){
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ BodyMode $requestBodyMode;
            final /* synthetic */ BodyMode $responseBodyMode;

            @NotNull
            public final Response invoke(@NotNull Request request) {
                Response response;
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                try {
                    CloseableHttpResponse closeableHttpResponse = this.$client.execute((ClassicHttpRequest)ApacheClient.access$toApacheRequest(ApacheClient.INSTANCE, request, this.$requestBodyMode));
                    Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"client.execute(request.t\u2026Request(requestBodyMode))");
                    response = ApacheClient.access$toHttp4kResponse(ApacheClient.INSTANCE, closeableHttpResponse, this.$responseBodyMode);
                }
                catch (ConnectTimeoutException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)((Exception)((Object)e))), null, (int)2, null);
                }
                catch (SocketTimeoutException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                }
                catch (HttpHostConnectException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CONNECTION_REFUSED, (Exception)((Exception)((Object)e))), null, (int)2, null);
                }
                catch (UnknownHostException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                }
                return response;
            }
            {
                this.$client = closeableHttpClient;
                this.$requestBodyMode = bodyMode;
                this.$responseBodyMode = bodyMode2;
                super(1);
            }
        };
    }

    public static /* synthetic */ Function1 create$default(CloseableHttpClient closeableHttpClient, BodyMode bodyMode, BodyMode bodyMode2, int n, Object object) {
        if ((n & 1) != 0) {
            closeableHttpClient = PreCannedApacheHttpClients.INSTANCE.defaultApacheHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return ApacheClient.create(closeableHttpClient, bodyMode, bodyMode2);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull CloseableHttpClient client, @NotNull BodyMode responseBodyMode) {
        return ApacheClient.create$default(client, responseBodyMode, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull CloseableHttpClient client) {
        return ApacheClient.create$default(client, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create() {
        return ApacheClient.create$default(null, null, null, 7, null);
    }

    /*
     * WARNING - void declaration
     */
    private final HttpUriRequestBase toApacheRequest(@NotNull Request $this$toApacheRequest, BodyMode requestBodyMode) {
        void $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        HttpUriRequestBase httpUriRequestBase;
        Request request = $this$toApacheRequest;
        URI uri = new URI(request.getUri().toString());
        switch (ApacheClient$WhenMappings.$EnumSwitchMapping$0[$this$toApacheRequest.getMethod().ordinal()]) {
            case 1: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpHead(uri);
                break;
            }
            case 2: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpGet(uri);
                break;
            }
            case 3: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpOptions(uri);
                break;
            }
            case 4: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpTrace(uri);
                break;
            }
            case 5: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpDelete(uri);
                break;
            }
            default: {
                httpUriRequestBase = new ApacheRequest(requestBodyMode, request);
            }
        }
        HttpUriRequestBase apacheRequest = httpUriRequestBase;
        Iterable $this$filter$iv = request.getHeaders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"content-length", (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            apacheRequest.addHeader((String)it.getFirst(), it.getSecond());
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return apacheRequest;
    }

    private final Status toTargetStatus(@NotNull HttpResponse $this$toTargetStatus) {
        int n = $this$toTargetStatus.getCode();
        String string = $this$toTargetStatus.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reasonPhrase");
        return new Status(n, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toTarget(@NotNull Header[] $this$toTarget) {
        void $this$mapTo$iv$iv;
        Header[] $this$map$iv = $this$toTarget;
        boolean $i$f$map = false;
        Header[] headerArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
            collection.add(pair);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return CollectionsKt.listOf((Object[])Arrays.copyOf(pairArray, pairArray.length));
    }

    private final Response toHttp4kResponse(@NotNull CloseableHttpResponse $this$toHttp4kResponse, BodyMode responseBodyMode) {
        HttpEntity httpEntity;
        block3: {
            Response $this$with;
            block2: {
                Response response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)this.toTargetStatus((HttpResponse)$this$toHttp4kResponse), null, (int)2, null);
                Header[] headerArray = $this$toHttp4kResponse.getHeaders();
                Intrinsics.checkExpressionValueIsNotNull((Object)headerArray, (String)"headers");
                Response response2 = response.headers(this.toTarget(headerArray));
                boolean bl = false;
                boolean bl2 = false;
                $this$with = response2;
                boolean bl3 = false;
                httpEntity = $this$toHttp4kResponse.getEntity();
                if (httpEntity == null) break block2;
                HttpEntity httpEntity2 = httpEntity;
                boolean bl4 = false;
                boolean bl5 = false;
                HttpEntity it = httpEntity2;
                boolean bl6 = false;
                InputStream inputStream = it.getContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it.content");
                httpEntity = $this$with.body((Body)responseBodyMode.invoke((Object)inputStream));
                if (httpEntity != null) break block3;
            }
            httpEntity = $this$with;
        }
        return httpEntity;
    }

    private ApacheClient() {
    }

    static {
        ApacheClient apacheClient;
        INSTANCE = apacheClient = new ApacheClient();
    }

    public static final /* synthetic */ Response access$toHttp4kResponse(ApacheClient $this, CloseableHttpResponse $this$access_u24toHttp4kResponse, BodyMode responseBodyMode) {
        return $this.toHttp4kResponse($this$access_u24toHttp4kResponse, responseBodyMode);
    }

    public static final /* synthetic */ HttpUriRequestBase access$toApacheRequest(ApacheClient $this, Request $this$access_u24toApacheRequest, BodyMode requestBodyMode) {
        return $this.toApacheRequest($this$access_u24toApacheRequest, requestBodyMode);
    }
}

