/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.net.URI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/http4k/client/ApacheRequest;", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;", "requestBodyMode", "Lorg/http4k/core/BodyMode;", "request", "Lorg/http4k/core/Request;", "(Lorg/http4k/core/BodyMode;Lorg/http4k/core/Request;)V", "getMethod", "", "http4k-client-apache"})
final class ApacheRequest
extends HttpUriRequestBase {
    @NotNull
    private final Request request;

    public ApacheRequest(@NotNull BodyMode requestBodyMode, @NotNull Request request) {
        HttpEntity httpEntity;
        Intrinsics.checkNotNullParameter((Object)requestBodyMode, (String)"requestBodyMode");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(request.getMethod().toString(), new URI(request.getUri().toString()));
        this.request = request;
        BodyMode bodyMode = requestBodyMode;
        if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
            String string = this.request.header("content-length");
            httpEntity = (HttpEntity)new InputStreamEntity(this.request.getBody().getStream(), string != null ? Long.parseLong(string) : -1L, null);
        } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
            httpEntity = (HttpEntity)new ByteArrayEntity(this.request.getBody().getPayload().array(), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.setEntity(httpEntity);
    }

    @NotNull
    public String getMethod() {
        return this.request.getMethod().name();
    }
}

