/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.http4k.client.ApacheClient;
import org.http4k.client.ApacheRequest;
import org.http4k.client.ExtKt;
import org.http4k.client.PreCannedApacheHttpClients;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0087\u0002\u00a2\u0006\u0002\b\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0014\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J3\u0010\u0012\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014j\u0002`\u00160\u0013j\u0002`\u0017*\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/http4k/client/ApacheClient;", "", "()V", "invoke", "Lkotlin/Function1;", "Lorg/http4k/core/Request;", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "client", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "responseBodyMode", "Lorg/http4k/core/BodyMode;", "requestBodyMode", "create", "toApacheRequest", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequestBase;", "toHttp4kResponse", "Lorg/apache/hc/core5/http/ClassicHttpResponse;", "toTarget", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "", "Lorg/apache/hc/core5/http/Header;", "([Lorg/apache/hc/core5/http/Header;)Ljava/util/List;", "toTargetStatus", "Lorg/http4k/core/Status;", "Lorg/apache/hc/core5/http/HttpResponse;", "http4k-client-apache"})
public final class ApacheClient {
    @NotNull
    public static final ApacheClient INSTANCE = new ApacheClient();

    private ApacheClient() {
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull CloseableHttpClient client, @NotNull BodyMode responseBodyMode, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkNotNullParameter((Object)requestBodyMode, (String)"requestBodyMode");
        return (Function1)new Function1<Request, Response>(responseBodyMode, client, requestBodyMode){
            final /* synthetic */ BodyMode $responseBodyMode;
            final /* synthetic */ CloseableHttpClient $client;
            final /* synthetic */ BodyMode $requestBodyMode;
            {
                this.$responseBodyMode = $responseBodyMode;
                this.$client = $client;
                this.$requestBodyMode = $requestBodyMode;
                super(1);
            }

            @NotNull
            public final Response invoke(@NotNull Request request) {
                Response response;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    Response response2;
                    BodyMode bodyMode = this.$responseBodyMode;
                    if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                        response2 = (Response)this.$client.execute((ClassicHttpRequest)ApacheClient.access$toApacheRequest(ApacheClient.INSTANCE, request, this.$requestBodyMode), arg_0 -> invoke.1.invoke$lambda$0(this.$responseBodyMode, arg_0));
                    } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                        ClassicHttpResponse classicHttpResponse = this.$client.executeOpen(null, (ClassicHttpRequest)ApacheClient.access$toApacheRequest(ApacheClient.INSTANCE, request, this.$requestBodyMode), null);
                        Intrinsics.checkNotNullExpressionValue((Object)classicHttpResponse, (String)"client.executeOpen(null,\u2026t(requestBodyMode), null)");
                        response2 = ApacheClient.access$toHttp4kResponse(ApacheClient.INSTANCE, classicHttpResponse, this.$responseBodyMode);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    response = response2;
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"{\n            when (resp\u2026)\n            }\n        }");
                }
                catch (ConnectTimeoutException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)((Exception)((Object)e))), null, (int)2, null);
                }
                catch (SocketTimeoutException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                }
                catch (HttpHostConnectException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CONNECTION_REFUSED, (Exception)((Exception)((Object)e))), null, (int)2, null);
                }
                catch (UnknownHostException e) {
                    response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                }
                return response;
            }

            private static final Response invoke$lambda$0(BodyMode $responseBodyMode, ClassicHttpResponse it) {
                Intrinsics.checkNotNullParameter((Object)$responseBodyMode, (String)"$responseBodyMode");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return ApacheClient.access$toHttp4kResponse(ApacheClient.INSTANCE, it, $responseBodyMode);
            }
        };
    }

    public static /* synthetic */ Function1 create$default(CloseableHttpClient closeableHttpClient, BodyMode bodyMode, BodyMode bodyMode2, int n, Object object) {
        if ((n & 1) != 0) {
            closeableHttpClient = PreCannedApacheHttpClients.INSTANCE.defaultApacheHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return ApacheClient.create(closeableHttpClient, bodyMode, bodyMode2);
    }

    /*
     * WARNING - void declaration
     */
    private final HttpUriRequestBase toApacheRequest(Request $this$toApacheRequest, BodyMode requestBodyMode) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        HttpUriRequestBase httpUriRequestBase;
        Request request = $this$toApacheRequest;
        URI uri = new URI(request.getUri().toString());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toApacheRequest.getMethod().ordinal()]) {
            case 1: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpHead(uri);
                break;
            }
            case 2: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpGet(uri);
                break;
            }
            case 3: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpOptions(uri);
                break;
            }
            case 4: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpTrace(uri);
                break;
            }
            case 5: {
                httpUriRequestBase = (HttpUriRequestBase)new HttpDelete(uri);
                break;
            }
            default: {
                httpUriRequestBase = new ApacheRequest(requestBodyMode, request);
            }
        }
        HttpUriRequestBase apacheRequest = httpUriRequestBase;
        Iterable $this$filter$iv = request.getHeaders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"content-length", (boolean)true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            apacheRequest.addHeader((String)it.getFirst(), it.getSecond());
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return apacheRequest;
    }

    private final Status toTargetStatus(HttpResponse $this$toTargetStatus) {
        return new Status($this$toTargetStatus.getCode(), $this$toTargetStatus.getReasonPhrase());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, String>> toTarget(Header[] $this$toTarget) {
        void $this$mapTo$iv$iv;
        Header[] $this$map$iv = $this$toTarget;
        boolean $i$f$map = false;
        Header[] headerArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Response toHttp4kResponse(ClassicHttpResponse $this$toHttp4kResponse, BodyMode responseBodyMode) {
        HttpEntity httpEntity;
        block3: {
            void var3_3;
            block2: {
                Response response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)this.toTargetStatus((HttpResponse)$this$toHttp4kResponse), null, (int)2, null);
                Header[] headerArray = $this$toHttp4kResponse.getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"headers");
                Response $this$toHttp4kResponse_u24lambda_u244 = response.headers(this.toTarget(headerArray));
                boolean bl = false;
                HttpEntity httpEntity2 = $this$toHttp4kResponse.getEntity();
                httpEntity = httpEntity2;
                if (httpEntity == null) break block2;
                Intrinsics.checkNotNullExpressionValue((Object)httpEntity, (String)"entity");
                HttpEntity it = httpEntity2;
                boolean bl2 = false;
                InputStream inputStream = it.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it.content");
                Response response2 = $this$toHttp4kResponse_u24lambda_u244.body((Body)responseBodyMode.invoke((Object)inputStream));
                httpEntity = response2;
                if (response2 != null) break block3;
            }
            httpEntity = var3_3;
        }
        return httpEntity;
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull CloseableHttpClient client, @NotNull BodyMode responseBodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)responseBodyMode, (String)"responseBodyMode");
        return ApacheClient.create$default(client, responseBodyMode, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create(@NotNull CloseableHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return ApacheClient.create$default(client, null, null, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final Function1<Request, Response> create() {
        return ApacheClient.create$default(null, null, null, 7, null);
    }

    public static final /* synthetic */ HttpUriRequestBase access$toApacheRequest(ApacheClient $this, Request $receiver, BodyMode requestBodyMode) {
        return $this.toApacheRequest($receiver, requestBodyMode);
    }

    public static final /* synthetic */ Response access$toHttp4kResponse(ApacheClient $this, ClassicHttpResponse $receiver, BodyMode responseBodyMode) {
        return $this.toHttp4kResponse($receiver, responseBodyMode);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.OPTIONS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.TRACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.DELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

