/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.http4k.client.Apache4AsyncClient;
import org.http4k.client.AsyncHttpClient;
import org.http4k.client.ExtKt;
import org.http4k.core.Body;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004H\u0002J'\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/http4k/client/Apache4AsyncClient;", "", "()V", "defaultApacheAsyncHttpClient", "Lorg/apache/http/impl/nio/client/CloseableHttpAsyncClient;", "kotlin.jvm.PlatformType", "invoke", "Lorg/http4k/client/AsyncHttpClient;", "client", "responseBodyMode", "Lorg/http4k/core/BodyMode;", "requestBodyMode", "http4k-client-apache4-async"})
public final class Apache4AsyncClient {
    @NotNull
    public static final Apache4AsyncClient INSTANCE;

    @NotNull
    public final AsyncHttpClient invoke(@NotNull CloseableHttpAsyncClient client, @NotNull BodyMode responseBodyMode, @NotNull BodyMode requestBodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)responseBodyMode, (String)"responseBodyMode");
        Intrinsics.checkNotNullParameter((Object)requestBodyMode, (String)"requestBodyMode");
        if (!client.isRunning()) {
            client.start();
        }
        return new AsyncHttpClient(client, responseBodyMode, requestBodyMode){
            final /* synthetic */ CloseableHttpAsyncClient $client;
            final /* synthetic */ BodyMode $responseBodyMode;
            final /* synthetic */ BodyMode $requestBodyMode;

            public void close() {
                this.$client.close();
            }

            public void invoke(@NotNull Request request, @NotNull Function1<? super Response, Unit> fn) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                this.$client.execute((HttpUriRequest)this.toApacheRequest(request), (FutureCallback)new FutureCallback<HttpResponse>(this, fn){
                    final /* synthetic */ invoke.1 this$0;
                    final /* synthetic */ Function1 $fn;

                    public void cancelled() {
                    }

                    public void completed(@NotNull HttpResponse result) {
                        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                        this.$fn.invoke((Object)invoke.1.access$toHttp4kResponse(this.this$0, result));
                    }

                    public void failed(@NotNull Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Exception exception = e;
                        this.$fn.invoke((Object)Response.Companion.create$default((Response.Companion)Response.Companion, (Status)ExtKt.toClientStatus((Status)(exception instanceof ConnectTimeoutException ? Status.CLIENT_TIMEOUT : (exception instanceof SocketTimeoutException ? Status.CLIENT_TIMEOUT : Status.SERVICE_UNAVAILABLE)), (Exception)e), null, (int)2, null));
                    }
                    {
                        this.this$0 = this$0;
                        this.$fn = $captured_local_variable$1;
                    }
                });
            }

            private final Response toHttp4kResponse(HttpResponse $this$toHttp4kResponse) {
                HttpEntity httpEntity;
                block3: {
                    Response $this$run;
                    block2: {
                        StatusLine statusLine = $this$toHttp4kResponse.getStatusLine();
                        Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"statusLine");
                        Response response = Response.Companion.create$default((Response.Companion)Response.Companion, (Status)this.toTarget(statusLine), null, (int)2, null);
                        Header[] headerArray = $this$toHttp4kResponse.getAllHeaders();
                        Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"allHeaders");
                        Response response2 = response.headers(this.toTarget(headerArray));
                        boolean bl = false;
                        boolean bl2 = false;
                        $this$run = response2;
                        boolean bl3 = false;
                        httpEntity = $this$toHttp4kResponse.getEntity();
                        if (httpEntity == null) break block2;
                        HttpEntity httpEntity2 = httpEntity;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        HttpEntity it = httpEntity2;
                        boolean bl6 = false;
                        InputStream inputStream = it.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it.content");
                        httpEntity = $this$run.body((Body)this.$responseBodyMode.invoke((Object)inputStream));
                        if (httpEntity != null) break block3;
                    }
                    httpEntity = $this$run;
                }
                return httpEntity;
            }

            private final HttpRequestBase toApacheRequest(Request $this$toApacheRequest) {
                return (HttpRequestBase)new HttpEntityEnclosingRequestBase(this, $this$toApacheRequest){
                    final /* synthetic */ invoke.1 this$0;
                    final /* synthetic */ Request $this_toApacheRequest;

                    @NotNull
                    public String getMethod() {
                        return this.$this_toApacheRequest.getMethod().name();
                    }
                    {
                        void $this$mapTo$iv$iv;
                        Pair it;
                        Iterable $this$filterTo$iv$iv;
                        HttpEntity httpEntity;
                        this.this$0 = this$0;
                        this.$this_toApacheRequest = $receiver;
                        Request request = this.$this_toApacheRequest;
                        this.setURI(new URI(request.getUri().toString()));
                        BodyMode bodyMode = this.this$0.$requestBodyMode;
                        if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Stream.INSTANCE)) {
                            long l;
                            InputStream inputStream = request.getBody().getStream();
                            String string = request.header("content-length");
                            if (string != null) {
                                String string2 = string;
                                boolean bl = false;
                                l = Long.parseLong(string2);
                            } else {
                                l = -1L;
                            }
                            httpEntity = (HttpEntity)new InputStreamEntity(inputStream, l);
                        } else if (Intrinsics.areEqual((Object)bodyMode, (Object)BodyMode.Memory.INSTANCE)) {
                            httpEntity = (HttpEntity)new ByteArrayEntity(request.getBody().getPayload().array());
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        this.setEntity(httpEntity);
                        Iterable $this$filter$iv = request.getHeaders();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Pair)element$iv$iv;
                            boolean bl = false;
                            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"content-length", (boolean)true))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (Pair)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            this.addHeader((String)it.getFirst(), (String)it.getSecond());
                            Unit unit = Unit.INSTANCE;
                            collection.add(unit);
                        }
                        List cfr_ignored_0 = (List)destination$iv$iv;
                    }
                };
            }

            private final Status toTarget(StatusLine $this$toTarget) {
                int n = $this$toTarget.getStatusCode();
                String string = $this$toTarget.getReasonPhrase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reasonPhrase");
                return new Status(n, string);
            }

            /*
             * WARNING - void declaration
             */
            private final List<Pair<String, String>> toTarget(Header[] $this$toTarget) {
                void $this$mapTo$iv$iv;
                Header[] $this$map$iv = $this$toTarget;
                boolean $i$f$map = false;
                Header[] headerArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var7_7 = $this$mapTo$iv$iv;
                int n = ((void)var7_7).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = var7_7[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getValue());
                    collection.add(pair);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                if (pairArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                return CollectionsKt.listOf((Object[])Arrays.copyOf(pairArray, pairArray.length));
            }
            {
                this.$client = $captured_local_variable$0;
                this.$responseBodyMode = $captured_local_variable$1;
                this.$requestBodyMode = $captured_local_variable$2;
            }

            public static final /* synthetic */ Response access$toHttp4kResponse(invoke.1 $this, HttpResponse $this$access_u24toHttp4kResponse) {
                return $this.toHttp4kResponse($this$access_u24toHttp4kResponse);
            }
        };
    }

    public static /* synthetic */ AsyncHttpClient invoke$default(Apache4AsyncClient apache4AsyncClient, CloseableHttpAsyncClient closeableHttpAsyncClient, BodyMode bodyMode, BodyMode bodyMode2, int n, Object object) {
        if ((n & 1) != 0) {
            CloseableHttpAsyncClient closeableHttpAsyncClient2 = apache4AsyncClient.defaultApacheAsyncHttpClient();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpAsyncClient2, (String)"defaultApacheAsyncHttpClient()");
            closeableHttpAsyncClient = closeableHttpAsyncClient2;
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        if ((n & 4) != 0) {
            bodyMode2 = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return apache4AsyncClient.invoke(closeableHttpAsyncClient, bodyMode, bodyMode2);
    }

    private final CloseableHttpAsyncClient defaultApacheAsyncHttpClient() {
        CloseableHttpAsyncClient closeableHttpAsyncClient = HttpAsyncClients.custom().setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(false).setCookieSpec("ignoreCookies").build()).build();
        boolean bl = false;
        boolean bl2 = false;
        CloseableHttpAsyncClient $this$apply = closeableHttpAsyncClient;
        boolean bl3 = false;
        $this$apply.start();
        return closeableHttpAsyncClient;
    }

    private Apache4AsyncClient() {
    }

    static {
        Apache4AsyncClient apache4AsyncClient;
        INSTANCE = apache4AsyncClient = new Apache4AsyncClient();
    }
}

