/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.http4k.client.DualSyncAsyncHttpHandler;
import org.http4k.client.ExtKt;
import org.http4k.client.OkHttpKt;
import org.http4k.client.PreCannedOkHttpClients;
import org.http4k.core.BodyMode;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Status;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\u0002\u00a2\u0006\u0002\b\n\u00a8\u0006\f"}, d2={"Lorg/http4k/client/OkHttp;", "", "<init>", "()V", "invoke", "Lorg/http4k/client/DualSyncAsyncHttpHandler;", "client", "Lokhttp3/OkHttpClient;", "bodyMode", "Lorg/http4k/core/BodyMode;", "create", "Http4kCallback", "http4k-client-okhttp"})
public final class OkHttp {
    @NotNull
    public static final OkHttp INSTANCE = new OkHttp();

    private OkHttp() {
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create(@NotNull OkHttpClient client, @NotNull BodyMode bodyMode) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)bodyMode, (String)"bodyMode");
        return new DualSyncAsyncHttpHandler(client, bodyMode){
            final /* synthetic */ OkHttpClient $client;
            final /* synthetic */ BodyMode $bodyMode;
            {
                this.$client = $client;
                this.$bodyMode = $bodyMode;
            }

            public org.http4k.core.Response invoke(Request request) {
                org.http4k.core.Response response;
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                try {
                    response = OkHttpKt.access$asHttp4k(this.$client.newCall(OkHttpKt.asOkHttp(request)).execute(), this.$bodyMode);
                }
                catch (ConnectException e) {
                    response = Response.Companion.create$default((Response.Companion)org.http4k.core.Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CONNECTION_REFUSED, (Exception)e), null, (int)2, null);
                }
                catch (UnknownHostException e) {
                    response = Response.Companion.create$default((Response.Companion)org.http4k.core.Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                }
                catch (NoRouteToHostException e) {
                    response = Response.Companion.create$default((Response.Companion)org.http4k.core.Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.UNKNOWN_HOST, (Exception)e), null, (int)2, null);
                }
                catch (InterruptedIOException e) {
                    org.http4k.core.Response response2;
                    if (e instanceof SocketTimeoutException) {
                        response2 = Response.Companion.create$default((Response.Companion)org.http4k.core.Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                    } else if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"timeout")) {
                        response2 = Response.Companion.create$default((Response.Companion)org.http4k.core.Response.Companion, (Status)ExtKt.toClientStatus((Status)Status.CLIENT_TIMEOUT, (Exception)e), null, (int)2, null);
                    } else {
                        throw e;
                    }
                    response = response2;
                }
                return response;
            }

            public void invoke(Request request, Function1<? super org.http4k.core.Response, Unit> fn) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                this.$client.newCall(OkHttpKt.asOkHttp(request)).enqueue((Callback)new Http4kCallback(this.$bodyMode, fn));
            }
        };
    }

    public static /* synthetic */ DualSyncAsyncHttpHandler create$default(OkHttpClient okHttpClient, BodyMode bodyMode, int n, Object object) {
        if ((n & 1) != 0) {
            okHttpClient = PreCannedOkHttpClients.INSTANCE.defaultOkHttpClient();
        }
        if ((n & 2) != 0) {
            bodyMode = (BodyMode)BodyMode.Memory.INSTANCE;
        }
        return OkHttp.create(okHttpClient, bodyMode);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return OkHttp.create$default(client, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    @JvmName(name="create")
    @NotNull
    public static final DualSyncAsyncHttpHandler create() {
        return OkHttp.create$default(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/http4k/client/OkHttp$Http4kCallback;", "Lokhttp3/Callback;", "bodyMode", "Lorg/http4k/core/BodyMode;", "fn", "Lkotlin/Function1;", "Lorg/http4k/core/Response;", "", "<init>", "(Lorg/http4k/core/BodyMode;Lkotlin/jvm/functions/Function1;)V", "onFailure", "call", "Lokhttp3/Call;", "e", "Ljava/io/IOException;", "onResponse", "response", "Lokhttp3/Response;", "http4k-client-okhttp"})
    private static final class Http4kCallback
    implements Callback {
        @NotNull
        private final BodyMode bodyMode;
        @NotNull
        private final Function1<org.http4k.core.Response, Unit> fn;

        public Http4kCallback(@NotNull BodyMode bodyMode, @NotNull Function1<? super org.http4k.core.Response, Unit> fn) {
            Intrinsics.checkNotNullParameter((Object)bodyMode, (String)"bodyMode");
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            this.bodyMode = bodyMode;
            this.fn = fn;
        }

        public void onFailure(@NotNull Call call, @NotNull IOException e) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.fn.invoke((Object)Response.Companion.create$default((Response.Companion)org.http4k.core.Response.Companion, (Status)(e instanceof SocketTimeoutException ? Status.CLIENT_TIMEOUT : Status.SERVICE_UNAVAILABLE).description("Client Error: caused by " + e.getLocalizedMessage()), null, (int)2, null));
        }

        public void onResponse(@NotNull Call call, @NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.fn.invoke((Object)OkHttpKt.access$asHttp4k(response, this.bodyMode));
        }
    }
}

