/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.http4k.client.OkHttpKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001#Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\u000fj\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/http4k/client/OkHttpNonBlockingWebsocket;", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "client", "Lokhttp3/OkHttpClient;", "onError", "Lkotlin/Function1;", "", "", "onConnect", "Lorg/http4k/websocket/Websocket;", "Lorg/http4k/websocket/WsConsumer;", "<init>", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lokhttp3/OkHttpClient;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "req", "Lorg/http4k/core/Request;", "getReq", "()Lorg/http4k/core/Request;", "ws", "Lokhttp3/WebSocket;", "send", "message", "Lorg/http4k/websocket/WsMessage;", "close", "status", "Lorg/http4k/websocket/WsStatus;", "Listener", "http4k-client-okhttp"})
final class OkHttpNonBlockingWebsocket
extends PushPullAdaptingWebSocket {
    @NotNull
    private final Function1<Websocket, Unit> onConnect;
    @NotNull
    private final Request req;
    @NotNull
    private final WebSocket ws;

    public OkHttpNonBlockingWebsocket(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull OkHttpClient client, @NotNull Function1<? super Throwable, Unit> onError, @NotNull Function1<? super Websocket, Unit> onConnect) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
        this.onConnect = onConnect;
        this.req = Request.Companion.create$default((Request.Companion)Request.Companion, (Method)Method.GET, (Uri)uri, null, (int)4, null).headers(headers);
        this.onError(onError);
        this.ws = client.newBuilder().connectTimeout(timeout).build().newWebSocket(OkHttpKt.asOkHttp(this.req), (WebSocketListener)new Listener());
    }

    @NotNull
    public final Request getReq() {
        return this.req;
    }

    public void send(@NotNull WsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean messageSent = switch (WhenMappings.$EnumSwitchMapping$0[message.getMode().ordinal()]) {
            case 1 -> this.ws.send(ByteString.Companion.of(message.getBody().getPayload()));
            case 2 -> this.ws.send(message.getBody().toString());
            default -> throw new NoWhenBranchMatchedException();
        };
        if (!messageSent) {
            boolean bl = false;
            String string = "Connection to " + this.req.getUri() + " is closed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public void close(@NotNull WsStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.ws.close(status.getCode(), status.getDescription());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/http4k/client/OkHttpNonBlockingWebsocket$Listener;", "Lokhttp3/WebSocketListener;", "<init>", "(Lorg/http4k/client/OkHttpNonBlockingWebsocket;)V", "onOpen", "", "webSocket", "Lokhttp3/WebSocket;", "response", "Lokhttp3/Response;", "onClosed", "code", "", "reason", "", "onClosing", "onFailure", "t", "", "onMessage", "text", "bytes", "Lokio/ByteString;", "http4k-client-okhttp"})
    public final class Listener
    extends WebSocketListener {
        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            OkHttpNonBlockingWebsocket.this.onConnect.invoke((Object)OkHttpNonBlockingWebsocket.this);
        }

        public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            OkHttpNonBlockingWebsocket.this.triggerClose(new WsStatus(code, reason));
        }

        public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            webSocket.close(code, reason);
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            OkHttpNonBlockingWebsocket.this.triggerError(t);
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            OkHttpNonBlockingWebsocket.this.triggerMessage(new WsMessage(text, null, 2, null));
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
            Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            OkHttpNonBlockingWebsocket.this.triggerMessage(new WsMessage(bytes.toByteArray(), WsMessage.Mode.Binary));
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WsMessage.Mode.values().length];
            try {
                nArray[WsMessage.Mode.Binary.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WsMessage.Mode.Text.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

