/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.client.WebsocketClient;
import org.http4k.client.WebsocketClientKt;
import org.http4k.core.Body;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.StreamBody;
import org.http4k.core.Uri;
import org.http4k.testing.WsClient;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062$\b\u0002\u0010\u0007\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0002`\u000b0\bj\u0002`\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJX\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062$\b\u0002\u0010\u0007\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0002`\u000b0\bj\u0002`\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0018\b\u0002\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014\u00a8\u0006\u0015"}, d2={"Lorg/http4k/client/WebsocketClient;", "", "()V", "blocking", "Lorg/http4k/testing/WsClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "nonBlocking", "Lorg/http4k/websocket/Websocket;", "onConnect", "Lkotlin/Function1;", "", "Lorg/http4k/websocket/WsConsumer;", "http4k-client-websocket"})
public final class WebsocketClient {
    public static final WebsocketClient INSTANCE;

    @NotNull
    public final Websocket nonBlocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Function1<? super Websocket, Unit> onConnect) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull(onConnect, (String)"onConnect");
        AtomicReference<nonBlocking.2> socket = new AtomicReference<nonBlocking.2>();
        WebSocketClient client2 = new WebSocketClient(onConnect, socket, uri, headers, timeout, URI.create(uri.toString()), (Draft)new Draft_6455(), WebsocketClientKt.access$combineToMap(headers), (int)timeout.getSeconds()){
            final /* synthetic */ Function1 $onConnect;
            final /* synthetic */ AtomicReference $socket;
            final /* synthetic */ Uri $uri;
            final /* synthetic */ List $headers;
            final /* synthetic */ Duration $timeout;

            public void onOpen(@Nullable ServerHandshake handshakedata) {
                V v = this.$socket.get();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"socket.get()");
                this.$onConnect.invoke(v);
            }

            public void onClose(int code, @NotNull String reason, boolean remote) {
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                ((PushPullAdaptingWebSocket)this.$socket.get()).triggerClose(new WsStatus(code, reason));
            }

            public void onMessage(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                ((PushPullAdaptingWebSocket)this.$socket.get()).triggerMessage(new WsMessage(message));
            }

            public void onError(@NotNull Exception ex) {
                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                ((PushPullAdaptingWebSocket)this.$socket.get()).triggerError((Throwable)ex);
            }
            {
                this.$onConnect = $captured_local_variable$0;
                this.$socket = $captured_local_variable$1;
                this.$uri = $captured_local_variable$2;
                this.$headers = $captured_local_variable$3;
                this.$timeout = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
        socket.set(new PushPullAdaptingWebSocket(client2, uri, Request.Companion.invoke(Method.GET, uri)){
            final /* synthetic */ nonBlocking.client.1 $client;
            final /* synthetic */ Uri $uri;

            public void send(@NotNull WsMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Body body = message.getBody();
                if (body instanceof StreamBody) {
                    this.$client.send(message.getBody().getPayload());
                } else {
                    this.$client.send(message.bodyString());
                }
            }

            public void close(@NotNull WsStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                this.$client.close(status.getCode(), status.getDescription());
            }
            {
                this.$client = $captured_local_variable$0;
                this.$uri = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        client2.connect();
        Object v = socket.get();
        Intrinsics.checkExpressionValueIsNotNull(v, (String)"socket.get()");
        return (Websocket)v;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Websocket nonBlocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            function1 = nonBlocking.1.INSTANCE;
        }
        return websocketClient.nonBlocking(uri, list, duration, (Function1<? super Websocket, Unit>)function1);
    }

    @NotNull
    public final WsClient blocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        WebSocketClient client2 = new WebSocketClient(queue, uri, headers, timeout, URI.create(uri.toString()), (Draft)new Draft_6455(), WebsocketClientKt.access$combineToMap(headers), (int)timeout.getSeconds()){
            final /* synthetic */ LinkedBlockingQueue $queue;
            final /* synthetic */ Uri $uri;
            final /* synthetic */ List $headers;
            final /* synthetic */ Duration $timeout;

            public void onOpen(@NotNull ServerHandshake sh) {
                Intrinsics.checkParameterIsNotNull((Object)sh, (String)"sh");
            }

            public void onClose(int code, @Nullable String reason, boolean remote) {
                this.$queue.add(blocking.client.onClose.1.INSTANCE);
            }

            public void onMessage(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$queue.add(new Function0<WsMessage>(message){
                    final /* synthetic */ String $message;

                    @NotNull
                    public final WsMessage invoke() {
                        return new WsMessage(this.$message);
                    }
                    {
                        this.$message = string;
                        super(0);
                    }
                });
            }

            public void onMessage(@NotNull ByteBuffer bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                this.$queue.add(new Function0<WsMessage>(bytes){
                    final /* synthetic */ ByteBuffer $bytes;

                    @NotNull
                    public final WsMessage invoke() {
                        WsMessage wsMessage;
                        byte[] byArray = this.$bytes.array();
                        Body.Companion companion = Body.Companion;
                        WsMessage wsMessage2 = wsMessage;
                        WsMessage wsMessage3 = wsMessage;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        wsMessage2(Body.Companion.invoke$default((Body.Companion)companion, (InputStream)byteArrayInputStream, null, (int)2, null));
                        return wsMessage3;
                    }
                    {
                        this.$bytes = byteBuffer;
                        super(0);
                    }
                });
            }

            public void onError(@NotNull Exception ex) {
                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                throw (Throwable)ex;
            }
            {
                this.$queue = $captured_local_variable$0;
                this.$uri = $captured_local_variable$1;
                this.$headers = $captured_local_variable$2;
                this.$timeout = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
        client2.connectBlocking();
        return new WsClient(queue, client2){
            final /* synthetic */ LinkedBlockingQueue $queue;
            final /* synthetic */ blocking.client.1 $client;

            @NotNull
            public Sequence<WsMessage> received() {
                return SequencesKt.generateSequence((Function0)((Function0)new Function0<WsMessage>(this){
                    final /* synthetic */ blocking.1 this$0;

                    @Nullable
                    public final WsMessage invoke() {
                        return (WsMessage)((Function0)this.this$0.$queue.take()).invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }

            public void close(@NotNull WsStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                this.$client.close(status.getCode(), status.getDescription());
            }

            public void send(@NotNull WsMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Body body = message.getBody();
                if (body instanceof StreamBody) {
                    this.$client.send(message.getBody().getPayload());
                } else {
                    this.$client.send(message.bodyString());
                }
            }
            {
                this.$queue = $captured_local_variable$0;
                this.$client = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WsClient blocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        return websocketClient.blocking(uri, list, duration);
    }

    private WebsocketClient() {
        INSTANCE = this;
    }

    static {
        new WebsocketClient();
    }
}

