/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.client.WebsocketClientKt;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\u000f2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/http4k/client/NonBlockingClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "onConnect", "Lkotlin/Function1;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "socket", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/atomic/AtomicReference;)V", "onClose", "code", "", "reason", "remote", "", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMessage", "message", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "http4k-client-websocket"})
final class NonBlockingClient
extends WebSocketClient {
    private final Function1<Websocket, Unit> onConnect;
    private final AtomicReference<PushPullAdaptingWebSocket> socket;

    public void onOpen(@Nullable ServerHandshake handshakedata) {
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.socket.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)pushPullAdaptingWebSocket, (String)"socket.get()");
        this.onConnect.invoke((Object)pushPullAdaptingWebSocket);
    }

    public void onClose(int code, @NotNull String reason, boolean remote) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        this.socket.get().triggerClose(new WsStatus(code, reason));
    }

    public void onMessage(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.socket.get().triggerMessage(new WsMessage(message));
    }

    public void onError(@NotNull Exception e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.socket.get().triggerError((Throwable)e);
    }

    public NonBlockingClient(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Function1<? super Websocket, Unit> onConnect, @NotNull AtomicReference<PushPullAdaptingWebSocket> socket) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull(headers, (String)"headers");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull(onConnect, (String)"onConnect");
        Intrinsics.checkParameterIsNotNull(socket, (String)"socket");
        super(URI.create(uri.toString()), (Draft)new Draft_6455(), WebsocketClientKt.access$combineToMap(headers), (int)timeout.toMillis());
        this.onConnect = onConnect;
        this.socket = socket;
    }
}

