/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.client.WebsocketClient;
import org.http4k.core.Body;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.StreamBody;
import org.http4k.core.Uri;
import org.http4k.testing.WsClient;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lorg/http4k/client/WebsocketClient;", "", "()V", "blocking", "Lorg/http4k/testing/WsClient;", "uri", "Lorg/http4k/core/Uri;", "nonBlocking", "Lorg/http4k/websocket/Websocket;", "http4k-client-websocket"})
public final class WebsocketClient {
    public static final WebsocketClient INSTANCE;

    @NotNull
    public final Websocket nonBlocking(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        AtomicReference<nonBlocking.1> socket = new AtomicReference<nonBlocking.1>();
        WebSocketClient client2 = new WebSocketClient(socket, uri, URI.create(uri.toString())){
            final /* synthetic */ AtomicReference $socket;
            final /* synthetic */ Uri $uri;

            public void onOpen(@Nullable ServerHandshake handshakedata) {
            }

            public void onClose(int code, @NotNull String reason, boolean remote) {
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                ((PushPullAdaptingWebSocket)this.$socket.get()).triggerClose(new WsStatus(code, reason));
            }

            public void onMessage(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                ((PushPullAdaptingWebSocket)this.$socket.get()).triggerMessage(new WsMessage(message));
            }

            public void onError(@NotNull Exception ex) {
                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                ((PushPullAdaptingWebSocket)this.$socket.get()).triggerError((Throwable)ex);
            }
            {
                this.$socket = $captured_local_variable$0;
                this.$uri = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        socket.set(new PushPullAdaptingWebSocket(client2, uri, Request.Companion.invoke(Method.GET, uri)){
            final /* synthetic */ nonBlocking.client.1 $client;
            final /* synthetic */ Uri $uri;

            public void send(@NotNull WsMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Body body = message.getBody();
                if (body instanceof StreamBody) {
                    this.$client.send(message.getBody().getPayload());
                } else {
                    this.$client.send(message.bodyString());
                }
            }

            public void close(@NotNull WsStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                this.$client.close(status.getCode(), status.getDescription());
            }
            {
                this.$client = $captured_local_variable$0;
                this.$uri = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        client2.connect();
        Object v = socket.get();
        Intrinsics.checkExpressionValueIsNotNull(v, (String)"socket.get()");
        return (Websocket)v;
    }

    @NotNull
    public final WsClient blocking(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        WebSocketClient client2 = new WebSocketClient(queue, uri, URI.create(uri.toString())){
            final /* synthetic */ LinkedBlockingQueue $queue;
            final /* synthetic */ Uri $uri;

            public void onOpen(@NotNull ServerHandshake handshakedata) {
                Intrinsics.checkParameterIsNotNull((Object)handshakedata, (String)"handshakedata");
            }

            public void onClose(int code, @Nullable String reason, boolean remote) {
                this.$queue.add(blocking.client.onClose.1.INSTANCE);
            }

            public void onMessage(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$queue.add(new Function0<WsMessage>(message){
                    final /* synthetic */ String $message;

                    @NotNull
                    public final WsMessage invoke() {
                        return new WsMessage(this.$message);
                    }
                    {
                        this.$message = string;
                        super(0);
                    }
                });
            }

            public void onMessage(@NotNull ByteBuffer bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                this.$queue.add(new Function0<WsMessage>(bytes){
                    final /* synthetic */ ByteBuffer $bytes;

                    @NotNull
                    public final WsMessage invoke() {
                        WsMessage wsMessage;
                        byte[] byArray = this.$bytes.array();
                        Body.Companion companion = Body.Companion;
                        WsMessage wsMessage2 = wsMessage;
                        WsMessage wsMessage3 = wsMessage;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        wsMessage2(Body.Companion.invoke$default((Body.Companion)companion, (InputStream)byteArrayInputStream, null, (int)2, null));
                        return wsMessage3;
                    }
                    {
                        this.$bytes = byteBuffer;
                        super(0);
                    }
                });
            }

            public void onError(@NotNull Exception ex) {
                Intrinsics.checkParameterIsNotNull((Object)ex, (String)"ex");
                throw (Throwable)ex;
            }
            {
                this.$queue = $captured_local_variable$0;
                this.$uri = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        client2.connectBlocking();
        return new WsClient(queue, client2){
            final /* synthetic */ LinkedBlockingQueue $queue;
            final /* synthetic */ blocking.client.1 $client;

            @NotNull
            public Sequence<WsMessage> received() {
                return SequencesKt.generateSequence((Function0)((Function0)new Function0<WsMessage>(this){
                    final /* synthetic */ blocking.1 this$0;

                    @Nullable
                    public final WsMessage invoke() {
                        return (WsMessage)((Function0)this.this$0.$queue.take()).invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }

            public void close(@NotNull WsStatus status) {
                Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                this.$client.close(status.getCode(), status.getDescription());
            }

            public void send(@NotNull WsMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Body body = message.getBody();
                if (body instanceof StreamBody) {
                    this.$client.send(message.getBody().getPayload());
                } else {
                    this.$client.send(message.bodyString());
                }
            }
            {
                this.$queue = $captured_local_variable$0;
                this.$client = $captured_local_variable$1;
            }
        };
    }

    private WebsocketClient() {
        INSTANCE = this;
    }

    static {
        new WebsocketClient();
    }
}

