/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.client.WebsocketClient;
import org.http4k.client.internal.AdaptingWebSocket;
import org.http4k.client.internal.BlockingQueueClient;
import org.http4k.client.internal.BlockingWsClient;
import org.http4k.client.internal.NonBlockingClient;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062$\b\u0002\u0010\u0007\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0002`\u000b0\bj\u0002`\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012Jx\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062$\b\u0002\u0010\u0007\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0002`\u000b0\bj\u0002`\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0018\b\u0002\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00180\u0016j\u0002`\u001a\u00a8\u0006\u001b"}, d2={"Lorg/http4k/client/WebsocketClient;", "", "()V", "blocking", "Lorg/http4k/websocket/WsClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "autoReconnection", "", "draft", "Lorg/java_websocket/drafts/Draft;", "nonBlocking", "Lorg/http4k/websocket/Websocket;", "onError", "Lkotlin/Function1;", "", "", "onConnect", "Lorg/http4k/websocket/WsConsumer;", "http4k-client-websocket"})
public final class WebsocketClient {
    @NotNull
    public static final WebsocketClient INSTANCE = new WebsocketClient();

    private WebsocketClient() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Websocket nonBlocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Function1<? super Throwable, Unit> onError, @NotNull Draft draft, @NotNull Function1<? super Websocket, Unit> onConnect) {
        void $this$nonBlocking_u24lambda_u240;
        AdaptingWebSocket adaptingWebSocket;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
        AtomicReference<PushPullAdaptingWebSocket> socket = new AtomicReference<PushPullAdaptingWebSocket>();
        NonBlockingClient client = new NonBlockingClient(uri, headers, timeout, onConnect, draft, socket);
        AdaptingWebSocket adaptingWebSocket2 = adaptingWebSocket = new AdaptingWebSocket(uri, client);
        AtomicReference<PushPullAdaptingWebSocket> atomicReference = socket;
        boolean bl = false;
        $this$nonBlocking_u24lambda_u240.onError(onError);
        atomicReference.set(adaptingWebSocket);
        client.connect();
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = socket.get();
        Intrinsics.checkNotNullExpressionValue((Object)pushPullAdaptingWebSocket, (String)"socket.get()");
        return (Websocket)pushPullAdaptingWebSocket;
    }

    public static /* synthetic */ Websocket nonBlocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, Function1 function1, Draft draft, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            function1 = nonBlocking.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            draft = (Draft)new Draft_6455();
        }
        if ((n & 0x20) != 0) {
            function12 = nonBlocking.2.INSTANCE;
        }
        return websocketClient.nonBlocking(uri, list, duration, (Function1<? super Throwable, Unit>)function1, draft, (Function1<? super Websocket, Unit>)function12);
    }

    @NotNull
    public final WsClient blocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, boolean autoReconnection, @NotNull Draft draft) {
        BlockingQueueClient blockingQueueClient;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        LinkedBlockingQueue<Function0<WsMessage>> queue = new LinkedBlockingQueue<Function0<WsMessage>>();
        BlockingQueueClient $this$blocking_u24lambda_u241 = blockingQueueClient = new BlockingQueueClient(uri, headers, timeout, draft, queue);
        boolean bl = false;
        if (!$this$blocking_u24lambda_u241.connectBlocking(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new WebsocketNotConnectedException();
        }
        BlockingQueueClient client = blockingQueueClient;
        return new BlockingWsClient(queue, client, autoReconnection);
    }

    public static /* synthetic */ WsClient blocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, boolean bl, Draft draft, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.of(5L, ChronoUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"of(5, SECONDS)");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            draft = (Draft)new Draft_6455();
        }
        return websocketClient.blocking(uri, list, duration, bl, draft);
    }
}

