/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.client.internal.AdaptingWebSocket;
import org.http4k.client.internal.BlockingQueueClient;
import org.http4k.client.internal.BlockingWsClient;
import org.http4k.client.internal.NonBlockingClient;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jy\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072 \b\u0002\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\nj\u0002`\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u0018\b\u0002\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u0016\u00a2\u0006\u0002\u0010\u0017JS\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072 \b\u0002\u0010\b\u001a\u001a\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\nj\u0002`\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/http4k/client/WebsocketClient;", "", "<init>", "()V", "nonBlocking", "Lorg/http4k/websocket/Websocket;", "uri", "Lorg/http4k/core/Uri;", "headers", "Lorg/http4k/core/Headers;", "", "Lkotlin/Pair;", "", "timeout", "Ljava/time/Duration;", "onError", "Lkotlin/Function1;", "", "", "draft", "Lorg/java_websocket/drafts/Draft;", "onConnect", "Lorg/http4k/websocket/WsConsumer;", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lkotlin/jvm/functions/Function1;Lorg/java_websocket/drafts/Draft;Lkotlin/jvm/functions/Function1;)Lorg/http4k/websocket/Websocket;", "blocking", "Lorg/http4k/websocket/WsClient;", "autoReconnection", "", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;ZLorg/java_websocket/drafts/Draft;)Lorg/http4k/websocket/WsClient;", "http4k-client-websocket"})
@SourceDebugExtension(value={"SMAP\nWebsocketClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebsocketClient.kt\norg/http4k/client/WebsocketClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class WebsocketClient {
    @NotNull
    public static final WebsocketClient INSTANCE = new WebsocketClient();

    private WebsocketClient() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Websocket nonBlocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Function1<? super Throwable, Unit> onError, @NotNull Draft draft, @NotNull Function1<? super Websocket, Unit> onConnect) {
        void $this$nonBlocking_u24lambda_u242;
        AdaptingWebSocket adaptingWebSocket;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
        AtomicReference<PushPullAdaptingWebSocket> socket = new AtomicReference<PushPullAdaptingWebSocket>();
        NonBlockingClient client = new NonBlockingClient(uri, headers, timeout, onConnect, draft, socket);
        AdaptingWebSocket adaptingWebSocket2 = adaptingWebSocket = new AdaptingWebSocket(client);
        AtomicReference<PushPullAdaptingWebSocket> atomicReference = socket;
        boolean bl = false;
        $this$nonBlocking_u24lambda_u242.onError(onError);
        atomicReference.set(adaptingWebSocket);
        client.connect();
        PushPullAdaptingWebSocket pushPullAdaptingWebSocket = socket.get();
        Intrinsics.checkNotNullExpressionValue((Object)pushPullAdaptingWebSocket, (String)"get(...)");
        return (Websocket)pushPullAdaptingWebSocket;
    }

    public static /* synthetic */ Websocket nonBlocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, Function1 function1, Draft draft, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            duration = Duration.ZERO;
        }
        if ((n & 8) != 0) {
            function1 = WebsocketClient::nonBlocking$lambda$0;
        }
        if ((n & 0x10) != 0) {
            draft = (Draft)new Draft_6455();
        }
        if ((n & 0x20) != 0) {
            function12 = WebsocketClient::nonBlocking$lambda$1;
        }
        return websocketClient.nonBlocking(uri, list, duration, (Function1<? super Throwable, Unit>)function1, draft, (Function1<? super Websocket, Unit>)function12);
    }

    @NotNull
    public final WsClient blocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, boolean autoReconnection, @NotNull Draft draft) {
        BlockingQueueClient blockingQueueClient;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        LinkedBlockingQueue<Function0<WsMessage>> queue = new LinkedBlockingQueue<Function0<WsMessage>>();
        BlockingQueueClient $this$blocking_u24lambda_u243 = blockingQueueClient = new BlockingQueueClient(uri, headers, timeout, draft, queue);
        boolean bl = false;
        if (!$this$blocking_u24lambda_u243.connectBlocking(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new WebsocketNotConnectedException();
        }
        BlockingQueueClient client = blockingQueueClient;
        return new BlockingWsClient(queue, client, autoReconnection);
    }

    public static /* synthetic */ WsClient blocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, boolean bl, Draft draft, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            duration = Duration.of(5L, ChronoUnit.SECONDS);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            draft = (Draft)new Draft_6455();
        }
        return websocketClient.blocking(uri, list, duration, bl, draft);
    }

    private static final Unit nonBlocking$lambda$0(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit nonBlocking$lambda$1(Websocket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

