/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client.internal;

import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.client.internal.BlockingQueueClient;
import org.http4k.core.StreamBody;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/http4k/client/internal/BlockingWsClient;", "Lorg/http4k/websocket/WsClient;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "Lorg/http4k/websocket/WsMessage;", "client", "Lorg/http4k/client/internal/BlockingQueueClient;", "autoReconnection", "", "<init>", "(Ljava/util/concurrent/LinkedBlockingQueue;Lorg/http4k/client/internal/BlockingQueueClient;Z)V", "received", "Lkotlin/sequences/Sequence;", "close", "", "status", "Lorg/http4k/websocket/WsStatus;", "send", "message", "http4k-client-websocket"})
public final class BlockingWsClient
implements WsClient {
    @NotNull
    private final LinkedBlockingQueue<Function0<WsMessage>> queue;
    @NotNull
    private final BlockingQueueClient client;
    private final boolean autoReconnection;

    public BlockingWsClient(@NotNull LinkedBlockingQueue<Function0<WsMessage>> queue, @NotNull BlockingQueueClient client, boolean autoReconnection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        this.queue = queue;
        this.client = client;
        this.autoReconnection = autoReconnection;
    }

    @NotNull
    public Sequence<WsMessage> received() {
        return SequencesKt.generateSequence(() -> BlockingWsClient.received$lambda$0(this));
    }

    public void close(@NotNull WsStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.client.close(status.getCode(), status.getDescription());
    }

    public void send(@NotNull WsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.autoReconnection && (this.client.isClosing() || this.client.isClosed())) {
            this.client.closeBlocking();
            this.client.reconnectBlocking();
        }
        if (message.getBody() instanceof StreamBody) {
            this.client.send(message.getBody().getPayload());
        } else {
            this.client.send(message.bodyString());
        }
    }

    private static final WsMessage received$lambda$0(BlockingWsClient this$0) {
        return (WsMessage)this$0.queue.take().invoke();
    }
}

