/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.client.internal.BlockingQueueClient;
import org.http4k.client.internal.InternalKt;
import org.http4k.core.Body;
import org.http4k.core.Uri;
import org.http4k.websocket.WsMessage;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\"\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0014\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00100\u000f\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u00020\u00142\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/http4k/client/internal/BlockingQueueClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "draft", "Lorg/java_websocket/drafts/Draft;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "Lorg/http4k/websocket/WsMessage;", "(Lorg/http4k/core/Uri;Ljava/util/List;Ljava/time/Duration;Lorg/java_websocket/drafts/Draft;Ljava/util/concurrent/LinkedBlockingQueue;)V", "onClose", "", "code", "", "reason", "remote", "", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMessage", "bytes", "Ljava/nio/ByteBuffer;", "message", "onOpen", "sh", "Lorg/java_websocket/handshake/ServerHandshake;", "http4k-client-websocket"})
public final class BlockingQueueClient
extends WebSocketClient {
    @NotNull
    private final LinkedBlockingQueue<Function0<WsMessage>> queue;

    public BlockingQueueClient(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Draft draft, @NotNull LinkedBlockingQueue<Function0<WsMessage>> queue) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        super(URI.create(uri.toString()), draft, InternalKt.access$combineToMap(headers), (int)timeout.toMillis());
        this.queue = queue;
    }

    public void onOpen(@NotNull ServerHandshake sh) {
        Intrinsics.checkNotNullParameter((Object)sh, (String)"sh");
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        ((Collection)this.queue).add(onClose.1.INSTANCE);
    }

    public void onMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ((Collection)this.queue).add(new Function0<WsMessage>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final WsMessage invoke() {
                return new WsMessage(this.$message);
            }
        });
    }

    public void onMessage(@NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        ((Collection)this.queue).add(new Function0<WsMessage>(bytes){
            final /* synthetic */ ByteBuffer $bytes;
            {
                this.$bytes = $bytes;
                super(0);
            }

            @NotNull
            public final WsMessage invoke() {
                byte[] byArray = this.$bytes.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                byte[] byArray2 = byArray;
                return new WsMessage(Body.Companion.create$default((Body.Companion)Body.Companion, (InputStream)new ByteArrayInputStream(byArray2), null, (int)2, null));
            }
        });
    }

    public void onError(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        throw e;
    }
}

