/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.client.internal.AdaptingWebSocket;
import org.http4k.client.internal.BlockingQueueClient;
import org.http4k.client.internal.InternalKt;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WebsocketFactory;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0086\u0002Jx\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2$\b\u0002\u0010\u0010\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012j\u0002`\u00140\u0011j\u0002`\u00152\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0018\b\u0002\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001bJR\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2$\b\u0002\u0010\u0010\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012j\u0002`\u00140\u0011j\u0002`\u00152\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\u001e"}, d2={"Lorg/http4k/client/WebsocketClient;", "", "<init>", "()V", "invoke", "Lorg/http4k/websocket/WebsocketFactory;", "timeout", "Ljava/time/Duration;", "autoReconnection", "", "draft", "Lorg/java_websocket/drafts/Draft;", "nonBlocking", "Lorg/http4k/websocket/Websocket;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "onError", "Lkotlin/Function1;", "", "", "onConnect", "Lorg/http4k/websocket/WsConsumer;", "blocking", "Lorg/http4k/websocket/WsClient;", "http4k-client-websocket"})
public final class WebsocketClient {
    @NotNull
    public static final WebsocketClient INSTANCE = new WebsocketClient();

    private WebsocketClient() {
    }

    @NotNull
    public final WebsocketFactory invoke(@NotNull Duration timeout, boolean autoReconnection, @NotNull Draft draft) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        return new WebsocketFactory(timeout, draft, autoReconnection){
            final /* synthetic */ Duration $timeout;
            final /* synthetic */ Draft $draft;
            final /* synthetic */ boolean $autoReconnection;
            {
                this.$timeout = $timeout;
                this.$draft = $draft;
                this.$autoReconnection = $autoReconnection;
            }

            /*
             * WARNING - void declaration
             */
            public Websocket nonBlocking(Uri uri, List<Pair<String, String>> headers, Function1<? super Throwable, Unit> onError, Function1<? super Websocket, Unit> onConnect) {
                void $this$nonBlocking_u24lambda_u240;
                AdaptingWebSocket adaptingWebSocket;
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                Intrinsics.checkNotNullParameter(onError, (String)"onError");
                Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
                AtomicReference<PushPullAdaptingWebSocket> socket = new AtomicReference<PushPullAdaptingWebSocket>();
                WebSocketClient client = InternalKt.nonBlockingClient(uri, headers, this.$timeout, onConnect, this.$draft, socket);
                AdaptingWebSocket adaptingWebSocket2 = adaptingWebSocket = new AdaptingWebSocket(client, this.$autoReconnection);
                AtomicReference<PushPullAdaptingWebSocket> atomicReference = socket;
                boolean bl = false;
                $this$nonBlocking_u24lambda_u240.onError(onError);
                atomicReference.set(adaptingWebSocket);
                client.connect();
                PushPullAdaptingWebSocket pushPullAdaptingWebSocket = socket.get();
                Intrinsics.checkNotNullExpressionValue((Object)pushPullAdaptingWebSocket, (String)"get(...)");
                return (Websocket)pushPullAdaptingWebSocket;
            }

            public WsClient blocking(Uri uri, List<Pair<String, String>> headers) {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                LinkedBlockingQueue<Function0<WsMessage>> queue = new LinkedBlockingQueue<Function0<WsMessage>>();
                BlockingQueueClient blockingQueueClient = new BlockingQueueClient(uri, headers, this.$timeout, this.$draft, queue);
                Duration duration = this.$timeout;
                BlockingQueueClient $this$blocking_u24lambda_u241 = blockingQueueClient;
                boolean bl = false;
                if (!$this$blocking_u24lambda_u241.connectBlocking(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                    throw new WebsocketNotConnectedException();
                }
                BlockingQueueClient client = blockingQueueClient;
                return InternalKt.blockingWsClient(queue, client, this.$autoReconnection);
            }
        };
    }

    public static /* synthetic */ WebsocketFactory invoke$default(WebsocketClient websocketClient, Duration duration, boolean bl, Draft draft, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            draft = (Draft)new Draft_6455();
        }
        return websocketClient.invoke(duration, bl, draft);
    }

    @NotNull
    public final Websocket nonBlocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Function1<? super Throwable, Unit> onError, @NotNull Draft draft, @NotNull Function1<? super Websocket, Unit> onConnect) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
        return INSTANCE.invoke(timeout, false, draft).nonBlocking(uri, headers, onError, onConnect);
    }

    public static /* synthetic */ Websocket nonBlocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, Function1 function1, Draft draft, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            function1 = WebsocketClient::nonBlocking$lambda$0;
        }
        if ((n & 0x10) != 0) {
            draft = (Draft)new Draft_6455();
        }
        if ((n & 0x20) != 0) {
            function12 = WebsocketClient::nonBlocking$lambda$1;
        }
        return websocketClient.nonBlocking(uri, list, duration, (Function1<? super Throwable, Unit>)function1, draft, (Function1<? super Websocket, Unit>)function12);
    }

    @NotNull
    public final WsClient blocking(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, boolean autoReconnection, @NotNull Draft draft) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        return INSTANCE.invoke(timeout, autoReconnection, draft).blocking(uri, headers);
    }

    public static /* synthetic */ WsClient blocking$default(WebsocketClient websocketClient, Uri uri, List list, Duration duration, boolean bl, Draft draft, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            draft = (Draft)new Draft_6455();
        }
        return websocketClient.blocking(uri, list, duration, bl, draft);
    }

    private static final Unit nonBlocking$lambda$0(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit nonBlocking$lambda$1(Websocket it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

