/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.client.internal;

import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.client.internal.BlockingQueueClient;
import org.http4k.client.internal.InternalKt;
import org.http4k.core.Uri;
import org.http4k.websocket.PushPullAdaptingWebSocket;
import org.http4k.websocket.Websocket;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.http4k.websocket.WsStatus;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\u001aj\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\"\u0010\u0004\u001a\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u001a.\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a0\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u001a4\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070!*\u001e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\b0\u0005j\u0002`\tH\u0002\u00a8\u0006\""}, d2={"nonBlockingClient", "Lorg/java_websocket/client/WebSocketClient;", "uri", "Lorg/http4k/core/Uri;", "headers", "", "Lkotlin/Pair;", "", "Lorg/http4k/core/Parameter;", "Lorg/http4k/core/Headers;", "timeout", "Ljava/time/Duration;", "onConnect", "Lkotlin/Function1;", "Lorg/http4k/websocket/Websocket;", "", "Lorg/http4k/websocket/WsConsumer;", "draft", "Lorg/java_websocket/drafts/Draft;", "socket", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/http4k/websocket/PushPullAdaptingWebSocket;", "blockingWsClient", "Lorg/http4k/websocket/WsClient;", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "Lorg/http4k/websocket/WsMessage;", "client", "Lorg/http4k/client/internal/BlockingQueueClient;", "autoReconnection", "", "combineToMap", "", "http4k-client-websocket"})
@SourceDebugExtension(value={"SMAP\ninternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 internal.kt\norg/http4k/client/internal/InternalKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,103:1\n1491#2:104\n1516#2,3:105\n1519#2,3:115\n1252#2,2:120\n1563#2:122\n1634#2,3:123\n1255#2:126\n384#3,7:108\n465#3:118\n415#3:119\n*S KotlinDebug\n*F\n+ 1 internal.kt\norg/http4k/client/internal/InternalKt\n*L\n102#1:104\n102#1:105,3\n102#1:115,3\n102#1:120,2\n102#1:122\n102#1:123,3\n102#1:126\n102#1:108,7\n102#1:118\n102#1:119\n*E\n"})
public final class InternalKt {
    @NotNull
    public static final WebSocketClient nonBlockingClient(@NotNull Uri uri, @NotNull List<Pair<String, String>> headers, @NotNull Duration timeout, @NotNull Function1<? super Websocket, Unit> onConnect, @NotNull Draft draft, @NotNull AtomicReference<PushPullAdaptingWebSocket> socket) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(onConnect, (String)"onConnect");
        Intrinsics.checkNotNullParameter((Object)draft, (String)"draft");
        Intrinsics.checkNotNullParameter(socket, (String)"socket");
        URI uRI = URI.create(uri.toString());
        Map<String, String> map = InternalKt.combineToMap(headers);
        int n = (int)timeout.toMillis();
        return new WebSocketClient(draft, onConnect, socket, uRI, map, n){
            final /* synthetic */ Function1<Websocket, Unit> $onConnect;
            final /* synthetic */ AtomicReference<PushPullAdaptingWebSocket> $socket;
            {
                this.$onConnect = $onConnect;
                this.$socket = $socket;
                super($super_call_param$1, $draft, $super_call_param$2, $super_call_param$3);
            }

            public void onOpen(ServerHandshake handshakedata) {
                PushPullAdaptingWebSocket pushPullAdaptingWebSocket = this.$socket.get();
                Intrinsics.checkNotNullExpressionValue((Object)pushPullAdaptingWebSocket, (String)"get(...)");
                this.$onConnect.invoke((Object)pushPullAdaptingWebSocket);
            }

            public void onClose(int code, String reason, boolean remote) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.$socket.get().triggerClose(new WsStatus(code, reason));
            }

            public void onMessage(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$socket.get().triggerMessage(new WsMessage(message, null, 2, null));
            }

            public void onMessage(ByteBuffer bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                this.$socket.get().triggerMessage(new WsMessage(bytes, null, 2, null));
            }

            public void onError(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$socket.get().triggerError((Throwable)e);
            }
        };
    }

    @NotNull
    public static final WsClient blockingWsClient(@NotNull LinkedBlockingQueue<Function0<WsMessage>> queue, @NotNull BlockingQueueClient client, boolean autoReconnection) {
        Intrinsics.checkNotNullParameter(queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)((Object)client), (String)"client");
        return new WsClient(queue, client, autoReconnection){
            final /* synthetic */ LinkedBlockingQueue<Function0<WsMessage>> $queue;
            final /* synthetic */ BlockingQueueClient $client;
            final /* synthetic */ boolean $autoReconnection;
            {
                this.$queue = $queue;
                this.$client = $client;
                this.$autoReconnection = $autoReconnection;
            }

            public Sequence<WsMessage> received() {
                return SequencesKt.generateSequence(() -> blockingWsClient.1.received$lambda$0(this.$queue));
            }

            public void close(WsStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$client.close(status.getCode(), status.getDescription());
            }

            public void send(WsMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (this.$autoReconnection && (this.$client.isClosing() || this.$client.isClosed())) {
                    this.$client.closeBlocking();
                    this.$client.reconnectBlocking();
                }
                switch (blockingWsClient.WhenMappings.$EnumSwitchMapping$0[message.getMode().ordinal()]) {
                    case 1: {
                        this.$client.send(message.getBody().getPayload());
                        break;
                    }
                    case 2: {
                        this.$client.send(message.bodyString());
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            private static final WsMessage received$lambda$0(LinkedBlockingQueue $queue) {
                return (WsMessage)((Function0)$queue.take()).invoke();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, String> combineToMap(List<Pair<String, String>> $this$combineToMap) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$combineToMap;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = (String)it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it.getValue();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add((String)it2.getSecond());
            }
            String string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            map2.put(k, string);
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ Map access$combineToMap(List $receiver) {
        return InternalKt.combineToMap($receiver);
    }
}

