package org.http4k.connect.azure

import dev.forkhandles.result4k.Result
import java.lang.Integer
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlin.sequences.Sequence
import org.http4k.connect.RemoteFailure
import org.http4k.connect.azure.action.ChatCompletion
import org.http4k.connect.azure.action.Completion
import org.http4k.connect.azure.action.CompletionResponse
import org.http4k.connect.azure.action.CreateEmbeddings
import org.http4k.connect.azure.action.Embeddings
import org.http4k.connect.azure.action.GetInfo
import org.http4k.connect.azure.action.Message
import org.http4k.connect.azure.action.ModelInfo
import org.http4k.connect.azure.action.ResponseFormat
import org.http4k.connect.azure.action.Tool
import org.http4k.connect.model.ModelName

/**
 * @see org.http4k.connect.azure.action.ChatCompletion
 */
public fun AzureAI.chatCompletion(
  model: ModelName,
  messages: List<Message>,
  max_tokens: Int? = null,
  temperature: Double,
  top_p: Double,
  seed: Int,
  stop: Any? = null,
  presence_penalty: Double,
  frequency_penalty: Double,
  user: User? = null,
  stream: Boolean,
  response_format: ResponseFormat? = null,
  tools: List<Tool>? = null,
  tool_choice: Any? = null,
  n: Integer? = null,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, messages,
    max_tokens, temperature, top_p, seed, stop, presence_penalty, frequency_penalty, user, stream,
    response_format, tools, tool_choice, n))

/**
 * @see org.http4k.connect.azure.action.ChatCompletion
 */
public fun AzureAI.chatCompletion(
  model: ModelName,
  messages: List<Message>,
  max_tokens: Int,
  stream: Boolean,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, messages,
    max_tokens, stream))

/**
 * @see org.http4k.connect.azure.action.Completion
 */
public fun AzureAI.completion(
  prompt: Prompt,
  presence_penalty: Double,
  frequency_penalty: Double,
  temperature: Double,
  stream: Boolean,
  max_tokens: Int? = null,
  seed: Integer? = null,
  stop: Any? = null,
  n: Integer? = null,
  top_p: Double,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(Completion(prompt, presence_penalty,
    frequency_penalty, temperature, stream, max_tokens, seed, stop, n, top_p))

/**
 * @see org.http4k.connect.azure.action.Completion
 */
public fun AzureAI.completion(
  prompt: Prompt,
  max_tokens: Int,
  stream: Boolean,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(Completion(prompt, max_tokens,
    stream))

/**
 * @see org.http4k.connect.azure.action.CreateEmbeddings
 */
public fun AzureAI.createEmbeddings(model: ModelName, input: List<String>):
    Result<Embeddings, RemoteFailure> = invoke(CreateEmbeddings(model, input))

/**
 * @see org.http4k.connect.azure.action.GetInfo
 */
public fun AzureAI.getInfo(modelName: ModelName? = null): Result<ModelInfo, RemoteFailure> =
    invoke(GetInfo(modelName))
