/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.ollama;

import java.time.Clock;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.chaos.ChaoticHttpHandler;
import org.http4k.connect.model.ModelName;
import org.http4k.connect.ollama.ChatCompletionGenerator;
import org.http4k.connect.ollama.EndpointsKt;
import org.http4k.connect.ollama.HttpOllamaKt;
import org.http4k.connect.ollama.ModelsKt;
import org.http4k.connect.ollama.Ollama;
import org.http4k.connect.ollama.action.Model;
import org.http4k.connect.storage.Storage;
import org.http4k.routing.HttpKt;
import org.http4k.routing.RoutingHttpHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/http4k/connect/ollama/FakeOllama;", "Lorg/http4k/chaos/ChaoticHttpHandler;", "models", "Lorg/http4k/connect/storage/Storage;", "Lorg/http4k/connect/ollama/action/Model;", "completionGenerators", "", "Lorg/http4k/connect/model/ModelName;", "Lorg/http4k/connect/ollama/ChatCompletionGenerator;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/http4k/connect/storage/Storage;Ljava/util/Map;Ljava/time/Clock;)V", "getModels", "()Lorg/http4k/connect/storage/Storage;", "getCompletionGenerators", "()Ljava/util/Map;", "app", "Lorg/http4k/routing/RoutingHttpHandler;", "getApp", "()Lorg/http4k/routing/RoutingHttpHandler;", "client", "Lorg/http4k/connect/ollama/Ollama;", "http4k-connect-ai-ollama-fake"})
public final class FakeOllama
extends ChaoticHttpHandler {
    @NotNull
    private final Storage<Model> models;
    @NotNull
    private final Map<ModelName, ChatCompletionGenerator> completionGenerators;
    @NotNull
    private final RoutingHttpHandler app;

    public FakeOllama(@NotNull Storage<Model> models, @NotNull Map<ModelName, ? extends ChatCompletionGenerator> completionGenerators, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(models, (String)"models");
        Intrinsics.checkNotNullParameter(completionGenerators, (String)"completionGenerators");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.models = models;
        this.completionGenerators = completionGenerators;
        RoutingHttpHandler[] routingHttpHandlerArray = new RoutingHttpHandler[]{EndpointsKt.getModels(this.models), EndpointsKt.completion(clock, this.completionGenerators), EndpointsKt.pullModel(), EndpointsKt.chatCompletion(clock, this.completionGenerators), EndpointsKt.createEmbeddings(this.models)};
        this.app = HttpKt.routes((RoutingHttpHandler[])routingHttpHandlerArray);
    }

    public /* synthetic */ FakeOllama(Storage storage, Map map, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            storage = ModelsKt.getDEFAULT_OLLAMA_MODELS();
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            clock = Clock.systemUTC();
        }
        this(storage, map, clock);
    }

    @NotNull
    public final Storage<Model> getModels() {
        return this.models;
    }

    @NotNull
    public final Map<ModelName, ChatCompletionGenerator> getCompletionGenerators() {
        return this.completionGenerators;
    }

    @NotNull
    protected RoutingHttpHandler getApp() {
        return this.app;
    }

    @NotNull
    public final Ollama client() {
        return HttpOllamaKt.Http((Ollama.Companion)Ollama.Companion, (Function1)((Function1)this));
    }

    public FakeOllama() {
        this(null, null, null, 7, null);
    }
}

