package org.http4k.connect.ollama

import dev.forkhandles.result4k.Result
import kotlin.Boolean
import kotlin.String
import kotlin.collections.List
import kotlin.sequences.Sequence
import org.http4k.ai.model.ModelName
import org.http4k.ai.model.SystemPrompt
import org.http4k.ai.model.UserPrompt
import org.http4k.connect.RemoteFailure
import org.http4k.connect.model.Base64Blob
import org.http4k.connect.ollama.action.ChatCompletion
import org.http4k.connect.ollama.action.ChatCompletionResponse
import org.http4k.connect.ollama.action.Completion
import org.http4k.connect.ollama.action.CompletionResponse
import org.http4k.connect.ollama.action.CreateEmbeddings
import org.http4k.connect.ollama.action.EmbeddingsResponse
import org.http4k.connect.ollama.action.GetModels
import org.http4k.connect.ollama.action.ModelList
import org.http4k.connect.ollama.action.ModelOptions
import org.http4k.connect.ollama.action.PullModel
import org.http4k.connect.ollama.action.PullResponse

/**
 * @see org.http4k.connect.ollama.action.ChatCompletion
 */
public fun Ollama.chatCompletion(
  model: ModelName,
  messages: List<Message>,
  stream: Boolean? = null,
  format: ResponseFormat? = null,
  keep_alive: String? = null,
  options: ModelOptions? = null,
): Result<Sequence<ChatCompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, messages, stream, format, keep_alive, options))

/**
 * @see org.http4k.connect.ollama.action.ChatCompletion
 */
public fun Ollama.chatCompletion(
  model: ModelName,
  messages: Message,
  stream: Boolean? = null,
  format: ResponseFormat? = null,
  keep_alive: String? = null,
  options: ModelOptions? = null,
): Result<Sequence<ChatCompletionResponse>, RemoteFailure> = invoke(ChatCompletion(model, messages, stream, format, keep_alive, options))

/**
 * @see org.http4k.connect.ollama.action.Completion
 */
public fun Ollama.completion(
  model: ModelName,
  prompt: UserPrompt,
  images: List<Base64Blob>? = null,
  stream: Boolean? = null,
  system: SystemPrompt? = null,
  format: ResponseFormat? = null,
  template: Template? = null,
  raw: Boolean? = null,
  keep_alive: String? = null,
  options: ModelOptions? = null,
): Result<Sequence<CompletionResponse>, RemoteFailure> = invoke(Completion(model, prompt, images, stream, system, format, template, raw, keep_alive, options))

/**
 * @see org.http4k.connect.ollama.action.CreateEmbeddings
 */
public fun Ollama.createEmbeddings(
  model: ModelName,
  prompt: UserPrompt,
  keep_alive: String? = null,
  options: ModelOptions? = null,
): Result<EmbeddingsResponse, RemoteFailure> = invoke(CreateEmbeddings(model, prompt, keep_alive, options))

/**
 * @see org.http4k.connect.ollama.action.GetModels
 */
public fun Ollama.getModels(): Result<ModelList, RemoteFailure> = invoke(GetModels)

/**
 * @see org.http4k.connect.ollama.action.PullModel
 */
public fun Ollama.pullModel(name: ModelName, stream: Boolean? = null): Result<Sequence<PullResponse>, RemoteFailure> = invoke(PullModel(name, stream))
