/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.openai.plugins;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.openai.auth.OpenAIPluginId;
import org.http4k.connect.openai.plugins.IntegratedPlugin;
import org.http4k.connect.openai.plugins.OAuthPluginIntegrationKt;
import org.http4k.connect.openai.plugins.PluginIntegration;
import org.http4k.connect.openai.plugins.internal.ForwardCallsToPluginServerKt;
import org.http4k.connect.openai.plugins.internal.LoadPluginOpenApiKt;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.Method;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.filter.ClientFilters;
import org.http4k.routing.RoutingHttpHandler;
import org.http4k.routing.RoutingKt;
import org.http4k.security.AccessToken;
import org.http4k.security.InsecureCookieBasedOAuthPersistence;
import org.http4k.security.OAuthPersistence;
import org.http4k.security.OAuthProvider;
import org.http4k.security.OAuthProviderConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"OAuthPluginIntegration", "Lorg/http4k/connect/openai/plugins/PluginIntegration;", "pluginId", "Lorg/http4k/connect/openai/auth/OpenAIPluginId;", "pluginOAuthConfig", "Lorg/http4k/security/OAuthProviderConfig;", "http4k-connect-ai-openai-fake"})
public final class OAuthPluginIntegrationKt {
    @NotNull
    public static final PluginIntegration OAuthPluginIntegration(@NotNull OpenAIPluginId pluginId, @NotNull OAuthProviderConfig pluginOAuthConfig) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)pluginOAuthConfig, (String)"pluginOAuthConfig");
        return new PluginIntegration(pluginId, pluginOAuthConfig){
            private final OpenAIPluginId pluginId;
            final /* synthetic */ OpenAIPluginId $pluginId;
            final /* synthetic */ OAuthProviderConfig $pluginOAuthConfig;
            {
                this.$pluginId = $pluginId;
                this.$pluginOAuthConfig = $pluginOAuthConfig;
                this.pluginId = $pluginId;
            }

            public OpenAIPluginId getPluginId() {
                return this.pluginId;
            }

            public IntegratedPlugin buildIntegration(Uri openAiUrl, Function1<? super Request, ? extends Response> http, Clock clock) {
                Intrinsics.checkNotNullParameter((Object)openAiUrl, (String)"openAiUrl");
                Intrinsics.checkNotNullParameter(http, (String)"http");
                Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
                String string = this.$pluginOAuthConfig.getApiBase().toString();
                Duration duration = Duration.ofSeconds(60L);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
                InsecureCookieBasedOAuthPersistence oAuthPersistence = new InsecureCookieBasedOAuthPersistence(string, duration, clock);
                OAuthProvider oAuthProvider = new OAuthProvider(this.$pluginOAuthConfig, http, openAiUrl.path("/aip/plugin-" + this.$pluginId + "/oauth/callback"), CollectionsKt.emptyList(), (OAuthPersistence)oAuthPersistence, null, null, null, null, null, null, null, null, null, null, null, 65504, null);
                RoutingHttpHandler[] routingHttpHandlerArray = new RoutingHttpHandler[]{RoutingKt.bind((String)("/aip/plugin-" + this.$pluginId + "/oauth/callback"), (Method)Method.GET).to((Function1)oAuthProvider.getCallback()), LoadPluginOpenApiKt.LoadOpenApi(this.$pluginId, openAiUrl, http, oAuthProvider.getProviderConfig().getApiBase()), ForwardCallsToPluginServerKt.ForwardCallsToPluginServer(this.$pluginId, http, oAuthProvider.getProviderConfig().getApiBase(), (Function1<? super Request, ? extends Filter>)((Function1)arg_0 -> OAuthPluginIntegration.1.buildIntegration$lambda$0(oAuthProvider, oAuthPersistence, arg_0)))};
                return new IntegratedPlugin(this.$pluginId, RoutingKt.routes((RoutingHttpHandler[])routingHttpHandlerArray), (Filter)oAuthProvider.getAuthFilter());
            }

            private static final Filter buildIntegration$lambda$0(OAuthProvider $oAuthProvider, InsecureCookieBasedOAuthPersistence $oAuthPersistence, Request it) {
                Intrinsics.checkNotNullParameter((Object)$oAuthProvider, (String)"$oAuthProvider");
                Intrinsics.checkNotNullParameter((Object)$oAuthPersistence, (String)"$oAuthPersistence");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Filter filter = (Filter)$oAuthProvider.getAuthFilter();
                AccessToken accessToken = $oAuthPersistence.retrieveToken(it);
                Intrinsics.checkNotNull((Object)accessToken);
                return Http4kKt.then((Filter)filter, (Filter)ClientFilters.BearerAuth.INSTANCE.invoke(accessToken.getValue()));
            }
        };
    }
}

