/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.core.model;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCredentials;
import org.http4k.connect.amazon.core.model.AccessKeyId;
import org.http4k.connect.amazon.core.model.Expiration;
import org.http4k.connect.amazon.core.model.SecretAccessKey;
import org.http4k.connect.amazon.core.model.SessionToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J\t\u0010#\u001a\u00020\nH\u00c6\u0003J\t\u0010$\u001a\u00020\fH\u00c6\u0003J\t\u0010%\u001a\u00020\u000eH\u00c6\u0003JO\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u00062"}, d2={"Lorg/http4k/connect/amazon/core/model/Ec2Credentials;", "", "Code", "", "LastUpdated", "Ljava/time/ZonedDateTime;", "Type", "AccessKeyId", "Lorg/http4k/connect/amazon/core/model/AccessKeyId;", "SecretAccessKey", "Lorg/http4k/connect/amazon/core/model/SecretAccessKey;", "Token", "Lorg/http4k/connect/amazon/core/model/SessionToken;", "Expiration", "Lorg/http4k/connect/amazon/core/model/Expiration;", "(Ljava/lang/String;Ljava/time/ZonedDateTime;Ljava/lang/String;Lorg/http4k/connect/amazon/core/model/AccessKeyId;Lorg/http4k/connect/amazon/core/model/SecretAccessKey;Lorg/http4k/connect/amazon/core/model/SessionToken;Lorg/http4k/connect/amazon/core/model/Expiration;)V", "getAccessKeyId", "()Lorg/http4k/connect/amazon/core/model/AccessKeyId;", "getCode", "()Ljava/lang/String;", "getExpiration", "()Lorg/http4k/connect/amazon/core/model/Expiration;", "getLastUpdated", "()Ljava/time/ZonedDateTime;", "getSecretAccessKey", "()Lorg/http4k/connect/amazon/core/model/SecretAccessKey;", "getToken", "()Lorg/http4k/connect/amazon/core/model/SessionToken;", "getType", "asHttp4k", "Lorg/http4k/aws/AwsCredentials;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "expiresWithin", "clock", "Ljava/time/Clock;", "duration", "Ljava/time/Duration;", "hashCode", "", "toString", "http4k-connect-amazon-core"})
public final class Ec2Credentials {
    @NotNull
    private final String Code;
    @NotNull
    private final ZonedDateTime LastUpdated;
    @NotNull
    private final String Type;
    @NotNull
    private final AccessKeyId AccessKeyId;
    @NotNull
    private final SecretAccessKey SecretAccessKey;
    @NotNull
    private final SessionToken Token;
    @NotNull
    private final Expiration Expiration;

    public Ec2Credentials(@NotNull String Code, @NotNull ZonedDateTime LastUpdated, @NotNull String Type2, @NotNull AccessKeyId AccessKeyId2, @NotNull SecretAccessKey SecretAccessKey2, @NotNull SessionToken Token2, @NotNull Expiration Expiration2) {
        Intrinsics.checkNotNullParameter((Object)Code, (String)"Code");
        Intrinsics.checkNotNullParameter((Object)LastUpdated, (String)"LastUpdated");
        Intrinsics.checkNotNullParameter((Object)Type2, (String)"Type");
        Intrinsics.checkNotNullParameter((Object)((Object)AccessKeyId2), (String)"AccessKeyId");
        Intrinsics.checkNotNullParameter((Object)((Object)SecretAccessKey2), (String)"SecretAccessKey");
        Intrinsics.checkNotNullParameter((Object)((Object)Token2), (String)"Token");
        Intrinsics.checkNotNullParameter((Object)((Object)Expiration2), (String)"Expiration");
        this.Code = Code;
        this.LastUpdated = LastUpdated;
        this.Type = Type2;
        this.AccessKeyId = AccessKeyId2;
        this.SecretAccessKey = SecretAccessKey2;
        this.Token = Token2;
        this.Expiration = Expiration2;
    }

    @NotNull
    public final String getCode() {
        return this.Code;
    }

    @NotNull
    public final ZonedDateTime getLastUpdated() {
        return this.LastUpdated;
    }

    @NotNull
    public final String getType() {
        return this.Type;
    }

    @NotNull
    public final AccessKeyId getAccessKeyId() {
        return this.AccessKeyId;
    }

    @NotNull
    public final SecretAccessKey getSecretAccessKey() {
        return this.SecretAccessKey;
    }

    @NotNull
    public final SessionToken getToken() {
        return this.Token;
    }

    @NotNull
    public final Expiration getExpiration() {
        return this.Expiration;
    }

    public final boolean expiresWithin(@NotNull Clock clock, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return ((ZonedDateTime)this.Expiration.getValue()).toInstant().minus(duration).isBefore(clock.instant());
    }

    @NotNull
    public final AwsCredentials asHttp4k() {
        return new AwsCredentials((String)this.AccessKeyId.getValue(), (String)this.SecretAccessKey.getValue(), (String)this.Token.getValue());
    }

    @NotNull
    public final String component1() {
        return this.Code;
    }

    @NotNull
    public final ZonedDateTime component2() {
        return this.LastUpdated;
    }

    @NotNull
    public final String component3() {
        return this.Type;
    }

    @NotNull
    public final AccessKeyId component4() {
        return this.AccessKeyId;
    }

    @NotNull
    public final SecretAccessKey component5() {
        return this.SecretAccessKey;
    }

    @NotNull
    public final SessionToken component6() {
        return this.Token;
    }

    @NotNull
    public final Expiration component7() {
        return this.Expiration;
    }

    @NotNull
    public final Ec2Credentials copy(@NotNull String Code, @NotNull ZonedDateTime LastUpdated, @NotNull String Type2, @NotNull AccessKeyId AccessKeyId2, @NotNull SecretAccessKey SecretAccessKey2, @NotNull SessionToken Token2, @NotNull Expiration Expiration2) {
        Intrinsics.checkNotNullParameter((Object)Code, (String)"Code");
        Intrinsics.checkNotNullParameter((Object)LastUpdated, (String)"LastUpdated");
        Intrinsics.checkNotNullParameter((Object)Type2, (String)"Type");
        Intrinsics.checkNotNullParameter((Object)((Object)AccessKeyId2), (String)"AccessKeyId");
        Intrinsics.checkNotNullParameter((Object)((Object)SecretAccessKey2), (String)"SecretAccessKey");
        Intrinsics.checkNotNullParameter((Object)((Object)Token2), (String)"Token");
        Intrinsics.checkNotNullParameter((Object)((Object)Expiration2), (String)"Expiration");
        return new Ec2Credentials(Code, LastUpdated, Type2, AccessKeyId2, SecretAccessKey2, Token2, Expiration2);
    }

    public static /* synthetic */ Ec2Credentials copy$default(Ec2Credentials ec2Credentials, String string, ZonedDateTime zonedDateTime, String string2, AccessKeyId accessKeyId, SecretAccessKey secretAccessKey, SessionToken sessionToken, Expiration expiration, int n, Object object) {
        if ((n & 1) != 0) {
            string = ec2Credentials.Code;
        }
        if ((n & 2) != 0) {
            zonedDateTime = ec2Credentials.LastUpdated;
        }
        if ((n & 4) != 0) {
            string2 = ec2Credentials.Type;
        }
        if ((n & 8) != 0) {
            accessKeyId = ec2Credentials.AccessKeyId;
        }
        if ((n & 0x10) != 0) {
            secretAccessKey = ec2Credentials.SecretAccessKey;
        }
        if ((n & 0x20) != 0) {
            sessionToken = ec2Credentials.Token;
        }
        if ((n & 0x40) != 0) {
            expiration = ec2Credentials.Expiration;
        }
        return ec2Credentials.copy(string, zonedDateTime, string2, accessKeyId, secretAccessKey, sessionToken, expiration);
    }

    @NotNull
    public String toString() {
        return "Ec2Credentials(Code=" + this.Code + ", LastUpdated=" + this.LastUpdated + ", Type=" + this.Type + ", AccessKeyId=" + (Object)((Object)this.AccessKeyId) + ", SecretAccessKey=" + (Object)((Object)this.SecretAccessKey) + ", Token=" + (Object)((Object)this.Token) + ", Expiration=" + (Object)((Object)this.Expiration) + ')';
    }

    public int hashCode() {
        int result = this.Code.hashCode();
        result = result * 31 + this.LastUpdated.hashCode();
        result = result * 31 + this.Type.hashCode();
        result = result * 31 + this.AccessKeyId.hashCode();
        result = result * 31 + this.SecretAccessKey.hashCode();
        result = result * 31 + this.Token.hashCode();
        result = result * 31 + this.Expiration.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ec2Credentials)) {
            return false;
        }
        Ec2Credentials ec2Credentials = (Ec2Credentials)other;
        if (!Intrinsics.areEqual((Object)this.Code, (Object)ec2Credentials.Code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.LastUpdated, (Object)ec2Credentials.LastUpdated)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.Type, (Object)ec2Credentials.Type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.AccessKeyId), (Object)((Object)ec2Credentials.AccessKeyId))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.SecretAccessKey), (Object)((Object)ec2Credentials.SecretAccessKey))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.Token), (Object)((Object)ec2Credentials.Token))) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.Expiration), (Object)((Object)ec2Credentials.Expiration));
    }
}

