/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.core.model;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.aws.AwsCredentials;
import org.http4k.connect.amazon.core.model.ARN;
import org.http4k.connect.amazon.core.model.AccessKeyId;
import org.http4k.connect.amazon.core.model.Expiration;
import org.http4k.connect.amazon.core.model.SecretAccessKey;
import org.http4k.connect.amazon.core.model.SessionToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J=\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006,"}, d2={"Lorg/http4k/connect/amazon/core/model/Credentials;", "", "Token", "Lorg/http4k/connect/amazon/core/model/SessionToken;", "AccessKeyId", "Lorg/http4k/connect/amazon/core/model/AccessKeyId;", "SecretAccessKey", "Lorg/http4k/connect/amazon/core/model/SecretAccessKey;", "Expiration", "Lorg/http4k/connect/amazon/core/model/Expiration;", "RoleArn", "Lorg/http4k/connect/amazon/core/model/ARN;", "<init>", "(Lorg/http4k/connect/amazon/core/model/SessionToken;Lorg/http4k/connect/amazon/core/model/AccessKeyId;Lorg/http4k/connect/amazon/core/model/SecretAccessKey;Lorg/http4k/connect/amazon/core/model/Expiration;Lorg/http4k/connect/amazon/core/model/ARN;)V", "getToken", "()Lorg/http4k/connect/amazon/core/model/SessionToken;", "getAccessKeyId", "()Lorg/http4k/connect/amazon/core/model/AccessKeyId;", "getSecretAccessKey", "()Lorg/http4k/connect/amazon/core/model/SecretAccessKey;", "getExpiration", "()Lorg/http4k/connect/amazon/core/model/Expiration;", "getRoleArn", "()Lorg/http4k/connect/amazon/core/model/ARN;", "expiresWithin", "", "clock", "Ljava/time/Clock;", "duration", "Ljava/time/Duration;", "asHttp4k", "Lorg/http4k/aws/AwsCredentials;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "http4k-connect-amazon-core"})
public final class Credentials {
    @NotNull
    private final SessionToken Token;
    @NotNull
    private final AccessKeyId AccessKeyId;
    @NotNull
    private final SecretAccessKey SecretAccessKey;
    @NotNull
    private final Expiration Expiration;
    @Nullable
    private final ARN RoleArn;

    public Credentials(@NotNull SessionToken Token2, @NotNull AccessKeyId AccessKeyId2, @NotNull SecretAccessKey SecretAccessKey2, @NotNull Expiration Expiration2, @Nullable ARN RoleArn) {
        Intrinsics.checkNotNullParameter((Object)((Object)Token2), (String)"Token");
        Intrinsics.checkNotNullParameter((Object)((Object)AccessKeyId2), (String)"AccessKeyId");
        Intrinsics.checkNotNullParameter((Object)((Object)SecretAccessKey2), (String)"SecretAccessKey");
        Intrinsics.checkNotNullParameter((Object)((Object)Expiration2), (String)"Expiration");
        this.Token = Token2;
        this.AccessKeyId = AccessKeyId2;
        this.SecretAccessKey = SecretAccessKey2;
        this.Expiration = Expiration2;
        this.RoleArn = RoleArn;
    }

    @NotNull
    public final SessionToken getToken() {
        return this.Token;
    }

    @NotNull
    public final AccessKeyId getAccessKeyId() {
        return this.AccessKeyId;
    }

    @NotNull
    public final SecretAccessKey getSecretAccessKey() {
        return this.SecretAccessKey;
    }

    @NotNull
    public final Expiration getExpiration() {
        return this.Expiration;
    }

    @Nullable
    public final ARN getRoleArn() {
        return this.RoleArn;
    }

    public final boolean expiresWithin(@NotNull Clock clock, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return ((ZonedDateTime)this.Expiration.getValue()).toInstant().minus(duration).isBefore(clock.instant());
    }

    @NotNull
    public final AwsCredentials asHttp4k() {
        return new AwsCredentials((String)this.AccessKeyId.getValue(), (String)this.SecretAccessKey.getValue(), (String)this.Token.getValue());
    }

    @NotNull
    public final SessionToken component1() {
        return this.Token;
    }

    @NotNull
    public final AccessKeyId component2() {
        return this.AccessKeyId;
    }

    @NotNull
    public final SecretAccessKey component3() {
        return this.SecretAccessKey;
    }

    @NotNull
    public final Expiration component4() {
        return this.Expiration;
    }

    @Nullable
    public final ARN component5() {
        return this.RoleArn;
    }

    @NotNull
    public final Credentials copy(@NotNull SessionToken Token2, @NotNull AccessKeyId AccessKeyId2, @NotNull SecretAccessKey SecretAccessKey2, @NotNull Expiration Expiration2, @Nullable ARN RoleArn) {
        Intrinsics.checkNotNullParameter((Object)((Object)Token2), (String)"Token");
        Intrinsics.checkNotNullParameter((Object)((Object)AccessKeyId2), (String)"AccessKeyId");
        Intrinsics.checkNotNullParameter((Object)((Object)SecretAccessKey2), (String)"SecretAccessKey");
        Intrinsics.checkNotNullParameter((Object)((Object)Expiration2), (String)"Expiration");
        return new Credentials(Token2, AccessKeyId2, SecretAccessKey2, Expiration2, RoleArn);
    }

    public static /* synthetic */ Credentials copy$default(Credentials credentials, SessionToken sessionToken, AccessKeyId accessKeyId, SecretAccessKey secretAccessKey, Expiration expiration, ARN aRN, int n, Object object) {
        if ((n & 1) != 0) {
            sessionToken = credentials.Token;
        }
        if ((n & 2) != 0) {
            accessKeyId = credentials.AccessKeyId;
        }
        if ((n & 4) != 0) {
            secretAccessKey = credentials.SecretAccessKey;
        }
        if ((n & 8) != 0) {
            expiration = credentials.Expiration;
        }
        if ((n & 0x10) != 0) {
            aRN = credentials.RoleArn;
        }
        return credentials.copy(sessionToken, accessKeyId, secretAccessKey, expiration, aRN);
    }

    @NotNull
    public String toString() {
        return "Credentials(Token=" + this.Token + ", AccessKeyId=" + this.AccessKeyId + ", SecretAccessKey=" + this.SecretAccessKey + ", Expiration=" + this.Expiration + ", RoleArn=" + this.RoleArn + ")";
    }

    public int hashCode() {
        int result = this.Token.hashCode();
        result = result * 31 + this.AccessKeyId.hashCode();
        result = result * 31 + this.SecretAccessKey.hashCode();
        result = result * 31 + this.Expiration.hashCode();
        result = result * 31 + (this.RoleArn == null ? 0 : this.RoleArn.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Credentials)) {
            return false;
        }
        Credentials credentials = (Credentials)other;
        if (!Intrinsics.areEqual((Object)((Object)this.Token), (Object)((Object)credentials.Token))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.AccessKeyId), (Object)((Object)credentials.AccessKeyId))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.SecretAccessKey), (Object)((Object)credentials.SecretAccessKey))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.Expiration), (Object)((Object)credentials.Expiration))) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)this.RoleArn), (Object)((Object)credentials.RoleArn));
    }
}

