/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.dynamodb.mapper;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.RemoteFailure;
import org.http4k.connect.amazon.dynamodb.DynamoDb;
import org.http4k.connect.amazon.dynamodb.DynamodbExtensionsKt;
import org.http4k.connect.amazon.dynamodb.action.GetResponse;
import org.http4k.connect.amazon.dynamodb.action.TableDescriptionResponse;
import org.http4k.connect.amazon.dynamodb.mapper.DynamoDbIndexMapper;
import org.http4k.connect.amazon.dynamodb.mapper.DynamoDbTableMapperSchema;
import org.http4k.connect.amazon.dynamodb.mapper.DynamoDbTableMapperSchemaKt;
import org.http4k.connect.amazon.dynamodb.model.Attribute;
import org.http4k.connect.amazon.dynamodb.model.AttributeName;
import org.http4k.connect.amazon.dynamodb.model.AttributeValue;
import org.http4k.connect.amazon.dynamodb.model.ItemAndKeyKt;
import org.http4k.connect.amazon.dynamodb.model.KeySchema;
import org.http4k.connect.amazon.dynamodb.model.ReqWriteItem;
import org.http4k.connect.amazon.dynamodb.model.TableName;
import org.http4k.lens.BiDiLens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u00020\u0002BM\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\"\u0010\t\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u0012\u0004\u0012\u00028\u00000\n\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J;\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\"\u0010\u0016\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00180\u0017\"\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0018\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00018\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J$\u0010 \u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00028\u00012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00018\u0002H\u0086\u0002\u00a2\u0006\u0002\u0010!J@\u0010\"\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u0002H%0#\"\b\b\u0003\u0010$*\u00020\u0002\"\b\b\u0004\u0010%*\u00020\u00022\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u0002H%0\u0010J\u0016\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010)J\u0017\u0010'\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0086\u0002J\u0016\u0010,\u001a\u00020\u001b2\u0006\u0010(\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010)J\u0017\u0010,\u001a\u00020\u001b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0086\u0002J\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020#J!\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`/*\u00028\u0000H\u0002\u00a2\u0006\u0002\u00100R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapper;", "Document", "", "HashKey", "SortKey", "dynamoDb", "Lorg/http4k/connect/amazon/dynamodb/DynamoDb;", "tableName", "Lorg/http4k/connect/amazon/dynamodb/model/TableName;", "itemLens", "Lorg/http4k/lens/BiDiLens;", "", "Lorg/http4k/connect/amazon/dynamodb/model/AttributeName;", "Lorg/http4k/connect/amazon/dynamodb/model/AttributeValue;", "Lorg/http4k/connect/amazon/dynamodb/model/Item;", "primarySchema", "Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapperSchema;", "(Lorg/http4k/connect/amazon/dynamodb/DynamoDb;Lorg/http4k/connect/amazon/dynamodb/model/TableName;Lorg/http4k/lens/BiDiLens;Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapperSchema;)V", "createTable", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/connect/amazon/dynamodb/action/TableDescriptionResponse;", "Lorg/http4k/connect/RemoteFailure;", "secondarySchemas", "", "Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapperSchema$Secondary;", "([Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapperSchema$Secondary;)Ldev/forkhandles/result4k/Result;", "delete", "", "hashKey", "sortKey", "(Ljava/lang/Object;Ljava/lang/Object;)V", "deleteTable", "get", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "index", "Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbIndexMapper;", "NewHashKey", "NewSortKey", "schema", "minusAssign", "document", "(Ljava/lang/Object;)V", "documents", "", "plusAssign", "primaryIndex", "key", "Lorg/http4k/connect/amazon/dynamodb/model/Key;", "(Ljava/lang/Object;)Ljava/util/Map;", "http4k-connect-amazon-dynamodb"})
public final class DynamoDbTableMapper<Document, HashKey, SortKey> {
    @NotNull
    private final DynamoDb dynamoDb;
    @NotNull
    private final TableName tableName;
    @NotNull
    private final BiDiLens<Map<AttributeName, AttributeValue>, Document> itemLens;
    @NotNull
    private final DynamoDbTableMapperSchema<HashKey, SortKey> primarySchema;

    public DynamoDbTableMapper(@NotNull DynamoDb dynamoDb, @NotNull TableName tableName, @NotNull BiDiLens<? super Map<AttributeName, AttributeValue>, Document> itemLens, @NotNull DynamoDbTableMapperSchema<HashKey, SortKey> primarySchema) {
        Intrinsics.checkNotNullParameter((Object)dynamoDb, (String)"dynamoDb");
        Intrinsics.checkNotNullParameter((Object)((Object)tableName), (String)"tableName");
        Intrinsics.checkNotNullParameter(itemLens, (String)"itemLens");
        Intrinsics.checkNotNullParameter(primarySchema, (String)"primarySchema");
        this.dynamoDb = dynamoDb;
        this.tableName = tableName;
        this.itemLens = itemLens;
        this.primarySchema = primarySchema;
    }

    private final Map<AttributeName, AttributeValue> key(Document $this$key) {
        Function1[] function1Array = new Function1[]{this.itemLens.of($this$key)};
        Map<AttributeName, AttributeValue> item = ItemAndKeyKt.with(ItemAndKeyKt.Item(new Function1[0]), function1Array);
        Object hashKey = this.primarySchema.getHashKeyAttribute().invoke(item);
        Attribute<SortKey> attribute = this.primarySchema.getSortKeyAttribute();
        Object sortKey = attribute != null ? attribute.invoke(item) : null;
        return DynamoDbTableMapperSchemaKt.key(this.primarySchema, hashKey, sortKey);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Document get(@NotNull HashKey hashKey, @Nullable SortKey sortKey) {
        Object object;
        void $this$onFailure$iv;
        Intrinsics.checkNotNullParameter(hashKey, (String)"hashKey");
        Object object2 = DynamodbExtensionsKt.getItem$default(this.dynamoDb, this.tableName, DynamoDbTableMapperSchemaKt.key(this.primarySchema, hashKey, sortKey), null, null, null, null, 60, null);
        boolean $i$f$onFailure = false;
        void var6_5 = $this$onFailure$iv;
        if (!(var6_5 instanceof Success)) {
            if (var6_5 instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                boolean bl = false;
                ((RemoteFailure)it.getReason()).throwIt();
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        Map<AttributeName, AttributeValue> map2 = ((GetResponse)((Success)$this$onFailure$iv).getValue()).getItem();
        if (map2 != null) {
            object2 = map2;
            object = ((Function1)this.itemLens).invoke(object2);
        } else {
            object = null;
        }
        return (Document)object;
    }

    public static /* synthetic */ Object get$default(DynamoDbTableMapper dynamoDbTableMapper, Object object, Object object2, int n, Object object3) {
        if ((n & 2) != 0) {
            object2 = null;
        }
        return dynamoDbTableMapper.get(object, object2);
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull Collection<? extends Document> documents) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        if (documents.isEmpty()) {
            return;
        }
        for (List chunk : CollectionsKt.chunked((Iterable)documents, (int)25)) {
            void $this$onFailure$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = chunk;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void obj;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Function1[] function1Array = new Function1[]{this.itemLens.of((Object)obj)};
                Map<AttributeName, AttributeValue> item = ItemAndKeyKt.with(ItemAndKeyKt.Item(new Function1[0]), function1Array);
                collection.add(ReqWriteItem.Companion.Put(item));
            }
            List batch = (List)destination$iv$iv;
            $this$map$iv = DynamodbExtensionsKt.batchWriteItem$default(this.dynamoDb, MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)this.tableName), (Object)batch)), null, null, 6, null);
            boolean $i$f$onFailure = false;
            iterable = $this$onFailure$iv;
            if (iterable instanceof Success) {
                ((Success)$this$onFailure$iv).getValue();
                continue;
            }
            if (iterable instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                boolean bl = false;
                ((RemoteFailure)it.getReason()).throwIt();
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void plusAssign(@NotNull Document document) {
        Intrinsics.checkNotNullParameter(document, (String)"document");
        Function1[] function1Array = new Function1[]{this.itemLens.of(document)};
        Map<AttributeName, AttributeValue> item = ItemAndKeyKt.with(ItemAndKeyKt.Item(new Function1[0]), function1Array);
        Result $this$onFailure$iv = DynamodbExtensionsKt.putItem$default(this.dynamoDb, this.tableName, item, null, null, null, null, null, null, 252, null);
        boolean $i$f$onFailure = false;
        Result result = $this$onFailure$iv;
        if (!(result instanceof Success)) {
            if (result instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                boolean bl = false;
                ((RemoteFailure)it.getReason()).throwIt();
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        ((Success)$this$onFailure$iv).getValue();
    }

    public final void delete(@NotNull HashKey hashKey, @Nullable SortKey sortKey) {
        Intrinsics.checkNotNullParameter(hashKey, (String)"hashKey");
        DynamodbExtensionsKt.deleteItem$default(this.dynamoDb, this.tableName, DynamoDbTableMapperSchemaKt.key(this.primarySchema, hashKey, sortKey), null, null, null, null, null, null, 252, null);
    }

    public static /* synthetic */ void delete$default(DynamoDbTableMapper dynamoDbTableMapper, Object object, Object object2, int n, Object object3) {
        if ((n & 2) != 0) {
            object2 = null;
        }
        dynamoDbTableMapper.delete(object, object2);
    }

    public final void minusAssign(@NotNull Document document) {
        Intrinsics.checkNotNullParameter(document, (String)"document");
        Function1[] function1Array = new Function1[]{this.itemLens.of(document)};
        Map<AttributeName, AttributeValue> item = ItemAndKeyKt.with(ItemAndKeyKt.Item(new Function1[0]), function1Array);
        Attribute<SortKey> attribute = this.primarySchema.getSortKeyAttribute();
        this.delete(this.primarySchema.getHashKeyAttribute().invoke(item), attribute != null ? attribute.invoke(item) : null);
    }

    /*
     * WARNING - void declaration
     */
    public final void minusAssign(@NotNull Collection<? extends Document> documents) {
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        Iterable $this$map$iv = documents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = object.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.key(it));
        }
        List keys = (List)destination$iv$iv;
        for (List chunk : CollectionsKt.chunked((Iterable)keys, (int)25)) {
            void $this$onFailure$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = chunk;
            boolean $i$f$map2 = false;
            object = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void key;
                Map map2 = (Map)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(ReqWriteItem.Companion.Delete((Map<AttributeName, AttributeValue>)key));
            }
            List batch = (List)destination$iv$iv2;
            $this$map$iv2 = DynamodbExtensionsKt.batchWriteItem$default(this.dynamoDb, MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)this.tableName), (Object)batch)), null, null, 6, null);
            boolean $i$f$onFailure = false;
            object = $this$onFailure$iv;
            if (object instanceof Success) {
                ((Success)$this$onFailure$iv).getValue();
                continue;
            }
            if (object instanceof Failure) {
                Failure it = (Failure)$this$onFailure$iv;
                boolean bl = false;
                ((RemoteFailure)it.getReason()).throwIt();
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public final <NewHashKey, NewSortKey> DynamoDbIndexMapper<Document, NewHashKey, NewSortKey> index(@NotNull DynamoDbTableMapperSchema<NewHashKey, NewSortKey> schema) {
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        return new DynamoDbIndexMapper<Document, NewHashKey, NewSortKey>(this.dynamoDb, this.tableName, this.itemLens, schema);
    }

    @NotNull
    public final DynamoDbIndexMapper<Document, HashKey, SortKey> primaryIndex() {
        return this.index(this.primarySchema);
    }

    @NotNull
    public final Result<TableDescriptionResponse, RemoteFailure> createTable(DynamoDbTableMapperSchema.Secondary<?, ?> ... secondarySchemas) {
        List it;
        List list2;
        Intrinsics.checkNotNullParameter(secondarySchemas, (String)"secondarySchemas");
        Set attributeDefinitions = CollectionsKt.toMutableSet((Iterable)this.primarySchema.attributeDefinitions());
        List globalIndexes = new ArrayList();
        List localIndexes = new ArrayList();
        for (DynamoDbTableMapperSchema.Secondary<?, ?> schema : secondarySchemas) {
            CollectionsKt.addAll((Collection)attributeDefinitions, (Iterable)schema.attributeDefinitions());
            DynamoDbTableMapperSchema.Secondary<?, ?> secondary = schema;
            if (secondary instanceof DynamoDbTableMapperSchema.GlobalSecondary) {
                ((Collection)globalIndexes).add(((DynamoDbTableMapperSchema.GlobalSecondary)schema).toIndex());
                continue;
            }
            if (!(secondary instanceof DynamoDbTableMapperSchema.LocalSecondary)) continue;
            ((Collection)localIndexes).add(((DynamoDbTableMapperSchema.LocalSecondary)schema).toIndex());
        }
        List list3 = list2 = globalIndexes;
        List list4 = CollectionsKt.toList((Iterable)attributeDefinitions);
        List<KeySchema> list5 = this.primarySchema.keySchema();
        TableName tableName = this.tableName;
        DynamoDb dynamoDb = this.dynamoDb;
        boolean bl = false;
        boolean bl2 = !((Collection)it).isEmpty();
        List list6 = bl2 ? list2 : null;
        it = list2 = localIndexes;
        List list7 = list6;
        boolean bl3 = false;
        boolean bl4 = !((Collection)it).isEmpty();
        return DynamodbExtensionsKt.createTable$default(dynamoDb, tableName, list5, list4, list7, bl4 ? list2 : null, null, null, null, null, null, 992, null);
    }

    @NotNull
    public final Result<TableDescriptionResponse, RemoteFailure> deleteTable() {
        return DynamodbExtensionsKt.deleteTable(this.dynamoDb, this.tableName);
    }
}

