/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.dynamodb.mapper;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.connect.amazon.dynamodb.DynamoDb;
import org.http4k.connect.amazon.dynamodb.DynamodbExtensionsKt;
import org.http4k.connect.amazon.dynamodb.mapper.DynamoDbIndexMapper;
import org.http4k.connect.amazon.dynamodb.mapper.DynamoDbTableMapperSchema;
import org.http4k.connect.amazon.dynamodb.model.AttributeName;
import org.http4k.connect.amazon.dynamodb.model.AttributeValue;
import org.http4k.connect.amazon.dynamodb.model.IndexName;
import org.http4k.connect.amazon.dynamodb.model.TableName;
import org.http4k.lens.BiDiLens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u00020\u0002BM\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\"\u0010\t\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u0012\u0004\u0012\u00028\u00000\n\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017JR\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016JH\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000e\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbIndexMapper;", "Document", "", "HashKey", "SortKey", "dynamoDb", "Lorg/http4k/connect/amazon/dynamodb/DynamoDb;", "tableName", "Lorg/http4k/connect/amazon/dynamodb/model/TableName;", "itemLens", "Lorg/http4k/lens/BiDiLens;", "", "Lorg/http4k/connect/amazon/dynamodb/model/AttributeName;", "Lorg/http4k/connect/amazon/dynamodb/model/AttributeValue;", "Lorg/http4k/connect/amazon/dynamodb/model/Item;", "schema", "Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapperSchema;", "(Lorg/http4k/connect/amazon/dynamodb/DynamoDb;Lorg/http4k/connect/amazon/dynamodb/model/TableName;Lorg/http4k/lens/BiDiLens;Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbTableMapperSchema;)V", "query", "Lkotlin/sequences/Sequence;", "hashKey", "scanIndexForward", "", "(Ljava/lang/Object;Z)Lkotlin/sequences/Sequence;", "filter", "", "names", "values", "scan", "http4k-connect-amazon-dynamodb"})
public final class DynamoDbIndexMapper<Document, HashKey, SortKey> {
    @NotNull
    private final DynamoDb dynamoDb;
    @NotNull
    private final TableName tableName;
    @NotNull
    private final BiDiLens<Map<AttributeName, AttributeValue>, Document> itemLens;
    @NotNull
    private final DynamoDbTableMapperSchema<HashKey, SortKey> schema;

    public DynamoDbIndexMapper(@NotNull DynamoDb dynamoDb, @NotNull TableName tableName, @NotNull BiDiLens<? super Map<AttributeName, AttributeValue>, Document> itemLens, @NotNull DynamoDbTableMapperSchema<HashKey, SortKey> schema) {
        Intrinsics.checkNotNullParameter((Object)dynamoDb, (String)"dynamoDb");
        Intrinsics.checkNotNullParameter((Object)((Object)tableName), (String)"tableName");
        Intrinsics.checkNotNullParameter(itemLens, (String)"itemLens");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        this.dynamoDb = dynamoDb;
        this.tableName = tableName;
        this.itemLens = itemLens;
        this.schema = schema;
    }

    @NotNull
    public final Sequence<Document> scan(@Nullable String filter, @Nullable Map<String, AttributeName> names, @Nullable Map<String, AttributeValue> values) {
        return SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)DynamodbExtensionsKt.scanPaginated$default(this.dynamoDb, this.tableName, filter, null, names, values, null, null, null, null, null, null, null, null, 8164, null), (Function1)scan.1.INSTANCE), (Function1)((Function1)this.itemLens));
    }

    public static /* synthetic */ Sequence scan$default(DynamoDbIndexMapper dynamoDbIndexMapper, String string2, Map map2, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        if ((n & 4) != 0) {
            map3 = null;
        }
        return dynamoDbIndexMapper.scan(string2, map2, map3);
    }

    @NotNull
    public final Sequence<Document> query(@Nullable String filter, @Nullable Map<String, AttributeName> names, @Nullable Map<String, AttributeValue> values, boolean scanIndexForward) {
        DynamoDb dynamoDb = this.dynamoDb;
        TableName tableName = this.tableName;
        IndexName indexName = this.schema.getIndexName();
        return SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)DynamodbExtensionsKt.queryPaginated$default(dynamoDb, tableName, filter, null, null, names, values, indexName, null, null, null, null, null, scanIndexForward, 3980, null), (Function1)query.1.INSTANCE), (Function1)((Function1)this.itemLens));
    }

    public static /* synthetic */ Sequence query$default(DynamoDbIndexMapper dynamoDbIndexMapper, String string2, Map map2, Map map3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        if ((n & 4) != 0) {
            map3 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return dynamoDbIndexMapper.query(string2, map2, map3, bl);
    }

    @NotNull
    public final Sequence<Document> query(@NotNull HashKey hashKey, boolean scanIndexForward) {
        Intrinsics.checkNotNullParameter(hashKey, (String)"hashKey");
        return DynamoDbIndexMapper.query$default(this, this.schema.getHashKeyAttribute() + " = :val1", null, MapsKt.mapOf((Pair)TuplesKt.to((Object)":val1", (Object)this.schema.getHashKeyAttribute().asValue(hashKey))), scanIndexForward, 2, null);
    }

    public static /* synthetic */ Sequence query$default(DynamoDbIndexMapper dynamoDbIndexMapper, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return dynamoDbIndexMapper.query(object, bl);
    }
}

