/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.dynamodb.mapper;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.connect.amazon.dynamodb.mapper.CombinedKeyCondition;
import org.http4k.connect.amazon.dynamodb.mapper.DynamoDbScanAndQueryBuilder;
import org.http4k.connect.amazon.dynamodb.mapper.FilterExpression;
import org.http4k.connect.amazon.dynamodb.mapper.KeyCondition;
import org.http4k.connect.amazon.dynamodb.mapper.PartitionKeyCondition;
import org.http4k.connect.amazon.dynamodb.mapper.SortKeyCondition;
import org.http4k.connect.amazon.dynamodb.model.Attribute;
import org.http4k.connect.amazon.dynamodb.model.AttributeName;
import org.http4k.connect.amazon.dynamodb.model.AttributeValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010\u000b\u001a\u00020\u00112)\u0010\u0012\u001a%\u0012\u0014\u0012\u00120\u0014R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0013\u00a2\u0006\u0002\b\u0015H\u0000\u00a2\u0006\u0002\b\u0016JB\u0010\u000e\u001a\u00020\u001123\u0010\u0012\u001a/\u0012\u0014\u0012\u00120\u0017R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00180\u0013\u00a2\u0006\u0002\b\u0015H\u0000\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder;", "HashKey", "", "SortKey", "()V", "_filterExpression", "Lorg/http4k/connect/amazon/dynamodb/mapper/FilterExpression;", "_keyCondition", "Lorg/http4k/connect/amazon/dynamodb/mapper/KeyCondition;", "attributeNameCount", "", "filterExpression", "getFilterExpression$http4k_connect_amazon_dynamodb", "()Lorg/http4k/connect/amazon/dynamodb/mapper/FilterExpression;", "keyCondition", "getKeyCondition$http4k_connect_amazon_dynamodb", "()Lorg/http4k/connect/amazon/dynamodb/mapper/KeyCondition;", "", "block", "Lkotlin/Function1;", "Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$FilterExpressionBuilder;", "Lkotlin/ExtensionFunctionType;", "filterExpression$http4k_connect_amazon_dynamodb", "Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$KeyConditionBuilder;", "Lorg/http4k/connect/amazon/dynamodb/mapper/CombinedKeyCondition;", "keyCondition$http4k_connect_amazon_dynamodb", "nextAttributeName", "", "FilterExpressionBuilder", "KeyConditionBuilder", "http4k-connect-amazon-dynamodb"})
public final class DynamoDbScanAndQueryBuilder<HashKey, SortKey> {
    private int attributeNameCount;
    @Nullable
    private KeyCondition<HashKey, SortKey> _keyCondition;
    @Nullable
    private FilterExpression _filterExpression;

    private final String nextAttributeName() {
        int base2 = 26;
        StringBuilder name = new StringBuilder();
        int currentCount = this.attributeNameCount;
        do {
            int remainder = currentCount % base2;
            name.insert(0, (char)(97 + remainder));
        } while ((currentCount /= base2) > 0);
        ++this.attributeNameCount;
        String string2 = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final void keyCondition$http4k_connect_amazon_dynamodb(@NotNull Function1<? super KeyConditionBuilder, ? extends CombinedKeyCondition<HashKey, SortKey>> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this._keyCondition = (KeyCondition)block.invoke((Object)new KeyConditionBuilder());
    }

    public final void filterExpression$http4k_connect_amazon_dynamodb(@NotNull Function1<? super FilterExpressionBuilder, FilterExpression> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this._filterExpression = (FilterExpression)block.invoke((Object)new FilterExpressionBuilder());
    }

    @Nullable
    public final KeyCondition<HashKey, SortKey> getKeyCondition$http4k_connect_amazon_dynamodb() {
        return this._keyCondition;
    }

    @Nullable
    public final FilterExpression getFilterExpression$http4k_connect_amazon_dynamodb() {
        return this._filterExpression;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u0007\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J/\u0010\b\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\n\u001a\u0002H\t2\u0006\u0010\u000b\u001a\u0002H\t\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0086\u0004J&\u0010\u0011\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J&\u0010\u0014\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J&\u0010\u0015\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0015\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\u0004J-\u0010\u0016\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u0002H\tH\u0002\u00a2\u0006\u0002\u0010\u0019J.\u0010\u0016\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0002J&\u0010\u001a\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J'\u0010\u001a\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\u0004J&\u0010\u001b\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J'\u0010\u001b\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\u0004J'\u0010\u001c\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\t0\u001eH\u0086\u0004J&\u0010\u001f\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J'\u0010\u001f\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\u0004J&\u0010 \u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J'\u0010 \u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\u0004J&\u0010!\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\u0006\u0010\u0012\u001a\u0002H\tH\u0086\u0004\u00a2\u0006\u0002\u0010\u0013J'\u0010!\u001a\u00020\u0004\"\u0004\b\u0002\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0006H\u0086\u0004J\u001b\u0010\"\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0086\u0004\u00a8\u0006#"}, d2={"Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$FilterExpressionBuilder;", "", "(Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder;)V", "attributeExists", "Lorg/http4k/connect/amazon/dynamodb/mapper/FilterExpression;", "attr", "Lorg/http4k/connect/amazon/dynamodb/model/Attribute;", "attributeNotExists", "between", "T", "value1", "value2", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/Object;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/FilterExpression;", "not", "expr", "and", "other", "beginsWith", "value", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/FilterExpression;", "contains", "eq", "filterOperator", "op", "", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/String;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/FilterExpression;", "ge", "gt", "isIn", "values", "", "le", "lt", "ne", "or", "http4k-connect-amazon-dynamodb"})
    @SourceDebugExtension(value={"SMAP\nDynamoDbQueryDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoDbQueryDsl.kt\norg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$FilterExpressionBuilder\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n32#2,2:391\n1#3:393\n*S KotlinDebug\n*F\n+ 1 DynamoDbQueryDsl.kt\norg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$FilterExpressionBuilder\n*L\n157#1:391,2\n*E\n"})
    public final class FilterExpressionBuilder {
        private final <T> FilterExpression filterOperator(Attribute<T> $this$filterOperator, String op, T value2) {
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return new FilterExpression('#' + attributeName + ' ' + op + " :" + attributeName, MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)$this$filterOperator.getName())), MapsKt.mapOf((Pair)TuplesKt.to((Object)(':' + attributeName), (Object)$this$filterOperator.asValue(value2))));
        }

        private final <T> FilterExpression filterOperator(Attribute<T> $this$filterOperator, String op, Attribute<T> other) {
            String attributeName1 = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            String attributeName2 = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)('#' + attributeName1), (Object)$this$filterOperator.getName()), TuplesKt.to((Object)('#' + attributeName2), (Object)other.getName())};
            return new FilterExpression('#' + attributeName1 + ' ' + op + " #" + attributeName2, MapsKt.mapOf((Pair[])pairArray), MapsKt.emptyMap());
        }

        @NotNull
        public final <T> FilterExpression eq(@NotNull Attribute<T> $this$eq, T value2) {
            Intrinsics.checkNotNullParameter($this$eq, (String)"<this>");
            return this.filterOperator($this$eq, "=", value2);
        }

        @NotNull
        public final <T> FilterExpression eq(@NotNull Attribute<T> $this$eq, @NotNull Attribute<T> other) {
            Intrinsics.checkNotNullParameter($this$eq, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.filterOperator($this$eq, "=", other);
        }

        @NotNull
        public final <T> FilterExpression ne(@NotNull Attribute<T> $this$ne, T value2) {
            Intrinsics.checkNotNullParameter($this$ne, (String)"<this>");
            return this.filterOperator($this$ne, "<>", value2);
        }

        @NotNull
        public final <T> FilterExpression ne(@NotNull Attribute<T> $this$ne, @NotNull Attribute<T> other) {
            Intrinsics.checkNotNullParameter($this$ne, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.filterOperator($this$ne, "<>", other);
        }

        @NotNull
        public final <T> FilterExpression lt(@NotNull Attribute<T> $this$lt, T value2) {
            Intrinsics.checkNotNullParameter($this$lt, (String)"<this>");
            return this.filterOperator($this$lt, "<", value2);
        }

        @NotNull
        public final <T> FilterExpression lt(@NotNull Attribute<T> $this$lt, @NotNull Attribute<T> other) {
            Intrinsics.checkNotNullParameter($this$lt, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.filterOperator($this$lt, "<", other);
        }

        @NotNull
        public final <T> FilterExpression le(@NotNull Attribute<T> $this$le, T value2) {
            Intrinsics.checkNotNullParameter($this$le, (String)"<this>");
            return this.filterOperator($this$le, "<=", value2);
        }

        @NotNull
        public final <T> FilterExpression le(@NotNull Attribute<T> $this$le, @NotNull Attribute<T> other) {
            Intrinsics.checkNotNullParameter($this$le, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.filterOperator($this$le, "<=", other);
        }

        @NotNull
        public final <T> FilterExpression gt(@NotNull Attribute<T> $this$gt, T value2) {
            Intrinsics.checkNotNullParameter($this$gt, (String)"<this>");
            return this.filterOperator($this$gt, ">", value2);
        }

        @NotNull
        public final <T> FilterExpression gt(@NotNull Attribute<T> $this$gt, @NotNull Attribute<T> other) {
            Intrinsics.checkNotNullParameter($this$gt, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.filterOperator($this$gt, ">", other);
        }

        @NotNull
        public final <T> FilterExpression ge(@NotNull Attribute<T> $this$ge, T value2) {
            Intrinsics.checkNotNullParameter($this$ge, (String)"<this>");
            return this.filterOperator($this$ge, ">=", value2);
        }

        @NotNull
        public final <T> FilterExpression ge(@NotNull Attribute<T> $this$ge, @NotNull Attribute<T> other) {
            Intrinsics.checkNotNullParameter($this$ge, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return this.filterOperator($this$ge, ">=", other);
        }

        @NotNull
        public final <T> FilterExpression between(@NotNull Attribute<T> attr, T value1, T value2) {
            Intrinsics.checkNotNullParameter(attr, (String)"attr");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)(':' + attributeName + '1'), (Object)attr.asValue(value1)), TuplesKt.to((Object)(':' + attributeName + '2'), (Object)attr.asValue(value2))};
            return new FilterExpression('#' + attributeName + " BETWEEN :" + attributeName + "1 AND :" + attributeName + '2', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)attr.getName())), MapsKt.mapOf((Pair[])pairArray));
        }

        @NotNull
        public final <T> FilterExpression isIn(@NotNull Attribute<T> $this$isIn, @NotNull Iterable<? extends T> values) {
            Intrinsics.checkNotNullParameter($this$isIn, (String)"<this>");
            Intrinsics.checkNotNullParameter(values, (String)"values");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            Map attributeValues = new LinkedHashMap();
            StringBuilder expression = new StringBuilder('#' + attributeName + " IN (");
            Iterator $this$forEach$iv = CollectionsKt.withIndex(values.iterator());
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                IndexedValue indexedValue = (IndexedValue)element$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                Object value2 = indexedValue.component2();
                String valueName = ':' + attributeName + index;
                attributeValues.put(valueName, $this$isIn.asValue(value2));
                if (index > 0) {
                    expression.append(',');
                }
                expression.append(valueName);
            }
            expression.append(')');
            if (!(!attributeValues.isEmpty())) {
                boolean bl = false;
                String string2 = "IN operator requires at least one element";
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = expression.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return new FilterExpression(string3, MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)$this$isIn.getName())), attributeValues);
        }

        @NotNull
        public final FilterExpression attributeExists(@NotNull Attribute<?> attr) {
            Intrinsics.checkNotNullParameter(attr, (String)"attr");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return new FilterExpression("attribute_exists(#" + attributeName + ')', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)attr.getName())), MapsKt.emptyMap());
        }

        @NotNull
        public final FilterExpression attributeNotExists(@NotNull Attribute<?> attr) {
            Intrinsics.checkNotNullParameter(attr, (String)"attr");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return new FilterExpression("attribute_not_exists(#" + attributeName + ')', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)attr.getName())), MapsKt.emptyMap());
        }

        @NotNull
        public final <T> FilterExpression beginsWith(@NotNull Attribute<T> $this$beginsWith, T value2) {
            Intrinsics.checkNotNullParameter($this$beginsWith, (String)"<this>");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return new FilterExpression("begins_with(#" + attributeName + ",:" + attributeName + ')', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)$this$beginsWith.getName())), MapsKt.mapOf((Pair)TuplesKt.to((Object)(':' + attributeName), (Object)$this$beginsWith.asValue(value2))));
        }

        @NotNull
        public final <T> FilterExpression contains(@NotNull Attribute<T> $this$contains, T value2) {
            Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return new FilterExpression("contains(#" + attributeName + ",:" + attributeName + ')', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)$this$contains.getName())), MapsKt.mapOf((Pair)TuplesKt.to((Object)(':' + attributeName), (Object)$this$contains.asValue(value2))));
        }

        @Nullable
        public final FilterExpression and(@Nullable FilterExpression $this$and, @Nullable FilterExpression other) {
            return $this$and == null ? other : (other == null ? $this$and : new FilterExpression('(' + $this$and.getExpression() + " AND " + other.getExpression() + ')', MapsKt.plus($this$and.getAttributeNames(), other.getAttributeNames()), MapsKt.plus($this$and.getAttributeValues(), other.getAttributeValues())));
        }

        @Nullable
        public final FilterExpression or(@Nullable FilterExpression $this$or, @Nullable FilterExpression other) {
            return $this$or == null ? other : (other == null ? $this$or : new FilterExpression('(' + $this$or.getExpression() + " OR " + other.getExpression() + ')', MapsKt.plus($this$or.getAttributeNames(), other.getAttributeNames()), MapsKt.plus($this$or.getAttributeValues(), other.getAttributeValues())));
        }

        @Nullable
        public final FilterExpression not(@Nullable FilterExpression expr) {
            FilterExpression filterExpression;
            FilterExpression filterExpression2 = expr;
            if (filterExpression2 != null) {
                FilterExpression it = filterExpression2;
                boolean bl = false;
                filterExpression = new FilterExpression("(NOT " + it.getExpression() + ')', it.getAttributeNames(), it.getAttributeValues());
            } else {
                filterExpression = null;
            }
            return filterExpression;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e*\u0001\u000b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0007\u001a\u00028\u00012\u0006\u0010\b\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\tJQ\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u000fj\u0002`\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J;\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0017*\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0004H\u0086\u0004J,\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004*\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001b\u001a\u00028\u0001H\u0086\u0004\u00a2\u0006\u0002\u0010\u001cJ,\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0018*\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u001b\u001a\u00028\u0000H\u0086\u0004\u00a2\u0006\u0002\u0010\u001eJ,\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004*\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001b\u001a\u00028\u0001H\u0086\u0004\u00a2\u0006\u0002\u0010\u001cJ,\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004*\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001b\u001a\u00028\u0001H\u0086\u0004\u00a2\u0006\u0002\u0010\u001cJ,\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004*\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001b\u001a\u00028\u0001H\u0086\u0004\u00a2\u0006\u0002\u0010\u001cJ,\u0010\"\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004*\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u001b\u001a\u00028\u0001H\u0086\u0004\u00a2\u0006\u0002\u0010\u001cJ3\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b*\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010$\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$KeyConditionBuilder;", "", "(Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder;)V", "between", "Lorg/http4k/connect/amazon/dynamodb/mapper/SortKeyCondition;", "attr", "Lorg/http4k/connect/amazon/dynamodb/model/Attribute;", "value1", "value2", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/Object;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/SortKeyCondition;", "sortKeyCondition", "org/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$KeyConditionBuilder$sortKeyCondition$1", "expr", "", "attrNames", "", "Lorg/http4k/connect/amazon/dynamodb/model/AttributeName;", "Lorg/http4k/connect/amazon/dynamodb/model/TokensToNames;", "attrValues", "Lorg/http4k/connect/amazon/dynamodb/model/AttributeValue;", "Lorg/http4k/connect/amazon/dynamodb/model/TokensToValues;", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$KeyConditionBuilder$sortKeyCondition$1;", "and", "Lorg/http4k/connect/amazon/dynamodb/mapper/CombinedKeyCondition;", "Lorg/http4k/connect/amazon/dynamodb/mapper/PartitionKeyCondition;", "secondary", "beginsWith", "value", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/SortKeyCondition;", "eq", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/PartitionKeyCondition;", "ge", "gt", "le", "lt", "sortKeyOperator", "op", "(Lorg/http4k/connect/amazon/dynamodb/model/Attribute;Ljava/lang/String;Ljava/lang/Object;)Lorg/http4k/connect/amazon/dynamodb/mapper/DynamoDbScanAndQueryBuilder$KeyConditionBuilder$sortKeyCondition$1;", "http4k-connect-amazon-dynamodb"})
    public final class KeyConditionBuilder {
        @NotNull
        public final PartitionKeyCondition<HashKey, SortKey> eq(@NotNull Attribute<HashKey> $this$eq, @NotNull HashKey value2) {
            Intrinsics.checkNotNullParameter($this$eq, (String)"<this>");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return new PartitionKeyCondition<HashKey, SortKey>(attributeName, $this$eq, value2){
                @NotNull
                private final String expression;
                @NotNull
                private final Map<String, AttributeName> attributeNames;
                @NotNull
                private final Map<String, AttributeValue> attributeValues;
                {
                    this.expression = '#' + $attributeName + " = :" + $attributeName;
                    this.attributeNames = MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + $attributeName), (Object)$receiver.getName()));
                    this.attributeValues = MapsKt.mapOf((Pair)TuplesKt.to((Object)(':' + $attributeName), (Object)$receiver.asValue($value)));
                }

                @NotNull
                public String getExpression() {
                    return this.expression;
                }

                @NotNull
                public Map<String, AttributeName> getAttributeNames() {
                    return this.attributeNames;
                }

                @NotNull
                public Map<String, AttributeValue> getAttributeValues() {
                    return this.attributeValues;
                }
            };
        }

        private final sortKeyCondition.1<HashKey, SortKey> sortKeyCondition(String expr, Map<String, AttributeName> attrNames, Map<String, AttributeValue> attrValues) {
            return new SortKeyCondition<HashKey, SortKey>(expr, attrNames, attrValues){
                @NotNull
                private final String expression;
                @NotNull
                private final Map<String, AttributeName> attributeNames;
                @NotNull
                private final Map<String, AttributeValue> attributeValues;
                {
                    this.expression = $expr;
                    this.attributeNames = $attrNames;
                    this.attributeValues = $attrValues;
                }

                @NotNull
                public String getExpression() {
                    return this.expression;
                }

                @NotNull
                public Map<String, AttributeName> getAttributeNames() {
                    return this.attributeNames;
                }

                @NotNull
                public Map<String, AttributeValue> getAttributeValues() {
                    return this.attributeValues;
                }
            };
        }

        private final sortKeyCondition.1<HashKey, SortKey> sortKeyOperator(Attribute<SortKey> $this$sortKeyOperator, String op, SortKey value2) {
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return this.sortKeyCondition('#' + attributeName + ' ' + op + " :" + attributeName, MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)$this$sortKeyOperator.getName())), MapsKt.mapOf((Pair)TuplesKt.to((Object)(':' + attributeName), (Object)$this$sortKeyOperator.asValue(value2))));
        }

        @NotNull
        public final SortKeyCondition<HashKey, SortKey> lt(@NotNull Attribute<SortKey> $this$lt, @NotNull SortKey value2) {
            Intrinsics.checkNotNullParameter($this$lt, (String)"<this>");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return this.sortKeyOperator($this$lt, "<", value2);
        }

        @NotNull
        public final SortKeyCondition<HashKey, SortKey> le(@NotNull Attribute<SortKey> $this$le, @NotNull SortKey value2) {
            Intrinsics.checkNotNullParameter($this$le, (String)"<this>");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return this.sortKeyOperator($this$le, "<=", value2);
        }

        @NotNull
        public final SortKeyCondition<HashKey, SortKey> gt(@NotNull Attribute<SortKey> $this$gt, @NotNull SortKey value2) {
            Intrinsics.checkNotNullParameter($this$gt, (String)"<this>");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return this.sortKeyOperator($this$gt, ">", value2);
        }

        @NotNull
        public final SortKeyCondition<HashKey, SortKey> ge(@NotNull Attribute<SortKey> $this$ge, @NotNull SortKey value2) {
            Intrinsics.checkNotNullParameter($this$ge, (String)"<this>");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            return this.sortKeyOperator($this$ge, ">=", value2);
        }

        @NotNull
        public final SortKeyCondition<HashKey, SortKey> between(@NotNull Attribute<SortKey> attr, @NotNull SortKey value1, @NotNull SortKey value2) {
            Intrinsics.checkNotNullParameter(attr, (String)"attr");
            Intrinsics.checkNotNullParameter(value1, (String)"value1");
            Intrinsics.checkNotNullParameter(value2, (String)"value2");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)(':' + attributeName + '1'), (Object)attr.asValue(value1)), TuplesKt.to((Object)(':' + attributeName + '2'), (Object)attr.asValue(value2))};
            return this.sortKeyCondition('#' + attributeName + " BETWEEN :" + attributeName + "1 AND :" + attributeName + '2', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)attr.getName())), MapsKt.mapOf((Pair[])pairArray));
        }

        @NotNull
        public final SortKeyCondition<HashKey, SortKey> beginsWith(@NotNull Attribute<SortKey> $this$beginsWith, @NotNull SortKey value2) {
            Intrinsics.checkNotNullParameter($this$beginsWith, (String)"<this>");
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            String attributeName = DynamoDbScanAndQueryBuilder.this.nextAttributeName();
            boolean bl = false;
            return this.sortKeyCondition("begins_with(#" + attributeName + ",:" + attributeName + ')', MapsKt.mapOf((Pair)TuplesKt.to((Object)('#' + attributeName), (Object)$this$beginsWith.getName())), MapsKt.mapOf((Pair)TuplesKt.to((Object)(':' + attributeName), (Object)$this$beginsWith.asValue(value2))));
        }

        @NotNull
        public final CombinedKeyCondition<HashKey, SortKey> and(@NotNull PartitionKeyCondition<HashKey, SortKey> $this$and, @Nullable SortKeyCondition<HashKey, SortKey> secondary) {
            Intrinsics.checkNotNullParameter($this$and, (String)"<this>");
            PartitionKeyCondition it = $this$and;
            boolean bl = false;
            return secondary == null ? (CombinedKeyCondition)$this$and : (CombinedKeyCondition)new CombinedKeyCondition<HashKey, SortKey>(it, secondary){
                @NotNull
                private final String expression;
                @NotNull
                private final Map<String, AttributeName> attributeNames;
                @NotNull
                private final Map<String, AttributeValue> attributeValues;
                {
                    this.expression = $it.getExpression() + " AND " + $secondary.getExpression();
                    this.attributeNames = MapsKt.plus($it.getAttributeNames(), $secondary.getAttributeNames());
                    this.attributeValues = MapsKt.plus($it.getAttributeValues(), $secondary.getAttributeValues());
                }

                @NotNull
                public String getExpression() {
                    return this.expression;
                }

                @NotNull
                public Map<String, AttributeName> getAttributeNames() {
                    return this.attributeNames;
                }

                @NotNull
                public Map<String, AttributeValue> getAttributeValues() {
                    return this.attributeValues;
                }
            };
        }
    }
}

