// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.Throws
import org.http4k.connect.amazon.core.model.Base64Blob
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.kms.model.SigningAlgorithm
import se.ansman.kotshi.KotshiUtils
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

internal class KotshiVerifyJsonAdapter(
  moshi: Moshi
) : NamedJsonAdapter<Verify>("KotshiJsonAdapter(Verify)") {
  private val kMSKeyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(KMSKeyId::class.javaObjectType)

  private val base64BlobAdapter: JsonAdapter<Base64Blob> =
      moshi.adapter(Base64Blob::class.javaObjectType)

  private val signingAlgorithmAdapter: JsonAdapter<SigningAlgorithm> =
      moshi.adapter(SigningAlgorithm::class.javaObjectType)

  private val stringListAdapter: JsonAdapter<List<String>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      String::class.javaObjectType))

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "Message",
      "Signature",
      "SigningAlgorithm",
      "MessageType",
      "GrantTokens"
  )

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, value: Verify?): Unit {
    if (value == null) {
      writer.nullValue()
      return
    }
    writer.beginObject()
    writer.name("KeyId")
    kMSKeyIdAdapter.toJson(writer, value.KeyId)
    writer.name("Message")
    base64BlobAdapter.toJson(writer, value.Message)
    writer.name("Signature")
    base64BlobAdapter.toJson(writer, value.Signature)
    writer.name("SigningAlgorithm")
    signingAlgorithmAdapter.toJson(writer, value.SigningAlgorithm)
    writer.name("MessageType")
    writer.value(value.MessageType)
    writer.name("GrantTokens")
    stringListAdapter.toJson(writer, value.GrantTokens)
    writer.endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): Verify? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var KeyId: KMSKeyId? = null
    var Message: Base64Blob? = null
    var Signature: Base64Blob? = null
    var SigningAlgorithm: SigningAlgorithm? = null
    var MessageType: String? = null
    var MessageTypeIsSet: Boolean = false
    var GrantTokens: List<String>? = null
    var GrantTokensIsSet: Boolean = false

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          KeyId = kMSKeyIdAdapter.fromJson(reader)
        }
        1 -> {
          Message = base64BlobAdapter.fromJson(reader)
        }
        2 -> {
          Signature = base64BlobAdapter.fromJson(reader)
        }
        3 -> {
          SigningAlgorithm = signingAlgorithmAdapter.fromJson(reader)
        }
        4 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            MessageType = reader.nextString()
          }
          MessageTypeIsSet = true
        }
        5 -> {
          GrantTokens = stringListAdapter.fromJson(reader)
          GrantTokensIsSet = true
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (KeyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (Message == null) {
      errorBuilder = errorBuilder.appendNullableError("Message")
    }
    if (Signature == null) {
      errorBuilder = errorBuilder.appendNullableError("Signature")
    }
    if (SigningAlgorithm == null) {
      errorBuilder = errorBuilder.appendNullableError("SigningAlgorithm")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return Verify(
        KeyId = KeyId!!,
        Message = Message!!,
        Signature = Signature!!,
        SigningAlgorithm = SigningAlgorithm!!
    ).let {
      it.copy(
          MessageType = if (MessageTypeIsSet) MessageType else it.MessageType,
          GrantTokens = if (GrantTokensIsSet) GrantTokens else it.GrantTokens
      )
    }
  }
}
