// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Boolean
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.Throws
import org.http4k.connect.amazon.core.model.Base64Blob
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.kms.model.CustomerMasterKeySpec
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm
import org.http4k.connect.amazon.kms.model.KeyUsage
import org.http4k.connect.amazon.kms.model.SigningAlgorithm
import se.ansman.kotshi.KotshiUtils
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

internal class KotshiPublicKeyJsonAdapter(
  moshi: Moshi
) : NamedJsonAdapter<PublicKey>("KotshiJsonAdapter(PublicKey)") {
  private val kMSKeyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(KMSKeyId::class.javaObjectType)

  private val customerMasterKeySpecAdapter: JsonAdapter<CustomerMasterKeySpec> =
      moshi.adapter(CustomerMasterKeySpec::class.javaObjectType)

  private val encryptionAlgorithmListAdapter: JsonAdapter<List<EncryptionAlgorithm>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      EncryptionAlgorithm::class.javaObjectType))

  private val keyUsageAdapter: JsonAdapter<KeyUsage> = moshi.adapter(KeyUsage::class.javaObjectType)

  private val base64BlobAdapter: JsonAdapter<Base64Blob> =
      moshi.adapter(Base64Blob::class.javaObjectType)

  private val signingAlgorithmListAdapter: JsonAdapter<List<SigningAlgorithm>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      SigningAlgorithm::class.javaObjectType))

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "CustomerMasterKeySpec",
      "EncryptionAlgorithms",
      "KeyUsage",
      "PublicKey",
      "SigningAlgorithms"
  )

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, value: PublicKey?): Unit {
    if (value == null) {
      writer.nullValue()
      return
    }
    writer.beginObject()
    writer.name("KeyId")
    kMSKeyIdAdapter.toJson(writer, value.KeyId)
    writer.name("CustomerMasterKeySpec")
    customerMasterKeySpecAdapter.toJson(writer, value.CustomerMasterKeySpec)
    writer.name("EncryptionAlgorithms")
    encryptionAlgorithmListAdapter.toJson(writer, value.EncryptionAlgorithms)
    writer.name("KeyUsage")
    keyUsageAdapter.toJson(writer, value.KeyUsage)
    writer.name("PublicKey")
    base64BlobAdapter.toJson(writer, value.PublicKey)
    writer.name("SigningAlgorithms")
    signingAlgorithmListAdapter.toJson(writer, value.SigningAlgorithms)
    writer.endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): PublicKey? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var KeyId: KMSKeyId? = null
    var CustomerMasterKeySpec: CustomerMasterKeySpec? = null
    var EncryptionAlgorithms: List<EncryptionAlgorithm>? = null
    var KeyUsage: KeyUsage? = null
    var PublicKey: Base64Blob? = null
    var SigningAlgorithms: List<SigningAlgorithm>? = null
    var SigningAlgorithmsIsSet: Boolean = false

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          KeyId = kMSKeyIdAdapter.fromJson(reader)
        }
        1 -> {
          CustomerMasterKeySpec = customerMasterKeySpecAdapter.fromJson(reader)
        }
        2 -> {
          EncryptionAlgorithms = encryptionAlgorithmListAdapter.fromJson(reader)
        }
        3 -> {
          KeyUsage = keyUsageAdapter.fromJson(reader)
        }
        4 -> {
          PublicKey = base64BlobAdapter.fromJson(reader)
        }
        5 -> {
          SigningAlgorithms = signingAlgorithmListAdapter.fromJson(reader)
          SigningAlgorithmsIsSet = true
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (KeyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (CustomerMasterKeySpec == null) {
      errorBuilder = errorBuilder.appendNullableError("CustomerMasterKeySpec")
    }
    if (EncryptionAlgorithms == null) {
      errorBuilder = errorBuilder.appendNullableError("EncryptionAlgorithms")
    }
    if (KeyUsage == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyUsage")
    }
    if (PublicKey == null) {
      errorBuilder = errorBuilder.appendNullableError("PublicKey")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return PublicKey(
        KeyId = KeyId!!,
        CustomerMasterKeySpec = CustomerMasterKeySpec!!,
        EncryptionAlgorithms = EncryptionAlgorithms!!,
        KeyUsage = KeyUsage!!,
        PublicKey = PublicKey!!
    ).let {
      it.copy(
          SigningAlgorithms = if (SigningAlgorithmsIsSet) SigningAlgorithms else
              it.SigningAlgorithms
      )
    }
  }
}
