// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.model

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.Throws
import org.http4k.connect.amazon.core.model.ARN
import org.http4k.connect.amazon.core.model.AwsAccount
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.core.model.Timestamp
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

internal class KotshiKeyMetadataJsonAdapter(
  moshi: Moshi
) : NamedJsonAdapter<KeyMetadata>("KotshiJsonAdapter(KeyMetadata)") {
  private val kMSKeyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(KMSKeyId::class.javaObjectType)

  private val aRNAdapter: JsonAdapter<ARN> = moshi.adapter(ARN::class.javaObjectType)

  private val awsAccountAdapter: JsonAdapter<AwsAccount> =
      moshi.adapter(AwsAccount::class.javaObjectType)

  private val keyUsageAdapter: JsonAdapter<KeyUsage> = moshi.adapter(KeyUsage::class.javaObjectType)

  private val encryptionAlgorithmListAdapter: JsonAdapter<List<EncryptionAlgorithm>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      EncryptionAlgorithm::class.javaObjectType))

  private val signingAlgorithmListAdapter: JsonAdapter<List<SigningAlgorithm>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      SigningAlgorithm::class.javaObjectType))

  private val customerMasterKeySpecAdapter: JsonAdapter<CustomerMasterKeySpec> =
      moshi.adapter(CustomerMasterKeySpec::class.javaObjectType)

  private val timestampAdapter: JsonAdapter<Timestamp> =
      moshi.adapter(Timestamp::class.javaObjectType)

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "Arn",
      "AWSAccountId",
      "KeyUsage",
      "EncryptionAlgorithms",
      "SigningAlgorithms",
      "CustomerMasterKeySpec",
      "Enabled",
      "CreationDate",
      "CloudHsmClusterId",
      "CustomKeyStoreId",
      "DeletionDate",
      "Description",
      "ExpirationModel",
      "KeyManager",
      "KeyState",
      "Origin",
      "ValidTo"
  )

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, value: KeyMetadata?): Unit {
    if (value == null) {
      writer.nullValue()
      return
    }
    writer.beginObject()
    writer.name("KeyId")
    kMSKeyIdAdapter.toJson(writer, value.KeyId)
    writer.name("Arn")
    aRNAdapter.toJson(writer, value.Arn)
    writer.name("AWSAccountId")
    awsAccountAdapter.toJson(writer, value.AWSAccountId)
    writer.name("KeyUsage")
    keyUsageAdapter.toJson(writer, value.KeyUsage)
    writer.name("EncryptionAlgorithms")
    encryptionAlgorithmListAdapter.toJson(writer, value.EncryptionAlgorithms)
    writer.name("SigningAlgorithms")
    signingAlgorithmListAdapter.toJson(writer, value.SigningAlgorithms)
    writer.name("CustomerMasterKeySpec")
    customerMasterKeySpecAdapter.toJson(writer, value.CustomerMasterKeySpec)
    writer.name("Enabled")
    writer.value(value.Enabled)
    writer.name("CreationDate")
    timestampAdapter.toJson(writer, value.CreationDate)
    writer.name("CloudHsmClusterId")
    writer.value(value.CloudHsmClusterId)
    writer.name("CustomKeyStoreId")
    writer.value(value.CustomKeyStoreId)
    writer.name("DeletionDate")
    timestampAdapter.toJson(writer, value.DeletionDate)
    writer.name("Description")
    writer.value(value.Description)
    writer.name("ExpirationModel")
    writer.value(value.ExpirationModel)
    writer.name("KeyManager")
    writer.value(value.KeyManager)
    writer.name("KeyState")
    writer.value(value.KeyState)
    writer.name("Origin")
    writer.value(value.Origin)
    writer.name("ValidTo")
    timestampAdapter.toJson(writer, value.ValidTo)
    writer.endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): KeyMetadata? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var KeyId: KMSKeyId? = null
    var Arn: ARN? = null
    var ArnIsSet: Boolean = false
    var AWSAccountId: AwsAccount? = null
    var AWSAccountIdIsSet: Boolean = false
    var KeyUsage: KeyUsage? = null
    var KeyUsageIsSet: Boolean = false
    var EncryptionAlgorithms: List<EncryptionAlgorithm>? = null
    var EncryptionAlgorithmsIsSet: Boolean = false
    var SigningAlgorithms: List<SigningAlgorithm>? = null
    var SigningAlgorithmsIsSet: Boolean = false
    var CustomerMasterKeySpec: CustomerMasterKeySpec? = null
    var CustomerMasterKeySpecIsSet: Boolean = false
    var Enabled: Boolean? = null
    var EnabledIsSet: Boolean = false
    var CreationDate: Timestamp? = null
    var CreationDateIsSet: Boolean = false
    var CloudHsmClusterId: String? = null
    var CloudHsmClusterIdIsSet: Boolean = false
    var CustomKeyStoreId: String? = null
    var CustomKeyStoreIdIsSet: Boolean = false
    var DeletionDate: Timestamp? = null
    var DeletionDateIsSet: Boolean = false
    var Description: String? = null
    var DescriptionIsSet: Boolean = false
    var ExpirationModel: String? = null
    var ExpirationModelIsSet: Boolean = false
    var KeyManager: String? = null
    var KeyManagerIsSet: Boolean = false
    var KeyState: String? = null
    var KeyStateIsSet: Boolean = false
    var Origin: String? = null
    var OriginIsSet: Boolean = false
    var ValidTo: Timestamp? = null
    var ValidToIsSet: Boolean = false

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          KeyId = kMSKeyIdAdapter.fromJson(reader)
        }
        1 -> {
          Arn = aRNAdapter.fromJson(reader)
          ArnIsSet = true
        }
        2 -> {
          AWSAccountId = awsAccountAdapter.fromJson(reader)
          AWSAccountIdIsSet = true
        }
        3 -> {
          KeyUsage = keyUsageAdapter.fromJson(reader)
          KeyUsageIsSet = true
        }
        4 -> {
          EncryptionAlgorithms = encryptionAlgorithmListAdapter.fromJson(reader)
          EncryptionAlgorithmsIsSet = true
        }
        5 -> {
          SigningAlgorithms = signingAlgorithmListAdapter.fromJson(reader)
          SigningAlgorithmsIsSet = true
        }
        6 -> {
          CustomerMasterKeySpec = customerMasterKeySpecAdapter.fromJson(reader)
          CustomerMasterKeySpecIsSet = true
        }
        7 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            Enabled = reader.nextBoolean()
          }
          EnabledIsSet = true
        }
        8 -> {
          CreationDate = timestampAdapter.fromJson(reader)
          CreationDateIsSet = true
        }
        9 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            CloudHsmClusterId = reader.nextString()
          }
          CloudHsmClusterIdIsSet = true
        }
        10 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            CustomKeyStoreId = reader.nextString()
          }
          CustomKeyStoreIdIsSet = true
        }
        11 -> {
          DeletionDate = timestampAdapter.fromJson(reader)
          DeletionDateIsSet = true
        }
        12 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            Description = reader.nextString()
          }
          DescriptionIsSet = true
        }
        13 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            ExpirationModel = reader.nextString()
          }
          ExpirationModelIsSet = true
        }
        14 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            KeyManager = reader.nextString()
          }
          KeyManagerIsSet = true
        }
        15 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            KeyState = reader.nextString()
          }
          KeyStateIsSet = true
        }
        16 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            Origin = reader.nextString()
          }
          OriginIsSet = true
        }
        17 -> {
          ValidTo = timestampAdapter.fromJson(reader)
          ValidToIsSet = true
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (KeyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return KeyMetadata(
        KeyId = KeyId!!
    ).let {
      it.copy(
          Arn = if (ArnIsSet) Arn else it.Arn,
          AWSAccountId = if (AWSAccountIdIsSet) AWSAccountId else it.AWSAccountId,
          KeyUsage = if (KeyUsageIsSet) KeyUsage else it.KeyUsage,
          EncryptionAlgorithms = if (EncryptionAlgorithmsIsSet) EncryptionAlgorithms else
              it.EncryptionAlgorithms,
          SigningAlgorithms = if (SigningAlgorithmsIsSet) SigningAlgorithms else
              it.SigningAlgorithms,
          CustomerMasterKeySpec = if (CustomerMasterKeySpecIsSet) CustomerMasterKeySpec else
              it.CustomerMasterKeySpec,
          Enabled = if (EnabledIsSet) Enabled else it.Enabled,
          CreationDate = if (CreationDateIsSet) CreationDate else it.CreationDate,
          CloudHsmClusterId = if (CloudHsmClusterIdIsSet) CloudHsmClusterId else
              it.CloudHsmClusterId,
          CustomKeyStoreId = if (CustomKeyStoreIdIsSet) CustomKeyStoreId else it.CustomKeyStoreId,
          DeletionDate = if (DeletionDateIsSet) DeletionDate else it.DeletionDate,
          Description = if (DescriptionIsSet) Description else it.Description,
          ExpirationModel = if (ExpirationModelIsSet) ExpirationModel else it.ExpirationModel,
          KeyManager = if (KeyManagerIsSet) KeyManager else it.KeyManager,
          KeyState = if (KeyStateIsSet) KeyState else it.KeyState,
          Origin = if (OriginIsSet) Origin else it.Origin,
          ValidTo = if (ValidToIsSet) ValidTo else it.ValidTo
      )
    }
  }
}
