// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.Throws
import org.http4k.connect.amazon.core.model.Base64Blob
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm
import se.ansman.kotshi.KotshiUtils
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

internal class KotshiEncryptJsonAdapter(
  moshi: Moshi
) : NamedJsonAdapter<Encrypt>("KotshiJsonAdapter(Encrypt)") {
  private val kMSKeyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(KMSKeyId::class.javaObjectType)

  private val base64BlobAdapter: JsonAdapter<Base64Blob> =
      moshi.adapter(Base64Blob::class.javaObjectType)

  private val encryptionAlgorithmAdapter: JsonAdapter<EncryptionAlgorithm> =
      moshi.adapter(EncryptionAlgorithm::class.javaObjectType)

  private val stringStringMapAdapter: JsonAdapter<Map<String, String>> =
      moshi.adapter(Types.newParameterizedType(Map::class.javaObjectType,
      String::class.javaObjectType, String::class.javaObjectType))

  private val stringListAdapter: JsonAdapter<List<String>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      String::class.javaObjectType))

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "Plaintext",
      "EncryptionAlgorithm",
      "EncryptionContext",
      "GrantTokens"
  )

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, value: Encrypt?): Unit {
    if (value == null) {
      writer.nullValue()
      return
    }
    writer.beginObject()
    writer.name("KeyId")
    kMSKeyIdAdapter.toJson(writer, value.KeyId)
    writer.name("Plaintext")
    base64BlobAdapter.toJson(writer, value.Plaintext)
    writer.name("EncryptionAlgorithm")
    encryptionAlgorithmAdapter.toJson(writer, value.EncryptionAlgorithm)
    writer.name("EncryptionContext")
    stringStringMapAdapter.toJson(writer, value.EncryptionContext)
    writer.name("GrantTokens")
    stringListAdapter.toJson(writer, value.GrantTokens)
    writer.endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): Encrypt? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var KeyId: KMSKeyId? = null
    var Plaintext: Base64Blob? = null
    var EncryptionAlgorithm: EncryptionAlgorithm? = null
    var EncryptionAlgorithmIsSet: Boolean = false
    var EncryptionContext: Map<String, String>? = null
    var EncryptionContextIsSet: Boolean = false
    var GrantTokens: List<String>? = null
    var GrantTokensIsSet: Boolean = false

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          KeyId = kMSKeyIdAdapter.fromJson(reader)
        }
        1 -> {
          Plaintext = base64BlobAdapter.fromJson(reader)
        }
        2 -> {
          EncryptionAlgorithm = encryptionAlgorithmAdapter.fromJson(reader)
          EncryptionAlgorithmIsSet = true
        }
        3 -> {
          EncryptionContext = stringStringMapAdapter.fromJson(reader)
          EncryptionContextIsSet = true
        }
        4 -> {
          GrantTokens = stringListAdapter.fromJson(reader)
          GrantTokensIsSet = true
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (KeyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (Plaintext == null) {
      errorBuilder = errorBuilder.appendNullableError("Plaintext")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return Encrypt(
        KeyId = KeyId!!,
        Plaintext = Plaintext!!
    ).let {
      it.copy(
          EncryptionAlgorithm = if (EncryptionAlgorithmIsSet) EncryptionAlgorithm else
              it.EncryptionAlgorithm,
          EncryptionContext = if (EncryptionContextIsSet) EncryptionContext else
              it.EncryptionContext,
          GrantTokens = if (GrantTokensIsSet) GrantTokens else it.GrantTokens
      )
    }
  }
}
