/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.kms.action;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.amazon.core.model.Base64Blob;
import org.http4k.connect.amazon.core.model.KMSKeyId;
import org.http4k.connect.amazon.kms.action.Decrypted;
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/connect/amazon/kms/action/KotshiDecryptedJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/connect/amazon/kms/action/Decrypted;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "base64BlobAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/connect/amazon/core/model/Base64Blob;", "encryptionAlgorithmAdapter", "Lorg/http4k/connect/amazon/kms/model/EncryptionAlgorithm;", "kMSKeyIdAdapter", "Lorg/http4k/connect/amazon/core/model/KMSKeyId;", "options", "Lcom/squareup/moshi/JsonReader$Options;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "http4k-connect-amazon-kms"})
@InternalKotshiApi
public final class KotshiDecryptedJsonAdapter
extends NamedJsonAdapter<Decrypted> {
    @NotNull
    private final JsonAdapter<KMSKeyId> kMSKeyIdAdapter;
    @NotNull
    private final JsonAdapter<Base64Blob> base64BlobAdapter;
    @NotNull
    private final JsonAdapter<EncryptionAlgorithm> encryptionAlgorithmAdapter;
    @NotNull
    private final JsonReader.Options options;

    public KotshiDecryptedJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Decrypted)");
        JsonAdapter jsonAdapter = moshi.adapter(KMSKeyId.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(KMSKeyId::class.javaObjectType)");
        this.kMSKeyIdAdapter = jsonAdapter;
        jsonAdapter = moshi.adapter(Base64Blob.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(Base64Blob::class.javaObjectType)");
        this.base64BlobAdapter = jsonAdapter;
        jsonAdapter = moshi.adapter(EncryptionAlgorithm.class);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(Encryption\u2026hm::class.javaObjectType)");
        this.encryptionAlgorithmAdapter = jsonAdapter;
        String[] stringArray = new String[]{"KeyId", "Plaintext", "EncryptionAlgorithm"};
        jsonAdapter = JsonReader.Options.of((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"of(\n      \"KeyId\",\n     \u2026\"EncryptionAlgorithm\"\n  )");
        this.options = jsonAdapter;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Decrypted value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        writer.name("KeyId");
        this.kMSKeyIdAdapter.toJson(writer, (Object)value.getKeyId());
        writer.name("Plaintext");
        this.base64BlobAdapter.toJson(writer, (Object)value.getPlaintext());
        writer.name("EncryptionAlgorithm");
        this.encryptionAlgorithmAdapter.toJson(writer, (Object)value.getEncryptionAlgorithm());
        writer.endObject();
    }

    @Nullable
    public Decrypted fromJson(@NotNull JsonReader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Decrypted)reader.nextNull();
        }
        KMSKeyId KeyId = null;
        Base64Blob Plaintext = null;
        EncryptionAlgorithm EncryptionAlgorithm2 = null;
        reader.beginObject();
        while (reader.hasNext()) {
            int n = reader.selectName(this.options);
            switch (n) {
                case 0: {
                    KeyId = (KMSKeyId)this.kMSKeyIdAdapter.fromJson(reader);
                    break;
                }
                case 1: {
                    Plaintext = (Base64Blob)this.base64BlobAdapter.fromJson(reader);
                    break;
                }
                case 2: {
                    EncryptionAlgorithm2 = (EncryptionAlgorithm)((Object)this.encryptionAlgorithmAdapter.fromJson(reader));
                    break;
                }
                case -1: {
                    reader.skipName();
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        StringBuilder errorBuilder = null;
        if (KeyId == null) {
            errorBuilder = KotshiUtils.appendNullableError$default(errorBuilder, (String)"KeyId", null, (int)2, null);
        }
        if (Plaintext == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"Plaintext", null, (int)2, null);
        }
        if (EncryptionAlgorithm2 == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"EncryptionAlgorithm", null, (int)2, null);
        }
        if (errorBuilder != null) {
            errorBuilder.append(" (at path ").append(reader.getPath()).append(')');
            throw new JsonDataException(errorBuilder.toString());
        }
        KMSKeyId kMSKeyId = KeyId;
        Intrinsics.checkNotNull((Object)kMSKeyId);
        Base64Blob base64Blob = Plaintext;
        Intrinsics.checkNotNull((Object)base64Blob);
        EncryptionAlgorithm encryptionAlgorithm = EncryptionAlgorithm2;
        Intrinsics.checkNotNull((Object)((Object)encryptionAlgorithm));
        return new Decrypted(kMSKeyId, base64Blob, encryptionAlgorithm);
    }
}

