// Code generated by Kotshi. Do not edit.
package org.http4k.connect.amazon.kms.action

import com.squareup.moshi.JsonAdapter
import com.squareup.moshi.JsonDataException
import com.squareup.moshi.JsonReader
import com.squareup.moshi.JsonWriter
import com.squareup.moshi.Moshi
import com.squareup.moshi.Types
import java.io.IOException
import java.lang.StringBuilder
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.Throws
import org.http4k.connect.amazon.core.model.Base64Blob
import org.http4k.connect.amazon.core.model.KMSKeyId
import org.http4k.connect.amazon.kms.model.SigningAlgorithm
import se.ansman.kotshi.KotshiUtils
import se.ansman.kotshi.KotshiUtils.appendNullableError
import se.ansman.kotshi.NamedJsonAdapter

internal class KotshiSignJsonAdapter(
  moshi: Moshi
) : NamedJsonAdapter<Sign>("KotshiJsonAdapter(Sign)") {
  private val kMSKeyIdAdapter: JsonAdapter<KMSKeyId> = moshi.adapter(KMSKeyId::class.javaObjectType)

  private val base64BlobAdapter: JsonAdapter<Base64Blob> =
      moshi.adapter(Base64Blob::class.javaObjectType)

  private val signingAlgorithmAdapter: JsonAdapter<SigningAlgorithm> =
      moshi.adapter(SigningAlgorithm::class.javaObjectType)

  private val stringListAdapter: JsonAdapter<List<String>> =
      moshi.adapter(Types.newParameterizedType(List::class.javaObjectType,
      String::class.javaObjectType))

  private val options: JsonReader.Options = JsonReader.Options.of(
      "KeyId",
      "Message",
      "SigningAlgorithm",
      "Request",
      "MessageType"
  )

  @Throws(IOException::class)
  public override fun toJson(writer: JsonWriter, value: Sign?): Unit {
    if (value == null) {
      writer.nullValue()
      return
    }
    writer.beginObject()
    writer.name("KeyId")
    kMSKeyIdAdapter.toJson(writer, value.KeyId)
    writer.name("Message")
    base64BlobAdapter.toJson(writer, value.Message)
    writer.name("SigningAlgorithm")
    signingAlgorithmAdapter.toJson(writer, value.SigningAlgorithm)
    writer.name("Request")
    stringListAdapter.toJson(writer, value.Request)
    writer.name("MessageType")
    writer.value(value.MessageType)
    writer.endObject()
  }

  @Throws(IOException::class)
  public override fun fromJson(reader: JsonReader): Sign? {
    if (reader.peek() == JsonReader.Token.NULL) return reader.nextNull()

    var KeyId: KMSKeyId? = null
    var Message: Base64Blob? = null
    var SigningAlgorithm: SigningAlgorithm? = null
    var Request: List<String>? = null
    var RequestIsSet: Boolean = false
    var MessageType: String? = null
    var MessageTypeIsSet: Boolean = false

    reader.beginObject()
    while (reader.hasNext()) {
      when (reader.selectName(options)) {
        0 -> {
          KeyId = kMSKeyIdAdapter.fromJson(reader)
        }
        1 -> {
          Message = base64BlobAdapter.fromJson(reader)
        }
        2 -> {
          SigningAlgorithm = signingAlgorithmAdapter.fromJson(reader)
        }
        3 -> {
          Request = stringListAdapter.fromJson(reader)
          RequestIsSet = true
        }
        4 -> {
          if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue()
          } else {
            MessageType = reader.nextString()
          }
          MessageTypeIsSet = true
        }
        -1 -> {
          reader.skipName()
          reader.skipValue()
        }
      }
    }
    reader.endObject()

    var errorBuilder: StringBuilder? = null
    if (KeyId == null) {
      errorBuilder = errorBuilder.appendNullableError("KeyId")
    }
    if (Message == null) {
      errorBuilder = errorBuilder.appendNullableError("Message")
    }
    if (SigningAlgorithm == null) {
      errorBuilder = errorBuilder.appendNullableError("SigningAlgorithm")
    }
    if (errorBuilder != null) {
      errorBuilder.append(" (at path ").append(reader.path).append(')')
      throw JsonDataException(errorBuilder.toString())
    }

    return Sign(
        KeyId = KeyId!!,
        Message = Message!!,
        SigningAlgorithm = SigningAlgorithm!!
    ).let {
      it.copy(
          Request = if (RequestIsSet) Request else it.Request,
          MessageType = if (MessageTypeIsSet) MessageType else it.MessageType
      )
    }
  }
}
