/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.connect.amazon.kms.action;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.connect.amazon.core.model.Base64Blob;
import org.http4k.connect.amazon.core.model.KMSKeyId;
import org.http4k.connect.amazon.kms.action.Decrypted;
import org.http4k.connect.amazon.kms.model.EncryptionAlgorithm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.KotshiUtils;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/http4k/connect/amazon/kms/action/KotshiDecryptedJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/connect/amazon/kms/action/Decrypted;", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "encryptionAlgorithmAdapter", "Lcom/squareup/moshi/JsonAdapter;", "Lorg/http4k/connect/amazon/kms/model/EncryptionAlgorithm;", "keyIdAdapter", "Lorg/http4k/connect/amazon/core/model/KMSKeyId;", "options", "Lcom/squareup/moshi/JsonReader$Options;", "plaintextAdapter", "Lorg/http4k/connect/amazon/core/model/Base64Blob;", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "http4k-connect-amazon-kms"})
@InternalKotshiApi
public final class KotshiDecryptedJsonAdapter
extends NamedJsonAdapter<Decrypted> {
    @NotNull
    private final JsonAdapter<KMSKeyId> keyIdAdapter;
    @NotNull
    private final JsonAdapter<Base64Blob> plaintextAdapter;
    @NotNull
    private final JsonAdapter<EncryptionAlgorithm> encryptionAlgorithmAdapter;
    @NotNull
    private final JsonReader.Options options;

    public KotshiDecryptedJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Decrypted)");
        JsonAdapter jsonAdapter = moshi.adapter((Type)((Object)KMSKeyId.class), SetsKt.emptySet(), "KeyId");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"moshi.adapter(\n      KMS\u2026etOf(),\n      \"KeyId\"\n  )");
        this.keyIdAdapter = jsonAdapter;
        JsonAdapter jsonAdapter2 = moshi.adapter((Type)((Object)Base64Blob.class), SetsKt.emptySet(), "Plaintext");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter2, (String)"moshi.adapter(\n      Bas\u2026(),\n      \"Plaintext\"\n  )");
        this.plaintextAdapter = jsonAdapter2;
        JsonAdapter jsonAdapter3 = moshi.adapter((Type)((Object)EncryptionAlgorithm.class), SetsKt.emptySet(), "EncryptionAlgorithm");
        Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter3, (String)"moshi.adapter(\n      Enc\u2026\"EncryptionAlgorithm\"\n  )");
        this.encryptionAlgorithmAdapter = jsonAdapter3;
        String[] stringArray = new String[]{"KeyId", "Plaintext", "EncryptionAlgorithm"};
        JsonReader.Options options = JsonReader.Options.of((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"of(\n      \"KeyId\",\n     \u2026\"EncryptionAlgorithm\"\n  )");
        this.options = options;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Decrypted value) throws IOException {
        JsonWriter jsonWriter;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
            return;
        }
        JsonWriter $this$toJson_u24lambda_u240 = jsonWriter = writer.beginObject().name("KeyId");
        boolean bl = false;
        this.keyIdAdapter.toJson($this$toJson_u24lambda_u240, (Object)value.getKeyId());
        JsonWriter $this$toJson_u24lambda_u241 = jsonWriter = jsonWriter.name("Plaintext");
        boolean bl2 = false;
        this.plaintextAdapter.toJson($this$toJson_u24lambda_u241, (Object)value.getPlaintext());
        JsonWriter $this$toJson_u24lambda_u242 = jsonWriter = jsonWriter.name("EncryptionAlgorithm");
        boolean bl3 = false;
        this.encryptionAlgorithmAdapter.toJson($this$toJson_u24lambda_u242, (Object)value.getEncryptionAlgorithm());
        jsonWriter.endObject();
    }

    @Nullable
    public Decrypted fromJson(@NotNull JsonReader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Decrypted)reader.nextNull();
        }
        KMSKeyId keyId = null;
        Base64Blob plaintext = null;
        EncryptionAlgorithm encryptionAlgorithm = null;
        reader.beginObject();
        while (reader.hasNext()) {
            switch (reader.selectName(this.options)) {
                case 0: {
                    keyId = (KMSKeyId)this.keyIdAdapter.fromJson(reader);
                    break;
                }
                case 1: {
                    plaintext = (Base64Blob)this.plaintextAdapter.fromJson(reader);
                    break;
                }
                case 2: {
                    encryptionAlgorithm = (EncryptionAlgorithm)((Object)this.encryptionAlgorithmAdapter.fromJson(reader));
                    break;
                }
                case -1: {
                    reader.skipName();
                    reader.skipValue();
                }
            }
        }
        reader.endObject();
        StringBuilder errorBuilder = null;
        if (keyId == null) {
            errorBuilder = KotshiUtils.appendNullableError$default(errorBuilder, (String)"KeyId", null, (int)2, null);
        }
        if (plaintext == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"Plaintext", null, (int)2, null);
        }
        if (encryptionAlgorithm == null) {
            errorBuilder = KotshiUtils.appendNullableError$default((StringBuilder)errorBuilder, (String)"EncryptionAlgorithm", null, (int)2, null);
        }
        if (errorBuilder != null) {
            errorBuilder.append(" (at path ").append(reader.getPath()).append(')');
            throw new JsonDataException(errorBuilder.toString());
        }
        KMSKeyId kMSKeyId = keyId;
        Intrinsics.checkNotNull((Object)kMSKeyId);
        Base64Blob base64Blob = plaintext;
        Intrinsics.checkNotNull((Object)base64Blob);
        EncryptionAlgorithm encryptionAlgorithm2 = encryptionAlgorithm;
        Intrinsics.checkNotNull((Object)((Object)encryptionAlgorithm2));
        return new Decrypted(kMSKeyId, base64Blob, encryptionAlgorithm2);
    }
}

